/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.dialogs;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.communication.api.ByteBlowerServer;
import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.communication.api.PacketDump;
import com.excentis.products.byteblower.gui.swt.Activator;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

final class DoCapture
extends Job {
    private static final String CAPTURE_JOB_NAME = "Capture traffic";
    private static final boolean USAGE_INFO = false;
    public static final int NO_SNAPLEN = 10000;
    private final AtomicBoolean continueCapture = new AtomicBoolean(true);
    private final String id;
    private final String bbInterface;
    private final String server;
    private long captureStart = 0L;
    private long capturedBytes = 0L;
    private String targetLocation = "";
    private final CaptureListener listen;
    private File storeFile;
    private String filter;
    private int snaplen;

    DoCapture(File storeFile, String bbInterface, String serverAddress, CaptureListener listen) {
        this(storeFile, bbInterface, serverAddress, listen, 10000, "");
    }

    DoCapture(File storeFile, String bbInterface, String serverAddress, CaptureListener listen, int snaplen, String filter) {
        super(CAPTURE_JOB_NAME);
        Random rand = new Random();
        long now = System.nanoTime();
        this.id = String.format("%d%d%d", rand.nextLong(), now, Runtime.getRuntime().totalMemory());
        this.bbInterface = bbInterface;
        this.server = serverAddress;
        this.listen = listen;
        this.storeFile = storeFile;
        this.filter = filter;
        this.snaplen = snaplen;
    }

    String getCaptureLocation() {
        return String.valueOf(this.server) + this.bbInterface;
    }

    public void stop() {
        this.continueCapture.set(false);
    }

    public void setTargetLocation(String targetLocation) {
        this.targetLocation = targetLocation;
    }

    private void doDebugFeedback(CAPTURESTATE state, String info, long bytes, double duration) {
    }

    private double duration() {
        return (double)(System.currentTimeMillis() - this.captureStart) / 1000.0;
    }

    private static void logMessage(String msg) {
        Status log = new Status(0, "com.excentis.products.byteblower.gui.swt", "DoCapture :: " + msg);
        Activator.getDefault().getLog().log((IStatus)log);
    }

    private void userFeedback(String msg, IProgressMonitor monitor) {
        this.listen.reportStatus(msg);
        monitor.beginTask(msg, -1);
    }

    protected IStatus run(IProgressMonitor monitor) {
        block6: {
            String intialMsg = String.format("Starting PCAP capture on interface %s on %s", this.bbInterface, this.server);
            DoCapture.logMessage(intialMsg);
            this.userFeedback("Starting to capture...", monitor);
            this.doDebugFeedback(CAPTURESTATE.START, "", 0L, 0.0);
            try {
                try {
                    this.userFeedback("Connecting to the ByteBlower Server...", monitor);
                    ByteBlower apiByteblower = ByteBlower.InstanceGet();
                    ByteBlowerServer apiServer = apiByteblower.ServerAdd(this.server);
                    PacketDump capture = apiServer.PacketDumpCreate(this.bbInterface);
                    this.safeSetLength(capture, monitor);
                    this.safeSetFilter(capture, monitor);
                    capture.Start(this.storeFile.getAbsolutePath());
                    this.captureStart = System.currentTimeMillis();
                    this.userFeedback("Capturing network traffic...", monitor);
                    while (this.continueCapture.get()) {
                        monitor.worked(1);
                        this.capturedBytes = capture.FileSizeGet();
                        this.listen.updateContents(this.capturedBytes, this.duration());
                        Thread.sleep(100L);
                        if (!monitor.isCanceled()) continue;
                        this.stop();
                    }
                    this.userFeedback("Stopping capture...", monitor);
                    capture.Stop();
                    this.doDebugFeedback(CAPTURESTATE.STOP, "", this.capturedBytes, this.duration());
                    this.userFeedback("Closing server connection...", monitor);
                    apiServer.PacketDumpDestroy(capture);
                    apiByteblower.ServerRemove(apiServer);
                }
                catch (Exception e) {
                    String expectioMsg = "Failed to capture network traffic: " + e.getMessage();
                    this.doDebugFeedback(CAPTURESTATE.EXCEPTION, expectioMsg, this.capturedBytes, this.duration());
                    this.userFeedback(expectioMsg, monitor);
                    DoCapture.logMessage(expectioMsg);
                    String logEndMsg = String.format("Stopping PCAP capture on interface %s on %s...", this.bbInterface, this.server);
                    DoCapture.logMessage(logEndMsg);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                String logEndMsg = String.format("Stopping PCAP capture on interface %s on %s...", this.bbInterface, this.server);
                DoCapture.logMessage(logEndMsg);
                throw throwable;
            }
            String logEndMsg = String.format("Stopping PCAP capture on interface %s on %s...", this.bbInterface, this.server);
            DoCapture.logMessage(logEndMsg);
        }
        this.userFeedback("Saving PCAP file...", monitor);
        this.moveTempFile(monitor);
        this.userFeedback("Finished", monitor);
        this.listen.stopped();
        return Status.OK_STATUS;
    }

    private void safeSetLength(PacketDump capture, IProgressMonitor monitor) {
        try {
            capture.SnapshotLengthSet(this.snaplen);
        }
        catch (ConfigError configError) {
            this.userFeedback("Failed to apply truncation. Capturing the whole frames.", monitor);
        }
    }

    private void safeSetFilter(PacketDump capture, IProgressMonitor monitor) {
        try {
            capture.FilterSet(this.filter);
        }
        catch (ConfigError configError) {
            this.userFeedback("Failed to apply the filter. Capture all packets.", monitor);
        }
    }

    private void moveTempFile(IProgressMonitor monitor) {
        if (this.targetLocation == null || this.targetLocation.isEmpty()) {
            return;
        }
        Path source = Paths.get(this.storeFile.getAbsolutePath(), new String[0]);
        Path destination = Paths.get(this.targetLocation, new String[0]);
        if (Files.exists(source, new LinkOption[0])) {
            Path currentPath = Paths.get(this.storeFile.getAbsolutePath(), new String[0]);
            Path targetPath = Paths.get(this.targetLocation, new String[0]);
            String expectionMsg = "";
            try {
                if (Files.exists(destination, new LinkOption[0]) && Files.isSameFile(source, destination)) {
                    return;
                }
                try {
                    expectionMsg = "Failed to copy PCAP file from\n" + currentPath + "\n to\n" + destination;
                    Files.copy(currentPath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                    expectionMsg = "Failed to delete temporary file.\n" + currentPath;
                    Files.delete(currentPath);
                    String finishStatus = "Finished\n" + this.storeFile.getAbsolutePath();
                    this.userFeedback(finishStatus, monitor);
                }
                catch (IOException e) {
                    expectionMsg = String.valueOf(expectionMsg) + "\n\n" + e.getMessage();
                    this.userFeedback(expectionMsg, monitor);
                    DoCapture.logMessage(expectionMsg);
                }
            }
            finally {
                this.storeFile = new File(this.targetLocation);
            }
        }
    }

    public File getCapturedFile() {
        return this.storeFile;
    }

    private static enum CAPTURESTATE {
        START,
        STOP,
        FINISHED,
        EXCEPTION;

    }

    static interface CaptureListener {
        public void updateContents(long var1, double var3);

        public void reportStatus(String var1);

        public void stopped();
    }
}

