/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.dialogs;

import com.excentis.products.byteblower.communication.api.ByteBlower;
import com.excentis.products.byteblower.communication.api.ByteBlowerServer;
import com.excentis.products.byteblower.communication.api.ConfigError;
import com.excentis.products.byteblower.communication.api.PacketDump;
import com.excentis.products.byteblower.communication.api.StringList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public class FilterVerify {
    private final String baseServerAddress;
    private final Job checkJob;
    private final AtomicReference<ValueConfig> toCheck;

    public FilterVerify(String bbServerAddress) {
        this.baseServerAddress = bbServerAddress;
        this.checkJob = new Job("Filter Checker"){

            protected IStatus run(IProgressMonitor arg0) {
                FilterVerify.this.checkFilter();
                return Status.OK_STATUS;
            }
        };
        this.checkJob.setSystem(true);
        this.toCheck = new AtomicReference();
    }

    public void isValidFilter(String filter, Consumer<Boolean> action) {
        this.isValidFilter(this.baseServerAddress, filter, action);
    }

    public void isValidFilter(String serverAddress, String filter, Consumer<Boolean> action) {
        ValueConfig config = new ValueConfig(serverAddress, filter, action);
        this.toCheck.set(config);
        this.checkJob.schedule();
    }

    private void checkFilter() {
        ValueConfig actualCheck = this.toCheck.getAndSet(null);
        if (actualCheck == null) {
            return;
        }
        boolean isValid = false;
        try {
            ByteBlower apiByteblower = ByteBlower.InstanceGet();
            ByteBlowerServer apiServer = apiByteblower.ServerAdd(actualCheck.serverAddress);
            StringList allInterfaces = apiServer.InterfaceNamesGet();
            if (allInterfaces.isEmpty()) {
                return;
            }
            String anyInterface = allInterfaces.get(0);
            PacketDump capture = apiServer.PacketDumpCreate(anyInterface);
            isValid = this.tryFilter(capture, actualCheck.filter);
            apiByteblower.ServerRemove(apiServer);
        }
        catch (Exception e) {
            Logger.getGlobal().log(Level.WARNING, "Another ByteBlower Exception occurred: ", e);
        }
        actualCheck.action.accept(isValid);
    }

    private boolean tryFilter(PacketDump capture, String bpfFilter) {
        boolean isValid = false;
        try {
            capture.FilterSet(bpfFilter);
            isValid = true;
        }
        catch (ConfigError configError) {
            Logger.getGlobal().info("Not a valid filter strings: " + bpfFilter);
        }
        return isValid;
    }

    private class ValueConfig {
        protected final String serverAddress;
        protected final String filter;
        protected final Consumer<Boolean> action;

        public ValueConfig(String serverAddress, String filter, Consumer<Boolean> action) {
            this.serverAddress = serverAddress;
            this.filter = filter;
            this.action = action;
        }
    }
}

