/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets;

import com.excentis.products.byteblower.gui.history.actions.ByteBlowerAction;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerGroupAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerUngroupAction;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.sorting.DynamicComparator;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerControlIdentifier;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import java.util.List;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPartSite;

public abstract class ByteBlowerViewerComposite<ViewedObjectClass>
extends ByteBlowerComposite
implements IByteBlowerViewerComposite,
ByteBlowerControlIdentifier {
    private String identifier;
    protected ColumnViewer columnViewer;
    private IByteBlowerViewerComposite parentComposite;
    private IByteBlowerFocusDispatcher focusDispatcher;
    private ByteBlowerNewAction<ViewedObjectClass> newAction;
    private ByteBlowerCutAction<ViewedObjectClass> cutAction;
    private ByteBlowerCopyAction<ViewedObjectClass> copyAction;
    private ByteBlowerPasteAction<ViewedObjectClass> pasteAction;
    private ByteBlowerDeleteAction<ViewedObjectClass> deleteAction;
    private ByteBlowerGroupAction<ViewedObjectClass> groupAction;
    private ByteBlowerUngroupAction<ViewedObjectClass> ungroupAction;
    protected IStatusLineManager statusLineManager;
    private ByteBlowerFilter viewerFilter;
    private ByteBlowerComparator viewerSorter;

    public ByteBlowerViewerComposite(Composite parent, String identifier, IByteBlowerFocusDispatcher focusDispatcher, IByteBlowerViewerComposite parentComposite) {
        super(parent, (IByteBlowerComposite)parentComposite);
        this.identifier = identifier;
        this.parentComposite = parentComposite;
        this.focusDispatcher = focusDispatcher;
        if (focusDispatcher != null && focusDispatcher.getSite() != null) {
            IWorkbenchPartSite site = focusDispatcher.getSite();
            IViewSite vSite = (IViewSite)site;
            IActionBars actionBars = vSite.getActionBars();
            this.statusLineManager = actionBars.getStatusLineManager();
        }
    }

    protected abstract String[] getColumnNames();

    protected abstract int[] getColumnWeights();

    protected abstract ByteBlowerNewAction<ViewedObjectClass> createNewAction();

    protected abstract ByteBlowerCutAction<ViewedObjectClass> createCutAction();

    protected abstract ByteBlowerCopyAction<ViewedObjectClass> createCopyAction();

    protected abstract ByteBlowerPasteAction<ViewedObjectClass> createPasteAction();

    protected abstract ByteBlowerDeleteAction<ViewedObjectClass> createDeleteAction();

    protected ByteBlowerGroupAction<ViewedObjectClass> createGroupAction() {
        return null;
    }

    protected ByteBlowerUngroupAction<ViewedObjectClass> createUngroupAction() {
        return null;
    }

    @Override
    public String getIdentifier() {
        return this.identifier;
    }

    public ByteBlowerNewAction<ViewedObjectClass> getNewAction() {
        if (this.newAction == null) {
            this.newAction = this.createNewAction();
            if (this.newAction != null) {
                this.newAction.update();
            }
        }
        return this.newAction;
    }

    public ByteBlowerCutAction<ViewedObjectClass> getCutAction() {
        if (this.cutAction == null) {
            this.cutAction = this.createCutAction();
            if (this.cutAction != null) {
                this.cutAction.update();
            }
        }
        return this.cutAction;
    }

    public ByteBlowerCopyAction<ViewedObjectClass> getCopyAction() {
        if (this.copyAction == null) {
            this.copyAction = this.createCopyAction();
            if (this.copyAction != null) {
                this.copyAction.update();
            }
        }
        return this.copyAction;
    }

    public ByteBlowerPasteAction<ViewedObjectClass> getPasteAction() {
        if (this.pasteAction == null) {
            this.pasteAction = this.createPasteAction();
            if (this.pasteAction != null) {
                this.pasteAction.update();
            }
        }
        return this.pasteAction;
    }

    public ByteBlowerDeleteAction<ViewedObjectClass> getDeleteAction() {
        if (this.deleteAction == null) {
            this.deleteAction = this.createDeleteAction();
            if (this.deleteAction != null) {
                this.deleteAction.update();
            }
        }
        return this.deleteAction;
    }

    public ByteBlowerGroupAction<ViewedObjectClass> getGroupAction() {
        if (this.groupAction == null) {
            this.groupAction = this.createGroupAction();
            if (this.groupAction != null) {
                this.groupAction.update();
            }
        }
        return this.groupAction;
    }

    public ByteBlowerUngroupAction<ViewedObjectClass> getUngroupAction() {
        if (this.ungroupAction == null) {
            this.ungroupAction = this.createUngroupAction();
            if (this.ungroupAction != null) {
                this.ungroupAction.update();
            }
        }
        return this.ungroupAction;
    }

    public void addSelectionListener(final IByteBlowerComposite childComposite) {
        this.columnViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                childComposite.parentSelectionChanged(event);
            }
        });
    }

    public abstract int getFirstSelectedIndex();

    public ViewedObjectClass getFirstSelectedObject() {
        StructuredSelection currentSelection = this.getStructuredSelection();
        return (ViewedObjectClass)currentSelection.getFirstElement();
    }

    public List<ViewedObjectClass> getSelectedObjects() {
        StructuredSelection currentSelection = this.getStructuredSelection();
        return currentSelection.toList();
    }

    protected void setColumnViewer(ColumnViewer columnViewer) {
        this.columnViewer = columnViewer;
        columnViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ByteBlowerViewerComposite.this.viewerSelectionChanged(event);
            }
        });
    }

    public IByteBlowerViewerComposite getParentByteBlowerComposite() {
        return this.parentComposite;
    }

    @Override
    public StructuredViewer getParentViewer() {
        if (this.parentComposite == null) {
            return null;
        }
        return this.parentComposite.getStructuredViewer();
    }

    public StructuredSelection getStructuredSelection() {
        if (this.columnViewer == null || this.isDisposed()) {
            return StructuredSelection.EMPTY;
        }
        ISelection selection = this.columnViewer.getSelection();
        if (selection == null) {
            return StructuredSelection.EMPTY;
        }
        return (StructuredSelection)selection;
    }

    public void setSelection(StructuredSelection selection) {
        this.columnViewer.setSelection((ISelection)selection);
    }

    protected abstract Class<?> getParentClass();

    @Override
    public void focusGained(FocusEvent e) {
        boolean update = false;
        if (this.hasFocusDispatcher()) {
            update = this.focusDispatcher.getCurrentFocusComposite() != this;
            this.updateFocus();
        }
        if (update) {
            this.updateAllActions();
        }
    }

    protected boolean hasFocusDispatcher() {
        return this.focusDispatcher != null;
    }

    private void updateFocus() {
        this.focusDispatcher.setCurrentFocusWidget((IByteBlowerComposite)this);
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void addSelectionListener(ISelectionChangedListener listener) {
        if (this.columnViewer != null) {
            this.columnViewer.addSelectionChangedListener(listener);
        }
    }

    public void removeSelectionListener(ISelectionChangedListener listener) {
        if (this.columnViewer != null) {
            this.columnViewer.removeSelectionChangedListener(listener);
        }
    }

    public EByteBlowerObject getCurrentParentObject() {
        return this.focusDispatcher.getCurrentParentObject();
    }

    public Object getCurrentInput() {
        return this.columnViewer.getInput();
    }

    public void setInput(final Object inputObject) {
        if (this.isDisposed()) {
            System.out.println("ByteBlowerViewerComposite::setInput : setting input on disposed composite");
            return;
        }
        if (this.columnViewer.getContentProvider() == null) {
            System.out.println("ByteBlowerViewerComposite::setInput : contentprovider is NULL");
            return;
        }
        if (!this.isDisposed()) {
            this.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!ByteBlowerViewerComposite.this.isDisposed()) {
                        ByteBlowerViewerComposite.this.columnViewer.setInput(inputObject);
                    }
                    ByteBlowerViewerComposite.this.updateAllActions();
                }
            });
        }
    }

    @Override
    protected void projectChanged(ByteBlowerProject project) {
        this.setInput(project);
    }

    protected void resetInput() {
        this.setInput(null);
    }

    protected void updateAllActions() {
        ByteBlowerAction currentUngroup;
        ByteBlowerAction currentGroup;
        ByteBlowerAction currentPaste;
        ByteBlowerAction currentCopy;
        ByteBlowerAction currentCut;
        ByteBlowerAction currentDelete;
        ByteBlowerAction currentNew = this.getNewAction();
        if (currentNew != null) {
            currentNew.update();
        }
        if ((currentDelete = this.getDeleteAction()) != null) {
            currentDelete.update();
        }
        if ((currentCut = this.getCutAction()) != null) {
            currentCut.update();
        }
        if ((currentCopy = this.getCopyAction()) != null) {
            currentCopy.update();
        }
        if ((currentPaste = this.getPasteAction()) != null) {
            currentPaste.update();
        }
        if ((currentGroup = this.getGroupAction()) != null) {
            currentGroup.update();
        }
        if ((currentUngroup = this.getUngroupAction()) != null) {
            currentUngroup.update();
        }
    }

    public void viewerSelectionChanged(SelectionChangedEvent event) {
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ByteBlowerViewerComposite.this.updateAllActions();
                ByteBlowerViewerComposite.this.updateStatusLine();
            }
        });
    }

    public abstract void hardRefresh();

    public boolean hasInput() {
        return this.getInput() != null;
    }

    public Object getInput() {
        if (this.columnViewer == null) {
            return null;
        }
        return this.columnViewer.getInput();
    }

    protected void updateStatusLine() {
        if (this.statusLineManager == null) {
            return;
        }
        int selSize = this.columnViewer.getStructuredSelection().size();
        if (selSize == 0) {
            this.statusLineManager.setMessage(null);
        } else {
            this.statusLineManager.setMessage("Selected " + selSize + (selSize == 1 ? " item" : " items"));
        }
    }

    public ByteBlowerFilter getViewerFilter() {
        if (this.viewerFilter == null) {
            this.viewerFilter = this.createViewerFilter();
        }
        return this.viewerFilter;
    }

    protected ByteBlowerFilter createViewerFilter() {
        return null;
    }

    public ByteBlowerComparator getViewerComparator(ColumnViewer columnViewer) {
        if (this.viewerSorter == null) {
            this.viewerSorter = this.createViewerComparator(columnViewer);
        }
        return this.viewerSorter;
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new DynamicComparator(columnViewer);
    }
}

