/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.table;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerControlIdentifier;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTableViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;

class ByteBlowerTableColumn
extends TableColumn
implements ControlListener {
    private static final String CONTROL_WITHOUT_IDENTIFIER = "CONTROL_WITHOUT_IDENTIFIER";
    private ByteBlowerTableViewer viewer;
    private static int MIN_WIDTH = 20;

    static {
        $SWITCH_TABLE$com$excentis$products$byteblower$gui$swt$sorting$ByteBlowerComparator$Direction = ByteBlowerTableColumn.$SWITCH_TABLE$com$excentis$products$byteblower$gui$swt$sorting$ByteBlowerComparator$Direction();
    }

    ByteBlowerTableColumn(ByteBlowerTableViewer viewer, int index, String columnName) {
        super(viewer.getTable(), 16384);
        this.setMoveable(true);
        this.setResizable(true);
        this.setText(columnName);
        this.setToolTipText(columnName);
        this.addControlListener(this);
        this.viewer = viewer;
        this.updateHeaderSorting();
        this.addSelectionListener((SelectionListener)this.getSelectionAdapter(this, index));
    }

    public void updateHeaderSorting() {
        ByteBlowerComparator comparator = this.viewer.getViewerComparator();
        if (comparator != null && comparator.isDynamic()) {
            ByteBlowerComparator.Direction dir = comparator.getDirection();
            int columnIndex = comparator.getColumn();
            Table table = this.viewer.getTable();
            if (table.getColumnCount() > columnIndex) {
                switch (dir) {
                    case ASCENDING: {
                        table.setSortDirection(128);
                        TableColumn column = table.getColumn(columnIndex);
                        table.setSortColumn(column);
                        break;
                    }
                    case DESCENDING: {
                        table.setSortDirection(1024);
                        TableColumn column = table.getColumn(columnIndex);
                        table.setSortColumn(column);
                        break;
                    }
                    case OFF: {
                        table.setSortDirection(0);
                        table.setSortColumn(null);
                    }
                }
            }
        }
    }

    private SelectionAdapter getSelectionAdapter(TableColumn column, final int index) {
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerComparator comparator = ByteBlowerTableColumn.this.viewer.getViewerComparator();
                if (comparator != null && comparator.isDynamic()) {
                    comparator.toggleSortingColumn(index);
                    ByteBlowerTableColumn.this.updateHeaderSorting();
                    ByteBlowerTableColumn.this.viewer.hardRefresh();
                }
            }
        };
        return selectionAdapter;
    }

    public void restoreWidth() {
        int width = this.getStoredColumnWidth();
        if (width < MIN_WIDTH) {
            width = MIN_WIDTH;
        }
        this.setWidth(width);
    }

    public int getStoredColumnWidth() {
        String identifier = this.getIdentifier();
        return ByteBlowerPreferences.getStoredColumnWidth((String)identifier);
    }

    protected void checkSubclass() {
    }

    public void storeWidth() {
        String identifier = this.getIdentifier();
        int width = this.getWidth();
        ByteBlowerPreferences.storeColumnWidth((String)identifier, (int)width);
    }

    String getIdentifier() {
        String identifier = this.getControlIdentifier((Widget)this);
        String columnName = this.getText();
        return "TableColumn." + identifier + "." + columnName;
    }

    private String getControlIdentifier(Widget widget) {
        if (widget != null) {
            Control control;
            Composite parent;
            if (widget instanceof ByteBlowerTableColumn) {
                ByteBlowerTableColumn column = (ByteBlowerTableColumn)widget;
                Table parent2 = column.getParent();
                return this.getControlIdentifier((Widget)parent2);
            }
            if (widget instanceof ByteBlowerControlIdentifier) {
                ByteBlowerControlIdentifier identifier = (ByteBlowerControlIdentifier)widget;
                return identifier.getIdentifier();
            }
            if (widget instanceof Control && (parent = (control = (Control)widget).getParent()) != null) {
                return this.getControlIdentifier((Widget)parent);
            }
        }
        return CONTROL_WITHOUT_IDENTIFIER;
    }

    public void controlMoved(ControlEvent arg0) {
    }

    public void controlResized(ControlEvent arg0) {
        this.storeWidth();
    }

    public boolean hasStoredWidth() {
        int width = this.getStoredColumnWidth();
        return width != -1;
    }
}

