/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.table;

import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerTableViewer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ByteBlowerTablePopupMenu
extends ByteBlowerPopupMenu {
    protected IByteBlowerAction byteBlowerAction;
    private IByteBlowerCopyDownAction copyDownAction;
    private IByteBlowerTableViewer tableViewer;
    private static ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    private static final int popupPosNew = 0;
    private static final int popupPosSep1 = 1;
    private static final int popupPosCut = 2;
    private static final int popupPosCopy = 3;
    private static final int popupPosPaste = 4;
    private static final int popupPosSep2 = 5;
    private static final int popupPosDel = 6;
    private static final int popupPosSep3 = 7;
    private static final int popupPosCopyDown = 8;
    private static final int popupPosCopyDownInc = 9;
    private static final int popupPosCopyDownDec = 10;
    private static final int popupPosSep4 = 11;
    private static final int popupPosJump = 12;
    private static final int popupPosSolution = 13;
    private ArmListener armForCopyDown;
    private ArmListener unArmForCopyDown;

    public ByteBlowerTablePopupMenu(Shell shell, IByteBlowerAction byteBlowerAction, IByteBlowerCopyDownAction copyDownAction, IByteBlowerTableViewer tableViewer) {
        super(shell);
        this.byteBlowerAction = byteBlowerAction;
        this.copyDownAction = copyDownAction;
        this.tableViewer = tableViewer;
    }

    @Override
    protected void initializeMenu() {
        this.armForCopyDown = new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                boolean enabled = ((MenuItem)e.getSource()).getEnabled();
                ByteBlowerTablePopupMenu.this.tableViewer.hiliteCopyDownRange(enabled);
            }
        };
        this.unArmForCopyDown = new ArmListener(){

            public void widgetArmed(ArmEvent e) {
                ByteBlowerTablePopupMenu.this.tableViewer.hiliteCopyDownRange(false);
            }
        };
        MenuItem item = this.createMenuItem(8, 0, false);
        item.setText("New");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.byteBlowerAction.doNew();
            }
        });
        item = new MenuItem(this.menu, 2, 1);
        item = this.createMenuItem(8, 2, false);
        item.setText("Cut");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.byteBlowerAction.doCut();
            }
        });
        item = this.createMenuItem(8, 3, false);
        item.setText("Copy");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.byteBlowerAction.doCopy();
            }
        });
        item = this.createMenuItem(8, 4, false);
        item.setText("Paste");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.byteBlowerAction.doPaste();
            }
        });
        item = new MenuItem(this.menu, 2, 5);
        item = this.createMenuItem(8, 6, false);
        item.setText("Delete");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.byteBlowerAction.doDelete();
            }
        });
        item = new MenuItem(this.menu, 2, 7);
        item = this.createMenuItem(8, 8, true);
        item.setText("Copy Down");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.copyDownAction.doCopyDown();
            }
        });
        item = this.createMenuItem(8, 9, true);
        item.setText("Copy Down Incrementing");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.copyDownAction.doCopyDownInc();
            }
        });
        item = this.createMenuItem(8, 10, true);
        item.setText("Copy Down Decrementing");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.copyDownAction.doCopyDownDec();
            }
        });
        item = new MenuItem(this.menu, 2, 11);
        item = this.createMenuItem(8, 12, false);
        item.setText("Jump to Edit...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.copyDownAction.doJump();
            }
        });
        item = this.createMenuItem(8, 13, false);
        item.setText("Solution...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTablePopupMenu.this.copyDownAction.doJumpToSolution();
            }
        });
    }

    private MenuItem createMenuItem(int style, int position, boolean arm) {
        MenuItem item = new MenuItem(this.menu, style, position);
        if (arm) {
            item.addArmListener(this.armForCopyDown);
        } else {
            item.addArmListener(this.unArmForCopyDown);
        }
        return item;
    }

    private void update(MenuItem[] items) {
        boolean enable = this.byteBlowerAction.isNewEnabled();
        items[0].setImage(enable ? sharedImages.getImage("IMG_TOOL_NEW_WIZARD") : sharedImages.getImage("IMG_TOOL_NEW_WIZARD_DISABLED"));
        items[0].setEnabled(enable);
        enable = this.byteBlowerAction.isCutEnabled();
        items[2].setImage(enable ? sharedImages.getImage("IMG_TOOL_CUT") : sharedImages.getImage("IMG_TOOL_CUT_DISABLED"));
        items[2].setEnabled(enable);
        enable = this.byteBlowerAction.isCopyEnabled();
        items[3].setImage(enable ? sharedImages.getImage("IMG_TOOL_COPY") : sharedImages.getImage("IMG_TOOL_COPY_DISABLED"));
        items[3].setEnabled(enable);
        enable = this.byteBlowerAction.isPasteEnabled();
        items[4].setImage(enable ? sharedImages.getImage("IMG_TOOL_PASTE") : sharedImages.getImage("IMG_TOOL_PASTE_DISABLED"));
        items[4].setEnabled(enable);
        enable = this.byteBlowerAction.isDeleteEnabled();
        items[6].setImage(enable ? sharedImages.getImage("IMG_TOOL_DELETE") : sharedImages.getImage("IMG_TOOL_DELETE_DISABLED"));
        items[6].setEnabled(enable);
        items[8].setEnabled(this.copyDownAction.isCopyDownEnabled());
        items[9].setEnabled(this.copyDownAction.isCopyDownIncEnabled());
        items[10].setEnabled(this.copyDownAction.isCopyDownDecEnabled());
        items[12].setEnabled(this.copyDownAction.isJumpEnabled());
        items[13].setEnabled(this.copyDownAction.isSolutionEnabled());
    }

    @Override
    protected void initializeListeners() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                ByteBlowerTablePopupMenu.this.update(items);
            }

            public void menuHidden(MenuEvent e) {
                ByteBlowerTablePopupMenu.this.tableViewer.hiliteCopyDownRange(false);
                super.menuHidden(e);
            }
        });
    }
}

