/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.table;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerBasicTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTableColumn;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerViewerEditorActivationStrategy;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerTableViewer;
import com.excentis.products.byteblower.gui.swt.widgets.table.TableColumnListener;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerEditor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class ByteBlowerTableViewer
extends TableViewer
implements IByteBlowerTableViewer {
    TableColumnListener columnListener;
    String[] columnNames;
    int[] columnWeights;
    boolean isHilited = false;
    static final int MAX_HILITE_RANGE = 100;
    ByteBlowerBasicTableComposite<?> parent;
    private static final int MIN_INITIAL_WIDTH = 200;

    protected ByteBlowerTableViewer(ByteBlowerBasicTableComposite<?> parent, String[] columnNames, int[] columnWeights, int style) {
        super(parent, style);
        this.columnNames = columnNames;
        this.columnWeights = columnWeights;
        this.parent = parent;
        this.initialize();
    }

    @Override
    public ByteBlowerComparator getViewerComparator() {
        return this.parent.getViewerComparator((ColumnViewer)this);
    }

    @Override
    public ByteBlowerFilter getViewerFilter() {
        return this.parent.getViewerFilter();
    }

    public void enableFilter(boolean enable) {
        ByteBlowerFilter filter = this.getViewerFilter();
        if (filter != null) {
            filter.setEnabled(enable);
        }
        this.hardRefresh();
    }

    private void initialize() {
        this.createColumns();
        Table table = this.getTable();
        table.setHeaderVisible(true);
        this.columnListener = new TableColumnListener(table);
        table.addListener(3, (Listener)this.columnListener);
        this.setColumnProperties(this.getColumnNames());
        ColumnViewerEditorActivationStrategy actSupport = ByteBlowerViewerEditorActivationStrategy.reClickActivation((ColumnViewer)this);
        TableViewerEditor.create((TableViewer)this, (ColumnViewerEditorActivationStrategy)actSupport, (int)ByteBlowerViewerEditorActivationStrategy.getFeature());
    }

    private void createColumns() {
        Table table = this.getTable();
        if (table.isDisposed()) {
            return;
        }
        int nofColumns = this.columnNames.length;
        TableLayout layout = new TableLayout();
        boolean useWeights = false;
        int i = 0;
        while (i < nofColumns) {
            ByteBlowerTableColumn column = new ByteBlowerTableColumn(this, i, this.columnNames[i]);
            layout.addColumnData((ColumnLayoutData)new ColumnWeightData(this.columnWeights[i], 200));
            if (column.hasStoredWidth()) {
                column.restoreWidth();
            } else {
                useWeights = true;
            }
            ++i;
        }
        if (useWeights) {
            table.setLayout((Layout)layout);
        }
    }

    @Override
    public void hiliteCopyDownRange(final boolean show) {
        this.getTable().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                StructuredSelection sel = ByteBlowerTableViewer.this.getStructuredSelection();
                if (sel.size() > 1) {
                    return;
                }
                if (show == ByteBlowerTableViewer.this.isHilited) {
                    return;
                }
                ByteBlowerTableViewer.this.isHilited = show;
                int selRow = ByteBlowerTableViewer.this.getCurrentRow();
                int selCol = ByteBlowerTableViewer.this.getCurrentColumn();
                Table table = ByteBlowerTableViewer.this.getTable();
                int range = table.getItemCount();
                if (range > 100) {
                    range = 100;
                }
                int i = selRow;
                while (i < range) {
                    Color color;
                    TableItem row;
                    try {
                        row = table.getItem(i);
                    }
                    catch (Exception exception) {
                        break;
                    }
                    if (show) {
                        row.setData("oldColor" + selCol, (Object)row.getForeground(selCol));
                        color = ExcentisColors.blue;
                    } else {
                        color = (Color)row.getData("oldColor" + selCol);
                    }
                    row.setForeground(selCol, color);
                    ++i;
                }
            }
        });
    }

    protected void initializeContentProvider() {
        IContentProvider contentProvider = this.createContentProvider();
        this.setContentProvider(contentProvider);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this);
    }

    protected void initializeLabelProvider() {
        this.initializeLabelProvider(null);
    }

    protected void initializeLabelProvider(ITableLabelProvider labelProvider) {
        if (labelProvider == null) {
            labelProvider = this.createLabelProvider();
        }
        this.setLabelProvider((IBaseLabelProvider)labelProvider);
    }

    protected abstract IContentProvider createContentProvider();

    protected abstract ITableLabelProvider createLabelProvider();

    @Override
    public int getCurrentRow() {
        return this.columnListener.getCurrentRow();
    }

    @Override
    public int getCurrentColumn() {
        return this.columnListener.getCurrentColumn();
    }

    @Override
    public StructuredViewer asStructuredViewer() {
        return this;
    }

    @Override
    public ColumnViewer asColumnViewer() {
        return this;
    }

    @Override
    public TableViewer asTableViewer() {
        return this;
    }

    @Override
    public Object getFirstSelectedObject() {
        StructuredSelection selection = this.getStructuredSelection();
        if (!selection.isEmpty()) {
            return selection.getFirstElement();
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public void select(Object object) {
        StructuredSelection selection = object == null ? new StructuredSelection() : new StructuredSelection(object);
        this.setSelection((ISelection)selection);
    }

    @Override
    public void select(List<?> objects) {
        StructuredSelection selection = objects == null || objects.isEmpty() ? new StructuredSelection() : new StructuredSelection(objects);
        this.setSelection((ISelection)selection);
    }

    @Override
    public StructuredViewer getStructuredViewer() {
        return this;
    }

    public void clearSelection() {
        StructuredSelection empty = new StructuredSelection();
        this.select(empty);
    }

    public StructuredSelection getStructuredSelection() {
        ISelection selection = this.getSelection();
        return (StructuredSelection)selection;
    }

    protected int doIndexOf(Item item) {
        TableItem tableItem = (TableItem)item;
        int index = this.getTable().indexOf(tableItem);
        return index;
    }

    public void hardRefresh() {
        this.refresh();
    }

    @Override
    public boolean isSorted() {
        ByteBlowerComparator comparator = this.getViewerComparator();
        if (comparator == null) {
            return false;
        }
        return comparator.isEnabled();
    }

    public void initializeComparator(int column, ByteBlowerComparator.Direction direction) {
        this.getViewerComparator().initialize(column, direction);
        this.updateColumnSorting();
    }

    private void updateColumnSorting() {
        TableColumn[] tableColumnArray = this.getTable().getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn col = tableColumnArray[n2];
            ByteBlowerTableColumn column = (ByteBlowerTableColumn)col;
            column.updateHeaderSorting();
            ++n2;
        }
    }
}

