/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IntegerTextFactory {
    private static IntegerTextFactory instance = null;

    public static IntegerTextFactory instance() {
        if (instance == null) {
            instance = new IntegerTextFactory();
        }
        return instance;
    }

    public Text createWithTextLimit(Composite parent, int textLimit) {
        Text newItem = new Text(parent, 2048);
        newItem.setTextLimit(textLimit);
        newItem.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                event.doit = event.text.length() == 0 || Character.isDigit(event.text.charAt(0));
            }
        });
        return newItem;
    }

    public Text create(Composite parent, final long min, final long max) {
        Text text = new Text(parent, 2048);
        String minString = Long.toString(min);
        String maxString = Long.toString(max);
        int minLength = minString.length();
        int maxLength = maxString.length();
        final int limit = maxLength > minLength ? maxLength : minLength;
        text.setTextLimit(limit);
        text.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                boolean doit = false;
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                int resultLength = result.length();
                if (resultLength == 0) {
                    doit = true;
                } else if (resultLength > limit) {
                    doit = false;
                } else {
                    try {
                        Long longValue = Long.valueOf(result);
                        long value = longValue;
                        doit = true;
                        if (value >= min && value <= max) {
                            t.setForeground(null);
                        } else {
                            t.setForeground(ExcentisColors.red);
                        }
                    }
                    catch (Exception exception) {
                        doit = false;
                    }
                }
                e.doit = doit;
            }
        });
        return text;
    }

    public Text create(Composite parent, long maximum) {
        return this.create(parent, 0L, maximum);
    }

    public Text create(Composite parent, String maximum) {
        Long max = Long.valueOf(maximum);
        return this.create(parent, max);
    }
}

