/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.swt.widgets.text.ExcentisTextFactory;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.Ipv6AddressController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class IpAddressTextFactory
extends ExcentisTextFactory {
    private static IpAddressTextFactory instance = null;

    public static IpAddressTextFactory instance() {
        if (instance == null) {
            instance = new IpAddressTextFactory();
        }
        return instance;
    }

    @Override
    public Text create(Composite parent, int style) {
        Text newItem = new Text(parent, style);
        newItem.setText("1.1.1.1");
        newItem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text text = (Text)e.widget;
                String content = text.getText();
                if (Ipv4AddressController.isValid((String)content) || Ipv6AddressController.isValid((String)content, (boolean)false, (boolean)true)) {
                    text.setForeground(null);
                } else {
                    text.setForeground(ExcentisColors.red);
                }
            }
        });
        newItem.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text text = (Text)e.widget;
                String previous = text.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = Ipv4AddressController.isValidPartialInput((String)result) || Ipv6AddressController.isValidInput((String)result);
            }
        });
        return newItem;
    }
}

