/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.text;

import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;

public class NetmaskTextFactory {
    private static NetmaskTextFactory instance = null;

    private NetmaskTextFactory() {
    }

    public static NetmaskTextFactory instance() {
        if (instance == null) {
            instance = new NetmaskTextFactory();
        }
        return instance;
    }

    public Text create(Composite parent, int style) {
        Text newItem = new Text(parent, style);
        newItem.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Text t = (Text)e.widget;
                if (Ipv4AddressController.isValidNetmask((String)t.getText())) {
                    t.setForeground(null);
                } else {
                    t.setForeground(new Color(null, 255, 0, 0));
                }
            }
        });
        newItem.addVerifyListener(new VerifyListener(){

            public void verifyText(VerifyEvent e) {
                Text t = (Text)e.widget;
                String previous = t.getText();
                String result = String.valueOf(previous.substring(0, e.start)) + e.text + previous.substring(e.end, previous.length());
                e.doit = Ipv4AddressController.isValidNetmaskPartialInput((String)result);
            }
        });
        return newItem;
    }
}

