/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.tree;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.tree.IByteBlowerTreeComposite;
import java.util.Arrays;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ByteBlowerBasicTreeComposite<TreeObjectClass>
extends ByteBlowerViewerComposite<TreeObjectClass>
implements IByteBlowerTreeComposite,
ControlListener {
    private Label lblTree;
    private ByteBlowerPopupMenu popupMenu;
    private int nofTopWidgets;
    protected IByteBlowerAction actionInterface;
    private CellEditor[] editors;

    protected int getNofTopWidgets() {
        return this.nofTopWidgets;
    }

    public ByteBlowerBasicTreeComposite(Composite parent, String identifier, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, ByteBlowerViewerComposite<TreeObjectClass> parentComposite) {
        super(parent, identifier, focusDispatcher, parentComposite);
        this.actionInterface = actionInterface;
        this.initialize();
    }

    protected abstract void initializeChildClass();

    private void initialize() {
        this.createBasicWidgets();
        this.initializeLayout();
        this.initializeListeners();
        this.initializeCellModifiers();
        this.initializeCellEditors();
        this.initializePopupMenu();
        this.initializeActionListeners();
        this.initializeInput();
        this.updateWidgets();
        this.afterInitialization();
    }

    public TreeViewer getTreeViewer() {
        return (TreeViewer)this.columnViewer;
    }

    protected Label getLabel() {
        return this.lblTree;
    }

    protected void initializeActionListeners() {
    }

    protected void afterInitialization() {
    }

    private void initializeInput() {
        Object initialInput = this.getInitialInput();
        if (initialInput != null) {
            this.setInput(initialInput);
        }
    }

    protected abstract TreeViewer createTreeViewer();

    private void initializeCellModifiers() {
        ICellModifier cellModifier = this.getCellModifier();
        this.columnViewer.setCellModifier(cellModifier);
    }

    protected abstract String getTreeLabel();

    protected abstract CellEditor[] createCellEditors();

    protected CellEditor[] getCellEditors() {
        if (this.editors == null) {
            this.editors = this.createCellEditors();
        }
        return this.editors;
    }

    private void initializeCellEditors() {
        this.editors = this.getCellEditors();
        this.columnViewer.setCellEditors(this.editors);
    }

    protected abstract ICellModifier getCellModifier();

    private void createBasicWidgets() {
        this.lblTree = new Label((Composite)this, 0);
        this.registerControl((Control)this.lblTree);
        this.nofTopWidgets = 1;
        this.nofTopWidgets += this.createTopWidgets();
        TreeViewer tableViewer = this.createTreeViewer();
        this.setColumnViewer((ColumnViewer)tableViewer);
        this.registerControl(tableViewer.getControl());
        String label = this.getTreeLabel();
        this.lblTree.setText(label);
    }

    protected abstract int createTopWidgets();

    private void initializeListeners() {
        this.initializeBasicChildListeners();
        this.addControlListener(this);
    }

    protected abstract void initializeBasicChildListeners();

    private void initializeLayout() {
        GridLayout layout = new GridLayout(this.nofTopWidgets, false);
        this.setLayout((Layout)layout);
        GridData labelLayoutData = new GridData(768);
        this.lblTree.setLayoutData((Object)labelLayoutData);
        Tree table = this.getTree();
        GridData tableLayoutData = new GridData(1808);
        tableLayoutData.horizontalSpan = this.nofTopWidgets;
        table.setLayoutData((Object)tableLayoutData);
    }

    @Override
    public Tree getTree() {
        return this.getTreeViewer().getTree();
    }

    public int getColumnIndex(String column) {
        return Arrays.asList(this.getColumnNames()).indexOf(column);
    }

    @Override
    public void controlMoved(ControlEvent arg0) {
    }

    @Override
    public void updateWidgets() {
        if (this.isDisposed()) {
            return;
        }
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ByteBlowerBasicTreeComposite.this.lblTree.isDisposed()) {
                    return;
                }
                Object input = ByteBlowerBasicTreeComposite.this.getInput();
                boolean enable = input != null;
                for (Control control : ByteBlowerBasicTreeComposite.this.getControls()) {
                    control.setEnabled(enable);
                }
                ByteBlowerBasicTreeComposite.this.updateCustomWidgets(enable);
                Tree table = ByteBlowerBasicTreeComposite.this.getTree();
                if (table.getEnabled() != enable) {
                    table.setEnabled(enable);
                    table.setHeaderVisible(enable);
                }
            }
        });
    }

    protected abstract void updateCustomWidgets(boolean var1);

    public void selectAndReveal(final TreeObjectClass object) {
        final TreeViewer tableViewer = this.getTreeViewer();
        this.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                tableViewer.setSelection((ISelection)new StructuredSelection(object), true);
            }
        });
    }

    @Override
    public void controlResized(ControlEvent e) {
    }

    public StructuredViewer getStructuredViewer() {
        return this.columnViewer;
    }

    @Override
    public int getFirstSelectedIndex() {
        StructuredSelection selection = this.getStructuredSelection();
        if (selection == null || selection.isEmpty()) {
            return -1;
        }
        TreeItem[] items = this.getTree().getSelection();
        if (items.length > 0) {
            TreeItem firstItem = items[0];
            return firstItem.indexOf(firstItem);
        }
        return -1;
    }

    @Override
    public void hardRefresh() {
        this.getStructuredViewer().refresh();
    }

    protected abstract ByteBlowerPopupMenu createPopupMenu();

    private void initializePopupMenu() {
        this.popupMenu = this.createPopupMenu();
        if (this.popupMenu != null) {
            this.getTree().setMenu(this.popupMenu.getMenu());
        }
    }

    protected void setLabelText(String string) {
        if (!this.isDisposed()) {
            this.lblTree.setText(string);
        }
    }

    protected void setLabelForeground(Color color) {
        if (!this.isDisposed()) {
            this.lblTree.setForeground(color);
        }
    }
}

