/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.tree;

import com.excentis.products.byteblower.gui.swt.ByteBlowerPopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.tree.IByteBlowerTreeViewer;
import org.eclipse.swt.events.ArmEvent;
import org.eclipse.swt.events.ArmListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class ByteBlowerTreePopupMenu
extends ByteBlowerPopupMenu {
    protected IByteBlowerAction byteBlowerAction;
    private IByteBlowerCopyDownAction copyDownAction;
    private IByteBlowerTreeViewer treeViewer;
    private static ISharedImages sharedImages = PlatformUI.getWorkbench().getSharedImages();
    private static final int popupPosNew = 0;
    private static final int popupPosSep1 = 1;
    private static final int popupPosCut = 2;
    private static final int popupPosCopy = 3;
    private static final int popupPosPaste = 4;
    private static final int popupPosSep2 = 5;
    private static final int popupPosDel = 6;
    private static final int popupPosSep3 = 7;
    private static final int popupPosCopyDown = 8;
    private static final int popupPosCopyDownInc = 9;
    private static final int popupPosCopyDownDec = 10;
    private static final int popupPosSep4 = 11;
    private static final int popupPosJump = 12;
    private static final int popupPosSolution = 13;
    private ArmListener armForCopyDown;
    private ArmListener unArmForCopyDown;

    public ByteBlowerTreePopupMenu(Shell shell, IByteBlowerAction byteBlowerAction, IByteBlowerCopyDownAction copyDownAction, IByteBlowerTreeViewer treeViewer, int offset) {
        super(shell, offset);
        this.byteBlowerAction = byteBlowerAction;
        this.copyDownAction = copyDownAction;
        this.treeViewer = treeViewer;
    }

    @Override
    protected void initializeMenu() {
        this.initializeMenu(this.offset);
    }

    private void initializeMenu(int offset) {
        MenuItem item = this.createMenuItem(8, offset + 0, false);
        item.setText("New");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.byteBlowerAction.doNew();
            }
        });
        item = new MenuItem(this.menu, 2, offset + 1);
        item = this.createMenuItem(8, offset + 2, false);
        item.setText("Cut");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.byteBlowerAction.doCut();
            }
        });
        item = this.createMenuItem(8, offset + 3, false);
        item.setText("Copy");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.byteBlowerAction.doCopy();
            }
        });
        item = this.createMenuItem(8, offset + 4, false);
        item.setText("Paste");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.byteBlowerAction.doPaste();
            }
        });
        item = new MenuItem(this.menu, 2, offset + 5);
        item = this.createMenuItem(8, offset + 6, false);
        item.setText("Delete");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.byteBlowerAction.doDelete();
            }
        });
        item = new MenuItem(this.menu, 2, offset + 7);
        item = this.createMenuItem(8, offset + 8, true);
        item.setText("Copy Down");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.copyDownAction.doCopyDown();
            }
        });
        item = this.createMenuItem(8, offset + 9, true);
        item.setText("Copy Down Incrementing");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.copyDownAction.doCopyDownInc();
            }
        });
        item = this.createMenuItem(8, offset + 10, true);
        item.setText("Copy Down Decrementing");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.copyDownAction.doCopyDownDec();
            }
        });
        item = new MenuItem(this.menu, 2, offset + 11);
        item = this.createMenuItem(8, offset + 12, false);
        item.setText("Jump to edit...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.copyDownAction.doJump();
            }
        });
        item = this.createMenuItem(8, offset + 13, false);
        item.setText("Solution...");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ByteBlowerTreePopupMenu.this.copyDownAction.doJumpToSolution();
            }
        });
    }

    protected MenuItem createMenuItem(int style, int position, boolean arm) {
        MenuItem item = new MenuItem(this.menu, style, position);
        if (arm) {
            item.addArmListener(this.armForCopyDown());
        } else {
            item.addArmListener(this.unArmForCopyDown());
        }
        return item;
    }

    private ArmListener unArmForCopyDown() {
        if (this.unArmForCopyDown == null) {
            this.unArmForCopyDown = new ArmListener(){

                public void widgetArmed(ArmEvent e) {
                    ByteBlowerTreePopupMenu.this.treeViewer.hiliteCopyDownRange(false);
                }
            };
        }
        return this.unArmForCopyDown;
    }

    private ArmListener armForCopyDown() {
        if (this.armForCopyDown == null) {
            this.armForCopyDown = new ArmListener(){

                public void widgetArmed(ArmEvent e) {
                    boolean enabled = ((MenuItem)e.getSource()).getEnabled();
                    ByteBlowerTreePopupMenu.this.treeViewer.hiliteCopyDownRange(enabled);
                }
            };
        }
        return this.armForCopyDown;
    }

    protected void update(MenuItem[] items) {
        boolean enable = this.byteBlowerAction.isNewEnabled();
        items[this.offset + 0].setImage(enable ? sharedImages.getImage("IMG_TOOL_NEW_WIZARD") : sharedImages.getImage("IMG_TOOL_NEW_WIZARD_DISABLED"));
        items[this.offset + 0].setEnabled(enable);
        enable = this.byteBlowerAction.isCutEnabled();
        items[this.offset + 2].setImage(enable ? sharedImages.getImage("IMG_TOOL_CUT") : sharedImages.getImage("IMG_TOOL_CUT_DISABLED"));
        items[this.offset + 2].setEnabled(enable);
        enable = this.byteBlowerAction.isCopyEnabled();
        items[this.offset + 3].setImage(enable ? sharedImages.getImage("IMG_TOOL_COPY") : sharedImages.getImage("IMG_TOOL_COPY_DISABLED"));
        items[this.offset + 3].setEnabled(enable);
        enable = this.byteBlowerAction.isPasteEnabled();
        items[this.offset + 4].setImage(enable ? sharedImages.getImage("IMG_TOOL_PASTE") : sharedImages.getImage("IMG_TOOL_PASTE_DISABLED"));
        items[this.offset + 4].setEnabled(enable);
        enable = this.byteBlowerAction.isDeleteEnabled();
        items[this.offset + 6].setImage(enable ? sharedImages.getImage("IMG_TOOL_DELETE") : sharedImages.getImage("IMG_TOOL_DELETE_DISABLED"));
        items[this.offset + 6].setEnabled(enable);
        items[this.offset + 8].setEnabled(this.copyDownAction.isCopyDownEnabled());
        items[this.offset + 9].setEnabled(this.copyDownAction.isCopyDownIncEnabled());
        items[this.offset + 10].setEnabled(this.copyDownAction.isCopyDownDecEnabled());
        items[this.offset + 12].setEnabled(this.copyDownAction.isJumpEnabled());
        items[this.offset + 13].setEnabled(this.copyDownAction.isSolutionEnabled());
    }

    @Override
    protected void initializeListeners() {
        this.menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu menu = (Menu)e.widget;
                MenuItem[] items = menu.getItems();
                ByteBlowerTreePopupMenu.this.update(items);
            }

            public void menuHidden(MenuEvent e) {
                ByteBlowerTreePopupMenu.this.treeViewer.hiliteCopyDownRange(false);
                super.menuHidden(e);
            }
        });
    }
}

