/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.swt.widgets.tree;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.swt.contentprovider.ByteBlowerFilter;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerViewerEditorActivationStrategy;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerBasicTreeComposite;
import com.excentis.products.byteblower.gui.swt.widgets.tree.ByteBlowerTreeColumn;
import com.excentis.products.byteblower.gui.swt.widgets.tree.IByteBlowerTreeViewer;
import com.excentis.products.byteblower.gui.swt.widgets.tree.TreeColumnListener;
import java.util.List;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerEditorActivationStrategy;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerEditor;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class ByteBlowerTreeViewer
extends TreeViewer
implements IByteBlowerTreeViewer,
ControlListener {
    private TreeColumnListener columnListener;
    String[] columnNames;
    int[] columnWeights;
    boolean isHilited = false;
    static final int MAX_HILITE_RANGE = 100;
    ByteBlowerFilter filter;
    ByteBlowerBasicTreeComposite<?> parent;
    private static final int MIN_INITIAL_WIDTH = 200;

    public ByteBlowerTreeViewer(ByteBlowerBasicTreeComposite<?> parent) {
        super(parent, 2);
        this.parent = parent;
    }

    public ByteBlowerTreeViewer(ByteBlowerBasicTreeComposite<?> parent, String[] columnNames, int[] columnWeights, int style) {
        super(parent, style);
        this.parent = parent;
        this.columnNames = columnNames;
        this.columnWeights = columnWeights;
    }

    @Override
    public ByteBlowerComparator getViewerComparator() {
        return this.parent.getViewerComparator((ColumnViewer)this);
    }

    @Override
    public ByteBlowerFilter getViewerFilter() {
        return this.parent.getViewerFilter();
    }

    protected ByteBlowerFilter getFilter() {
        return this.filter;
    }

    public void enableFilter(boolean enable) {
        this.filter.setEnabled(enable);
        this.hardRefresh();
    }

    protected void hardRefresh() {
        this.refresh();
    }

    protected void initialize() {
        this.initializeContentProvider();
        this.initializeLabelProvider();
        Tree tree = this.getTree();
        this.columnListener = new TreeColumnListener(this.getTree());
        tree.addListener(3, (Listener)this.columnListener);
        this.createColumns();
        this.setColumnProperties(this.getColumnNames());
        ColumnViewerEditorActivationStrategy actSupport = ByteBlowerViewerEditorActivationStrategy.reClickActivation((ColumnViewer)this);
        TreeViewerEditor.create((TreeViewer)this, (ColumnViewerEditorActivationStrategy)actSupport, (int)ByteBlowerViewerEditorActivationStrategy.getFeature());
    }

    protected void createColumns() {
        this.getTree().addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                ByteBlowerTreeViewer.this.packAndFillLastColumn();
            }
        });
        Tree tree = this.getTree();
        if (tree.isDisposed()) {
            return;
        }
        int nofColumns = this.columnNames == null ? 1 : this.columnNames.length;
        tree.setHeaderVisible(nofColumns > 1);
        TableLayout layout = new TableLayout();
        boolean useWeights = false;
        int i = 0;
        while (i < nofColumns) {
            ByteBlowerTreeColumn column = new ByteBlowerTreeColumn(this, i, this.columnNames == null ? "" : this.columnNames[i]);
            if (column.hasStoredWidth()) {
                column.restoreWidth();
            } else {
                useWeights = true;
                int weight = this.columnWeights == null ? 100 : this.columnWeights[i];
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(weight, 200, true));
                column.setWidth(200);
                column.storeWidth();
            }
            ++i;
        }
        if (useWeights) {
            tree.setLayout((Layout)layout);
        }
    }

    protected void initializeContentProvider() {
        IContentProvider contentProvider = this.createContentProvider();
        this.setContentProvider(contentProvider);
    }

    protected void initializeLabelProvider() {
        this.initializeLabelProvider(null);
    }

    private void initializeLabelProvider(IBaseLabelProvider labelProvider) {
        if (labelProvider == null) {
            labelProvider = this.createLabelProvider();
        }
        if (labelProvider != null) {
            this.setLabelProvider(labelProvider);
        }
    }

    protected abstract IContentProvider createContentProvider();

    protected abstract IBaseLabelProvider createLabelProvider();

    @Override
    public StructuredViewer asStructuredViewer() {
        return this;
    }

    @Override
    public TreeViewer asTreeViewer() {
        return this;
    }

    public ITreeSelection getStructuredSelection() {
        return (ITreeSelection)this.asStructuredViewer().getSelection();
    }

    public Object getFirstSelectedObject() {
        ITreeSelection selection = this.getStructuredSelection();
        if (!selection.isEmpty()) {
            return selection.getFirstElement();
        }
        return null;
    }

    @Override
    public String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    public void select(Object object) {
        StructuredSelection selection = new StructuredSelection(object);
        this.setSelection((ISelection)selection);
    }

    @Override
    public void select(List<?> objects) {
        StructuredSelection selection = new StructuredSelection(objects);
        this.setSelection((ISelection)selection);
    }

    @Override
    public StructuredViewer getStructuredViewer() {
        return this;
    }

    public void controlMoved(ControlEvent e) {
    }

    public void controlResized(ControlEvent e) {
    }

    @Override
    public int getCurrentRow() {
        return this.columnListener.getCurrentRow();
    }

    @Override
    public int getCurrentColumn() {
        return this.columnListener.getCurrentColumn();
    }

    @Override
    public void hiliteCopyDownRange(final boolean show) {
        this.getTree().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                ITreeSelection sel = ByteBlowerTreeViewer.this.getStructuredSelection();
                if (sel.size() > 1) {
                    return;
                }
                if (show == ByteBlowerTreeViewer.this.isHilited) {
                    return;
                }
                ByteBlowerTreeViewer.this.isHilited = show;
                int selRow = ByteBlowerTreeViewer.this.getCurrentRow();
                int selCol = ByteBlowerTreeViewer.this.getCurrentColumn();
                Tree tree = ByteBlowerTreeViewer.this.getTree();
                int range = tree.getItemCount();
                if (range > 100) {
                    range = 100;
                }
                int i = selRow;
                while (i < range) {
                    Color color;
                    TreeItem row;
                    try {
                        row = tree.getItem(i);
                    }
                    catch (Exception exception) {
                        break;
                    }
                    if (show) {
                        row.setData("oldColor" + selCol, (Object)row.getForeground(selCol));
                        color = ExcentisColors.blue;
                    } else {
                        color = (Color)row.getData("oldColor" + selCol);
                    }
                    row.setForeground(selCol, color);
                    ++i;
                }
            }
        });
    }

    protected void packAndFillLastColumn() {
        Tree tree = this.getTree();
        int columnsWidth = 0;
        int columnCount = tree.getColumnCount();
        if (columnCount < 1) {
            return;
        }
        int i = 0;
        while (i < columnCount - 1) {
            columnsWidth += tree.getColumn(i).getWidth();
            ++i;
        }
        TreeColumn lastColumn = tree.getColumn(columnCount - 1);
        lastColumn.pack();
        Rectangle area = tree.getClientArea();
        Point preferredSize = tree.computeSize(-1, -1);
        int width = area.width - 2 * tree.getBorderWidth();
        if (preferredSize.y > area.height + tree.getHeaderHeight()) {
            Point vBarSize = tree.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        if (lastColumn.getWidth() < width - columnsWidth) {
            lastColumn.setWidth(width - columnsWidth);
        }
    }

    @Override
    public boolean isSorted() {
        ByteBlowerComparator comparator = this.getViewerComparator();
        if (comparator == null) {
            return false;
        }
        return comparator.isEnabled();
    }
}

