/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.update;

import com.excentis.products.byteblower.gui.update.Activator;
import com.excentis.products.byteblower.gui.update.P2Util;
import com.excentis.products.byteblower.gui.update.UpdateJob;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.Properties;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class UpdateHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String repositoryUrl;
        ServiceReference serviceReference;
        String autoParam = event.getParameter("com.excentis.products.byteblower.gui.update.command.update.auto");
        boolean auto = Boolean.parseBoolean(autoParam);
        BundleContext bundleContext = Activator.getDefault().getBundle().getBundleContext();
        IProvisioningAgent agent = (IProvisioningAgent)bundleContext.getService(serviceReference = bundleContext.getServiceReference(IProvisioningAgent.class));
        if (agent == null) {
            Activator.log(4, "Error! No provisioning agent loaded!");
            return null;
        }
        String configured = Activator.getCustomUpdateSite();
        if (configured.isEmpty()) {
            Properties updateProperties = new Properties();
            try {
                URL url = FileLocator.find((Bundle)Activator.getDefault().getBundle(), (IPath)new Path("update.properties"), Collections.emptyMap());
                URL fileUrl = FileLocator.toFileURL((URL)url);
                updateProperties.load(new FileInputStream(new File(fileUrl.getPath())));
            }
            catch (IOException e) {
                Activator.log(4, e.getLocalizedMessage());
                return null;
            }
            repositoryUrl = updateProperties.getProperty("repository_url");
        } else {
            repositoryUrl = configured;
        }
        if (!P2Util.addRepository(agent, repositoryUrl)) {
            Activator.log(4, "ByteBlower Update: Error! Could not add repository!");
            return null;
        }
        UpdateJob updateJob = new UpdateJob(agent, auto);
        updateJob.schedule();
        return null;
    }
}

