/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public final class GuiUtils {
    private static final BigDecimal million = new BigDecimal(1000000);
    private static final int frameRateScale = 11;
    private static final BigDecimal billion = new BigDecimal("1000000000");

    private GuiUtils() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void copyFile(File src, File dst) throws IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            FileInputStream in = new FileInputStream(src);
            try {
                try (FileOutputStream out = new FileOutputStream(dst);){
                    out.getChannel().transferFrom(in.getChannel(), 0L, in.getChannel().size());
                }
                if (in == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            in.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public static boolean copyDir(File src, File dst) throws IOException {
        return GuiUtils.copyDir(src, dst, false);
    }

    private static boolean copyDir(File src, File dst, boolean sub) throws IOException {
        boolean dir;
        String[] children = src.list();
        boolean bl = dir = children != null;
        if (dir) {
            if (!dst.exists() && !dst.mkdirs()) {
                return false;
            }
            int i = 0;
            while (i < children.length) {
                File newSrc = new File(src, children[i]);
                File newDst = new File(dst, children[i]);
                boolean success = GuiUtils.copyDir(newSrc, newDst, true);
                if (!success) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if (!sub) {
            return false;
        }
        GuiUtils.copyFile(src, dst);
        return true;
    }

    public static BigDecimal frameIntervalToFramesPerSecond(BigInteger frameInterval) {
        BigDecimal nsInterval = new BigDecimal(frameInterval);
        return billion.divide(nsInterval, 11, 6);
    }

    public static void recursiveSetEnabled(Control control, boolean enabled) {
        if (control instanceof Composite) {
            Composite composite = (Composite)control;
            Control[] controlArray = composite.getChildren();
            int n = controlArray.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                GuiUtils.recursiveSetEnabled(child, enabled);
                ++n2;
            }
        }
        control.setEnabled(enabled);
    }
}

