/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime;

import com.excentis.products.byteblower.gui.views.realtime.Activator;
import com.excentis.products.byteblower.gui.views.realtime.PrometheusState;
import com.excentis.products.byteblower.gui.views.realtime.RealtimeDataHandle;
import com.excentis.products.byteblower.gui.views.realtime.RealtimeUpdater;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfig;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestinationConfigUnicast;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatencySnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTriggerSnapshot;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSessionSnapshot;
import java.util.WeakHashMap;
import java.util.function.Consumer;

public class PrometheusDecompose
implements RealtimeUpdater.RealtimeUpdateListener {
    private final WeakHashMap<FbTrigger, Long> previousFbVal = new WeakHashMap();
    private final WeakHashMap<FbOutOfSequence, Long> previousOOSFbVal = new WeakHashMap();
    private final WeakHashMap<HttpSession, TrafficState> previousHttpVal = new WeakHashMap();
    private final PrometheusState state = new PrometheusState();

    private static <T> void withLogging(Consumer<T> worker, T val) {
        try {
            worker.accept(val);
        }
        catch (Exception e) {
            Activator.logToRCP("Can't process result: ", e);
        }
    }

    public PrometheusState.STATE getExporterState() {
        return this.state.getState();
    }

    @Override
    public void dataUpdated(RealtimeDataHandle dataHandle) {
        if (dataHandle == null || dataHandle.getFlowInstances() == null) {
            this.clearState();
            return;
        }
        for (FlowInstance flow : dataHandle.getFlowInstances()) {
            if (flow instanceof FbFlowInstance) {
                PrometheusDecompose.withLogging(this::updateCounters, (FbFlowInstance)flow);
            }
            if (!(flow instanceof HttpFlowInstance)) continue;
            PrometheusDecompose.withLogging(this::updateCounters, (HttpFlowInstance)flow);
        }
    }

    @Override
    public void dataError(Throwable t) {
    }

    private void clearState() {
        this.state.restart();
        this.previousFbVal.clear();
        this.previousHttpVal.clear();
        this.previousOOSFbVal.clear();
    }

    private void updateCounters(HttpFlowInstance flow) {
        String flowName = flow.getFlow().getName();
        HttpSession clientSession = flow.getClientHttpSession();
        HttpSession serverSession = flow.getServerHttpSession();
        if (clientSession != null) {
            this.updateHttpSession(flowName, clientSession);
        }
        if (serverSession != null) {
            this.updateHttpSession(flowName, serverSession);
        }
    }

    private void updateHttpSession(String flowName, HttpSession httpSession) {
        String portName = httpSession.getHttpApplication().getPort().getName();
        HttpSessionSnapshot lastSnap = httpSession.getLatestSnapshot();
        if (lastSnap != null) {
            long duration = lastSnap.getSnapshotDuration();
            TrafficState previous = this.previousHttpVal.computeIfAbsent(httpSession, a -> new TrafficState());
            try {
                Long rxByteCount;
                Long txByteCount = httpSession.getTxByteCount();
                if (txByteCount != null) {
                    this.state.incrementTrafficCounter(flowName, PrometheusState.TRAFFIC_DIRECTION.tx, portName, txByteCount - previous.txBytes);
                    previous.txBytes = txByteCount;
                }
                if ((rxByteCount = httpSession.getRxByteCount()) != null) {
                    this.state.incrementTrafficCounter(flowName, PrometheusState.TRAFFIC_DIRECTION.rx, portName, rxByteCount - previous.rxBytes);
                    previous.rxBytes = rxByteCount;
                }
                double txRate = 1.0E9 * (double)lastSnap.getTxByteCount().longValue() / (double)duration;
                double rxRate = 1.0E9 * (double)lastSnap.getRxByteCount().longValue() / (double)duration;
                this.state.setTrafficGauge(flowName, PrometheusState.TRAFFIC_DIRECTION.tx, portName, txRate);
                this.state.setTrafficGauge(flowName, PrometheusState.TRAFFIC_DIRECTION.rx, portName, rxRate);
            }
            catch (PrometheusState.NegativeValue negativeValue) {
                this.previousHttpVal.remove(httpSession);
            }
        } else {
            this.state.setTrafficGauge(flowName, PrometheusState.TRAFFIC_DIRECTION.tx, portName, 0.0);
            this.state.setTrafficGauge(flowName, PrometheusState.TRAFFIC_DIRECTION.rx, portName, 0.0);
        }
    }

    private void updateCounters(FbFlowInstance aFlow) {
        String flowName = aFlow.getFlow().getName();
        if (aFlow.getSource() == null) {
            return;
        }
        FbTrigger trigger = aFlow.getSource().getTrigger();
        if (trigger == null) {
            return;
        }
        FbTriggerSnapshot lastTx = trigger.getLatestSnapshot();
        String sourcePortName = aFlow.getSource().getPort().getName();
        if (lastTx != null) {
            this.updateFBTrigger(flowName, sourcePortName, trigger, PrometheusState.TRAFFIC_DIRECTION.tx);
        } else {
            this.state.setTrafficGauge(flowName, PrometheusState.TRAFFIC_DIRECTION.tx, sourcePortName, 0.0);
            try {
                this.state.incrementTrafficCounter(flowName, PrometheusState.TRAFFIC_DIRECTION.tx, sourcePortName, 0L);
            }
            catch (PrometheusState.NegativeValue e) {
                Activator.logToRCP("Impossible negative value", e);
            }
        }
        FbDestinationConfig destConfig = aFlow.getDestinationConfig();
        if (destConfig instanceof FbDestinationConfigUnicast) {
            FbDestination end = ((FbDestinationConfigUnicast)destConfig).getDestination();
            String rxPortName = end.getPort().getName();
            FbTrigger rxTrigger = end.getTrigger();
            this.updateFBTrigger(flowName, rxPortName, rxTrigger, PrometheusState.TRAFFIC_DIRECTION.rx);
            this.updateLatency(flowName, sourcePortName, end, rxPortName);
            this.updateOOS(flowName, end, rxPortName);
        }
    }

    private void updateOOS(String flowName, FbDestination end, String rxPortName) {
        FbOutOfSequence oos = end.getOutOfSequence();
        if (oos != null) {
            Long currentCount = oos.getPacketCountOutOfSequence();
            Long previousCount = this.previousOOSFbVal.computeIfAbsent(oos, a -> 0L);
            long oosCount = currentCount == null ? 0L : currentCount - previousCount;
            try {
                this.state.incrementOOSCounter(flowName, rxPortName, oosCount);
            }
            catch (PrometheusState.NegativeValue negativeValue) {
                this.previousOOSFbVal.remove(oos);
            }
        }
    }

    private void updateLatency(String flowName, String sourcePortName, FbDestination end, String rxPortName) {
        FbLatencySnapshot lastLatencySnap;
        FbLatency latency = end.getLatency();
        if (latency != null && (lastLatencySnap = latency.getLatestSnapshot()) != null) {
            double avg = this.convertNsToS(lastLatencySnap.getLatencyAverage());
            double min = this.convertNsToS(lastLatencySnap.getLatencyMinimum());
            double max = this.convertNsToS(lastLatencySnap.getLatencyMaximum());
            double jit = this.convertNsToS(lastLatencySnap.getJitter());
            this.state.setOneWayLatency(flowName, sourcePortName, rxPortName, avg, min, max, jit);
        }
    }

    private double convertNsToS(long ns) {
        return (double)ns * 1.0E-9;
    }

    private void updateFBTrigger(String flowName, String portName, FbTrigger trigger, PrometheusState.TRAFFIC_DIRECTION direction) {
        if (trigger == null) {
            return;
        }
        Long previous = this.previousFbVal.computeIfAbsent(trigger, a -> 0L);
        try {
            long bytesCount = trigger.getByteCount();
            this.state.incrementTrafficCounter(flowName, direction, portName, bytesCount - previous);
            this.previousFbVal.put(trigger, bytesCount);
        }
        catch (PrometheusState.NegativeValue negativeValue) {
            this.previousFbVal.remove(trigger);
        }
        FbTriggerSnapshot lastSnap = trigger.getLatestSnapshot();
        if (lastSnap != null) {
            this.state.setTrafficGauge(flowName, direction, portName, 1.0E9 * (double)lastSnap.getByteCount().longValue() / (double)lastSnap.getSnapshotDuration().longValue());
        } else {
            this.state.setTrafficGauge(flowName, direction, portName, 0.0);
        }
    }

    private static class TrafficState {
        private long txBytes;
        private long rxBytes;

        private TrafficState() {
        }
    }
}

