/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime.composites;

import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;

class FlowInstanceTableContentProvider
implements IStructuredContentProvider {
    FlowInstanceTableContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return this.processList((List)inputElement).toArray();
        }
        throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " only takes list of supported FlowInstance entities as input; input was " + inputElement.getClass().getSimpleName());
    }

    private List<?> processList(List<?> inputList) {
        ArrayList<Pair<FlowInstance, Object>> elementList = new ArrayList<Pair<FlowInstance, Object>>();
        for (Object obj : inputList) {
            if (obj instanceof FbFlowInstance) {
                this.processFbFlow(elementList, (FbFlowInstance)obj);
                continue;
            }
            if (obj instanceof HttpFlowInstance) {
                this.processHttpFlow(elementList, (HttpFlowInstance)obj);
                continue;
            }
            if (obj instanceof ThroughputFlowTest) {
                this.processThroughputTests(elementList, (ThroughputFlowTest)obj);
                continue;
            }
            String thisClassName = this.getClass().getSimpleName();
            String className = obj.getClass().getSimpleName();
            throw new IllegalArgumentException(String.valueOf(thisClassName) + " doesn't support " + className);
        }
        return elementList;
    }

    private void processThroughputTests(List<Pair<FlowInstance, Object>> elementList, ThroughputFlowTest test) {
    }

    private void processHttpFlow(List<Pair<FlowInstance, Object>> elementList, HttpFlowInstance httpFlowInstance) {
        if (httpFlowInstance.getParent() != null) {
            return;
        }
        HttpFlowInstanceReader httpFlowInstanceReader = EntityReaderFactory.create((HttpFlowInstance)httpFlowInstance);
        if (httpFlowInstanceReader.isConfigured()) {
            elementList.add((Pair<FlowInstance, Object>)new Pair((Object)httpFlowInstance, (Object)httpFlowInstanceReader.getSourceHttpSession()));
            elementList.add((Pair<FlowInstance, Object>)new Pair((Object)httpFlowInstance, (Object)httpFlowInstanceReader.getDestinationHttpSession()));
        } else {
            elementList.add((Pair<FlowInstance, Object>)new Pair((Object)httpFlowInstance, null));
        }
    }

    private void processFbFlow(List<Pair<FlowInstance, Object>> elementList, FbFlowInstance fbFlowInstance) {
        if (fbFlowInstance.getParent() != null) {
            return;
        }
        FbFlowInstanceReader fbFlowInstanceReader = EntityReaderFactory.create((FbFlowInstance)fbFlowInstance);
        if (fbFlowInstanceReader.isConfigured()) {
            elementList.add((Pair<FlowInstance, Object>)new Pair((Object)fbFlowInstance, (Object)fbFlowInstanceReader.getSource()));
            for (FbDestination fbActualDestination : fbFlowInstanceReader.getDestinations()) {
                elementList.add((Pair<FlowInstance, Object>)new Pair((Object)fbFlowInstance, (Object)fbActualDestination));
            }
            for (FbDestination fbEavesdropperDestination : fbFlowInstanceReader.getEavesdroppers()) {
                elementList.add((Pair<FlowInstance, Object>)new Pair((Object)fbFlowInstance, (Object)fbEavesdropperDestination));
            }
        } else {
            elementList.add((Pair<FlowInstance, Object>)new Pair((Object)fbFlowInstance, null));
        }
    }
}

