/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime.composites;

import com.excentis.products.byteblower.results.testdata.data.entities.Layer3;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv4Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6Session;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionAddress;
import com.excentis.products.byteblower.results.testdata.data.entities.Layer3Ipv6SessionPrefix;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredContentProvider;

class PortLayer3TableContentProvider
implements IStructuredContentProvider {
    PortLayer3TableContentProvider() {
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof List) {
            return this.processList((List)inputElement).toArray();
        }
        throw new IllegalArgumentException(String.valueOf(this.getClass().getSimpleName()) + " only takes list of Port entities as input; input was " + inputElement.getClass().getSimpleName());
    }

    private List<Object> processList(List<?> inputList) {
        ArrayList<Object> elementList = new ArrayList<Object>();
        for (Object obj : inputList) {
            if (obj instanceof Port) {
                this.processPort((Port)obj, elementList);
                continue;
            }
            String thisClass = this.getClass().getSimpleName();
            String portClass = obj.getClass().getSimpleName();
            throw new IllegalArgumentException(String.valueOf(thisClass) + " doesn't support " + portClass);
        }
        return elementList;
    }

    private void processPort(Port portToDescribe, List<Object> elementList) {
        Layer3 l3config = portToDescribe.getLayer3();
        if (l3config instanceof Layer3Ipv4) {
            Layer3Ipv4Session l3session = ((Layer3Ipv4)l3config).getSession();
            if (l3session != null) {
                elementList.add(l3session);
            } else {
                elementList.add(portToDescribe.getLayer3());
            }
        } else if (l3config instanceof Layer3Ipv6) {
            Layer3Ipv6Session l3session = ((Layer3Ipv6)l3config).getSession();
            if (l3session != null) {
                elementList.add(l3session);
                for (Layer3Ipv6SessionPrefix prefix : l3session.getPrefixes()) {
                    for (Layer3Ipv6SessionAddress address : prefix.getAddresses()) {
                        elementList.add(address);
                    }
                }
            } else {
                elementList.add(portToDescribe.getLayer3());
            }
        } else {
            elementList.add(portToDescribe);
        }
    }
}

