/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.realtime.composites;

import com.excentis.products.byteblower.gui.views.realtime.composites.FlowInstanceTableContentProvider;
import com.excentis.products.byteblower.gui.views.realtime.composites.FlowsLabelProvider;
import com.excentis.products.byteblower.gui.views.realtime.util.IndexedSet;
import com.excentis.products.byteblower.gui.views.realtime.util.WatchDogValue;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.provider.ByteBlowerColor;
import com.excentis.products.byteblower.results.testdata.data.entities.FbDestination;
import com.excentis.products.byteblower.results.testdata.data.entities.FbFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.FbLatency;
import com.excentis.products.byteblower.results.testdata.data.entities.FbOutOfSequence;
import com.excentis.products.byteblower.results.testdata.data.entities.FbSource;
import com.excentis.products.byteblower.results.testdata.data.entities.FbTrigger;
import com.excentis.products.byteblower.results.testdata.data.entities.Flow;
import com.excentis.products.byteblower.results.testdata.data.entities.FlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpFlowInstance;
import com.excentis.products.byteblower.results.testdata.data.entities.HttpSession;
import com.excentis.products.byteblower.results.testdata.data.entities.Port;
import com.excentis.products.byteblower.results.testdata.data.entities.ThroughputFlowTest;
import com.excentis.products.byteblower.results.testdata.data.entities.interfaces.IFbEndpoint;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.EntityReaderFactory;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencyReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbLatencySnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbOutOfSequenceSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.FbTriggerSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpFlowInstanceReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionReader;
import com.excentis.products.byteblower.results.testdata.data.entities.readers.HttpSessionSnapshotReader;
import com.excentis.products.byteblower.results.testdata.data.enums.FlowInstanceStatus;
import com.excentis.products.byteblower.results.testdata.data.enums.HttpApplicationType;
import com.excentis.products.byteblower.results.testdata.data.enums.ScenarioStatus;
import com.excentis.products.byteblower.results.testdata.data.utils.EthernetThroughputType;
import com.excentis.products.byteblower.results.testdata.data.utils.LatencyUnit;
import com.excentis.products.byteblower.utils.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class RealtimeFlowsComposite
extends Composite {
    private TableViewer dataViewer;
    private Map<EViewerColumn, TableViewerColumn> columnMap = new HashMap<EViewerColumn, TableViewerColumn>();
    private IndexedSet<Object> cachedFlowInstanceList;
    private com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit cachedThroughputUnit;
    private int cachedThroughputDecimalNumbers;
    private LatencyUnit cachedLatencyUnit;
    private int digitsToDisplay;
    private EthernetThroughputType cachedEthernetThroughputType;
    private ScenarioStatus currentStatus = ScenarioStatus.CREATED;

    public RealtimeFlowsComposite(Composite parent) {
        super(parent, 0);
        this.setLayout((Layout)new GridLayout());
        Label titleLabel = new Label((Composite)this, 0);
        titleLabel.setLayoutData((Object)new GridData(0, 0, true, false));
        this.dataViewer = new TableViewer((Composite)this, 68098);
        this.dataViewer.getTable().setHeaderVisible(true);
        this.dataViewer.getTable().setLayoutData((Object)new GridData(4, 4, true, true));
        titleLabel.setText("Flows");
        EViewerColumn[] eViewerColumnArray = EViewerColumn.values();
        int n = eViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            EViewerColumn eColumn = eViewerColumnArray[n2];
            TableViewerColumn viewerColumn = new TableViewerColumn(this.dataViewer, 0);
            this.columnMap.put(eColumn, viewerColumn);
            viewerColumn.getColumn().setText(eColumn.getColumnTitle());
            viewerColumn.getColumn().setAlignment(eColumn.getAlignment());
            viewerColumn.setLabelProvider(this.createLabelProvider(eColumn));
            ++n2;
        }
        this.dataViewer.getTable().getParent().addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                RealtimeFlowsComposite.this.resizeTableColumns();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.resizeTableColumns();
        this.dataViewer.setContentProvider((IContentProvider)new FlowInstanceTableContentProvider());
        this.dataViewer.setInput(null);
        this.setEnabled(false);
    }

    public void updateInput(ScenarioStatus scenarioStatus, List<FlowInstance> flowInstanceList, List<ThroughputFlowTest> throughputTests, ByteBlowerProject runningModelProject) {
        ArrayList<Object> allToShow = new ArrayList<Object>();
        allToShow.addAll(flowInstanceList);
        allToShow.addAll(throughputTests);
        this.cachedFlowInstanceList = new IndexedSet(allToShow);
        this.currentStatus = scenarioStatus;
        this.cachedThroughputUnit = this.convertThroughputUnit(runningModelProject.getThroughputUnit());
        this.cachedThroughputDecimalNumbers = runningModelProject.getNumberOfDecimals();
        this.cachedLatencyUnit = this.convertLatencyUnit(runningModelProject.getLatencyUnit());
        this.digitsToDisplay = runningModelProject.getNumberOfLatencyDecimals();
        this.cachedEthernetThroughputType = this.convertEthernetThroughputType(runningModelProject.getThroughputType());
        EViewerColumn.BITRATE.setUnitString(this.cachedThroughputUnit.toString());
        EViewerColumn.LATENCY.setUnitString(this.cachedLatencyUnit.toString());
        this.columnMap.get((Object)EViewerColumn.BITRATE).getColumn().setText(EViewerColumn.BITRATE.getColumnTitle());
        this.columnMap.get((Object)EViewerColumn.LATENCY).getColumn().setText(EViewerColumn.LATENCY.getColumnTitle());
        this.dataViewer.setInput(allToShow);
    }

    public void resetInput() {
        this.dataViewer.setInput(null);
    }

    private com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit convertThroughputUnit(DataRateUnit mDataRateUnit) {
        switch (mDataRateUnit) {
            case BPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.BIT_PER_SECOND;
            }
            case BYTESPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.BYTE_PER_SECOND;
            }
            case KBPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.KILOBIT_PER_SECOND;
            }
            case KBYTESPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.BYTE_PER_SECOND;
            }
            case MBPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.MEGABIT_PER_SECOND;
            }
            case MBYTESPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.MEGABYTE_PER_SECOND;
            }
            case GBPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.GIGABIT_PER_SECOND;
            }
            case GBYTESPS: {
                return com.excentis.products.byteblower.results.testdata.data.utils.DataRateUnit.GIGABYTE_PER_SECOND;
            }
        }
        return null;
    }

    private LatencyUnit convertLatencyUnit(int mLatencyUnit) {
        switch (mLatencyUnit) {
            case 13: {
                return LatencyUnit.SECONDS;
            }
            case 14: {
                return LatencyUnit.MILLISECONDS;
            }
            case 17: {
                return LatencyUnit.MICROSECONDS;
            }
            case 18: {
                return LatencyUnit.NANOSECONDS;
            }
        }
        return null;
    }

    private EthernetThroughputType convertEthernetThroughputType(ThroughputType mEthernetThroughputType) {
        switch (mEthernetThroughputType) {
            case FRAME_ONLY: {
                return EthernetThroughputType.FRAME_ONLY;
            }
            case FRAME_AND_FCS: {
                return EthernetThroughputType.FRAME_WITH_FCS;
            }
            case FRAME_AND_ALL_OTHER_FIELDS: {
                return EthernetThroughputType.FRAME_FULL_LAYER1_INCL_IFG;
            }
        }
        return null;
    }

    private CellLabelProvider createLabelProvider(final EViewerColumn eColumn) {
        switch (eColumn) {
            case FLOW: {
                return this.createLabelProviderForFlow();
            }
            case ROLE: {
                return this.createLabelProviderForRole();
            }
            case PORT: {
                return this.createLabelProviderForPort();
            }
            case BITRATE: {
                return this.createLabelProviderForBitrate();
            }
            case FRAMERATE: {
                return this.createLabelProviderForFrameRate();
            }
            case LATENCY: {
                return this.createLabelProviderForLatency();
            }
            case OUTOFSEQUENCE: {
                return this.createLabelProviderForOutofsequence();
            }
        }
        return new FlowsLabelProvider(this, false){

            @Override
            protected String deriveValue(FlowInstance flow, Object port) {
                return "#WARNING: unhandled column " + eColumn.toString();
            }
        };
    }

    private boolean isEndpointAlive(Object endPoint, Map<Port, WatchDogValue> alivePorts) {
        if (!(endPoint instanceof IFbEndpoint)) {
            return true;
        }
        IFbEndpoint fbEndPoint = (IFbEndpoint)endPoint;
        Port port = fbEndPoint.getPort();
        if (port == null) {
            return true;
        }
        if (!port.isDockedMobile()) {
            return true;
        }
        WatchDogValue current = alivePorts.computeIfAbsent(port, p -> new WatchDogValue());
        boolean hasRegularUpdates = ScenarioStatus.RUNNING.equals((Object)this.currentStatus);
        if (!hasRegularUpdates) {
            current.isStillAlive(new Object());
        }
        return current.isStillAlive(port.lastSeen);
    }

    private CellLabelProvider createLabelProviderForOutofsequence() {
        return new FlowsLabelProvider(this, true){
            Map<Port, WatchDogValue> alivePorts;
            {
                this.alivePorts = new HashMap<Port, WatchDogValue>();
            }

            @Override
            protected String deriveValue(FlowInstance flow, Object endPoint) {
                if (endPoint == null) {
                    return "";
                }
                if (!RealtimeFlowsComposite.this.isEndpointAlive(endPoint, this.alivePorts)) {
                    return "";
                }
                if (endPoint instanceof FbSource) {
                    return "";
                }
                if (endPoint instanceof FbDestination) {
                    if (((FbDestination)endPoint).getOutOfSequence() == null) {
                        return "";
                    }
                    FbOutOfSequenceReader oosRdr = EntityReaderFactory.create((FbOutOfSequence)((FbDestination)endPoint).getOutOfSequence());
                    FbOutOfSequenceSnapshotReader latestSnapshotRdr = oosRdr.getLatestSnapshotReader();
                    if (latestSnapshotRdr == null) {
                        return "";
                    }
                    Double framerate = latestSnapshotRdr.getOutOfSequenceFrameRate();
                    if (framerate == null) {
                        return "";
                    }
                    return "" + framerate;
                }
                if (endPoint instanceof HttpSession) {
                    return "";
                }
                return "#WARNING: unhandled end point data element type " + endPoint.getClass().getSimpleName();
            }
        };
    }

    private CellLabelProvider createLabelProviderForLatency() {
        return new FlowsLabelProvider(this, true){
            Map<Port, WatchDogValue> alivePorts;
            {
                this.alivePorts = new HashMap<Port, WatchDogValue>();
            }

            @Override
            protected String deriveValue(FlowInstance flow, Object endPoint) {
                if (endPoint == null) {
                    return "";
                }
                if (!RealtimeFlowsComposite.this.isEndpointAlive(endPoint, this.alivePorts)) {
                    return "";
                }
                if (endPoint instanceof FbSource) {
                    return "";
                }
                if (endPoint instanceof FbDestination) {
                    if (((FbDestination)endPoint).getLatency() == null) {
                        return "";
                    }
                    FbLatencyReader latencyRdr = EntityReaderFactory.create((FbLatency)((FbDestination)endPoint).getLatency());
                    FbLatencySnapshotReader latestSnapshotRdr = latencyRdr.getLatestSnapshotReader();
                    if (latestSnapshotRdr == null) {
                        return "";
                    }
                    Double avgLatency = latestSnapshotRdr.getLatencyAverage(RealtimeFlowsComposite.this.cachedLatencyUnit);
                    if (avgLatency == null) {
                        return "";
                    }
                    return String.format("%,." + RealtimeFlowsComposite.this.digitsToDisplay + "f", avgLatency);
                }
                if (endPoint instanceof HttpSession) {
                    return "";
                }
                return "#WARNING: unhandled end point data element type " + endPoint.getClass().getSimpleName();
            }
        };
    }

    private CellLabelProvider createLabelProviderForFrameRate() {
        return new FlowsLabelProvider(this, true){
            Map<Port, WatchDogValue> alivePorts;
            {
                this.alivePorts = new HashMap<Port, WatchDogValue>();
            }

            @Override
            protected String deriveValue(FlowInstance flow, Object endPoint) {
                if (endPoint == null) {
                    return "";
                }
                if (!RealtimeFlowsComposite.this.isEndpointAlive(endPoint, this.alivePorts)) {
                    return "";
                }
                if (endPoint instanceof IFbEndpoint) {
                    if (((IFbEndpoint)endPoint).getTrigger() == null) {
                        return "";
                    }
                    FbTriggerReader triggerRdr = EntityReaderFactory.create((FbTrigger)((IFbEndpoint)endPoint).getTrigger());
                    FbTriggerSnapshotReader latestSnapshotRdr = triggerRdr.getLatestSnapshotReader();
                    if (latestSnapshotRdr == null) {
                        return "";
                    }
                    Double framerate = latestSnapshotRdr.getFrameRate();
                    if (framerate == null) {
                        return "";
                    }
                    return String.format("%,.1f", framerate);
                }
                if (endPoint instanceof HttpSession) {
                    return "";
                }
                return "#WARNING: unhandled end point data element type " + endPoint.getClass().getSimpleName();
            }
        };
    }

    private CellLabelProvider createLabelProviderForPort() {
        return new FlowsLabelProvider(this, false){

            @Override
            protected String deriveValue(FlowInstance flow, Object endPoint) {
                if (endPoint == null) {
                    return "";
                }
                if (endPoint instanceof FbSource) {
                    return ((FbSource)endPoint).getPort().getName();
                }
                if (endPoint instanceof FbDestination) {
                    return ((FbDestination)endPoint).getPort().getName();
                }
                if (endPoint instanceof HttpSession) {
                    return ((HttpSession)endPoint).getHttpApplication().getPort().getName();
                }
                return "#WARNING: unhandled end point data element type " + endPoint.getClass().getSimpleName();
            }
        };
    }

    private CellLabelProvider createLabelProviderForBitrate() {
        return new FlowsLabelProvider(this, true){
            Map<Port, WatchDogValue> alivePorts;
            {
                this.alivePorts = new HashMap<Port, WatchDogValue>();
            }

            @Override
            protected String deriveValue(FlowInstance flow, Object endPoint) {
                if (endPoint == null) {
                    return "";
                }
                if (endPoint instanceof IFbEndpoint) {
                    if (((IFbEndpoint)endPoint).getTrigger() == null) {
                        return "";
                    }
                    if (!RealtimeFlowsComposite.this.isEndpointAlive(endPoint, this.alivePorts)) {
                        return "Unavailable";
                    }
                    FbTriggerReader triggerRdr = EntityReaderFactory.create((FbTrigger)((IFbEndpoint)endPoint).getTrigger());
                    FbTriggerSnapshotReader latestSnapshotRdr = triggerRdr.getLatestSnapshotReader();
                    if (latestSnapshotRdr == null) {
                        return "";
                    }
                    Double throughput = latestSnapshotRdr.getThroughput(RealtimeFlowsComposite.this.cachedEthernetThroughputType, RealtimeFlowsComposite.this.cachedThroughputUnit);
                    if (throughput == null) {
                        return "";
                    }
                    return String.format("%,." + RealtimeFlowsComposite.this.cachedThroughputDecimalNumbers + "f", throughput);
                }
                if (endPoint instanceof HttpSession) {
                    Double throughput;
                    HttpFlowInstance httpFlowInstance = (HttpFlowInstance)flow;
                    if (httpFlowInstance.getRequestStatus() == null) {
                        return "";
                    }
                    switch (httpFlowInstance.getRequestStatus()) {
                        case CONFIGURING: {
                            return "";
                        }
                        case CONNECTING: {
                            return "connecting";
                        }
                        case ERROR: {
                            return "failed";
                        }
                        case SCHEDULED: {
                            return "pending";
                        }
                        case FINISHED: {
                            return "finished";
                        }
                        case STOPPED: {
                            return "#WARNING: unexpected request state STOPPED";
                        }
                    }
                    HttpSessionReader httpSessionRdr = EntityReaderFactory.create((HttpSession)((HttpSession)endPoint));
                    HttpSessionSnapshotReader latestSnapshotRdr = httpSessionRdr.getLatestSnapshotReader();
                    if (latestSnapshotRdr == null) {
                        return "";
                    }
                    if (((HttpSession)endPoint).getHttpApplication().getPort().isDockedMobile()) {
                        return "";
                    }
                    if (HttpFlowInstanceReader.getSourceHttpSession((HttpFlowInstance)((HttpFlowInstance)flow)).equals(endPoint)) {
                        throughput = latestSnapshotRdr.getTxThroughput(RealtimeFlowsComposite.this.cachedThroughputUnit);
                    } else if (HttpFlowInstanceReader.getDestinationHttpSession((HttpFlowInstance)((HttpFlowInstance)flow)).equals(endPoint)) {
                        throughput = latestSnapshotRdr.getRxThroughput(RealtimeFlowsComposite.this.cachedThroughputUnit);
                    } else {
                        return "#WARNING: end point is neither source nor destination session of flow";
                    }
                    if (throughput == null) {
                        return "";
                    }
                    return String.format("%,." + RealtimeFlowsComposite.this.cachedThroughputDecimalNumbers + "f", throughput);
                }
                return "#WARNING: unhandled end point data element type " + endPoint.getClass().getSimpleName();
            }
        };
    }

    private CellLabelProvider createLabelProviderForRole() {
        return new FlowsLabelProvider(this, false){

            @Override
            protected String deriveValue(FlowInstance flow, Object endPoint) {
                if (endPoint == null) {
                    return "";
                }
                if (endPoint instanceof FbSource) {
                    return "Transmitter";
                }
                if (endPoint instanceof FbDestination) {
                    if (((FbFlowInstance)flow).getDestinationConfig().getEavesdroppers().contains(endPoint)) {
                        return "Receiver (eavesdropper)";
                    }
                    return "Receiver";
                }
                if (endPoint instanceof HttpSession) {
                    HttpApplicationType httpType = ((HttpSession)endPoint).getHttpApplication().getApplicationType();
                    String side = HttpFlowInstanceReader.isSourceHttpSession((HttpFlowInstance)((HttpFlowInstance)flow), (HttpSession)((HttpSession)endPoint)) ? "Transmitter" : "Receiver";
                    if (httpType == HttpApplicationType.CLIENT) {
                        return String.valueOf(side) + " (client)";
                    }
                    if (httpType == HttpApplicationType.SERVER) {
                        return String.valueOf(side) + " (server)";
                    }
                    return "#WARNING: unhandled HttpApplicationType " + httpType;
                }
                return "";
            }
        };
    }

    private CellLabelProvider createLabelProviderForFlow() {
        return new FlowsLabelProvider(this, false){

            @Override
            public void update(ViewerCell cell) {
                super.update(cell);
                FlowInstance flowInstance = this.getFlowInstance(cell.getElement());
                if (flowInstance != null && (flowInstance.getStatus() == FlowInstanceStatus.CONFIGURATION_ERROR || flowInstance.getStatus() == FlowInstanceStatus.STOPPED_ERROR)) {
                    cell.setForeground(ByteBlowerColor.red);
                }
                if (flowInstance != null && (flowInstance.getStatus() == FlowInstanceStatus.CONFIGURED_WARNING || flowInstance.getStatus() == FlowInstanceStatus.ACTIVE_WARNING || flowInstance.getStatus() == FlowInstanceStatus.STOPPED_WARNING)) {
                    cell.setForeground(ByteBlowerColor.pink);
                }
            }

            private FlowInstance getFlowInstance(Object element) {
                Pair pair;
                if (element instanceof Pair && (pair = (Pair)element).getFirst() instanceof FlowInstance) {
                    return (FlowInstance)pair.getFirst();
                }
                return null;
            }

            @Override
            protected String deriveValue(FlowInstance flowInstance, Object endPoint) {
                Flow flow = flowInstance.getFlow();
                if (endPoint == null) {
                    return flow.getName();
                }
                if (endPoint instanceof FbSource) {
                    return flow.getName();
                }
                if (endPoint instanceof FbDestination) {
                    return "";
                }
                if (endPoint instanceof HttpSession) {
                    HttpSession sourceHttpSession = EntityReaderFactory.create((HttpFlowInstance)((HttpFlowInstance)flowInstance)).getSourceHttpSession();
                    if (endPoint.equals(sourceHttpSession)) {
                        return flow.getName();
                    }
                    return "";
                }
                return "";
            }
        };
    }

    private void resizeTableColumns() {
        TableLayout tableLayout = new TableLayout();
        EViewerColumn[] eViewerColumnArray = EViewerColumn.values();
        int n = eViewerColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            EViewerColumn eColumn = eViewerColumnArray[n2];
            tableLayout.addColumnData((ColumnLayoutData)new ColumnWeightData(eColumn.getColumnWeight(), true));
            ++n2;
        }
        this.dataViewer.getTable().setLayout((Layout)tableLayout);
    }

    public void setEnabled(boolean enabled) {
        this.dataViewer.getTable().setEnabled(enabled);
        super.setEnabled(enabled);
    }

    public int getIndex(FlowInstance flowInstance) {
        if (this.cachedFlowInstanceList == null) {
            return -1;
        }
        return this.cachedFlowInstanceList.indexOf(flowInstance);
    }

    private static enum EViewerColumn {
        FLOW("Flow", null, 15, 16384),
        ROLE("Role", null, 10, 16384),
        PORT("Port", null, 15, 16384),
        BITRATE("Bitrate", null, 15, 131072),
        FRAMERATE("Framerate", "fps", 15, 131072),
        LATENCY("Latency", null, 15, 131072),
        OUTOFSEQUENCE("Out of sequence framerate", "fps", 15, 131072);

        private String title;
        private String unitString;
        private int columnWeight;
        private int alignment;

        private EViewerColumn(String title, String unitString, int columnWeight, int alignment) {
            this.title = title;
            this.unitString = unitString;
            this.columnWeight = columnWeight;
            this.alignment = alignment;
        }

        public String getColumnTitle() {
            return String.valueOf(this.title) + (this.unitString != null ? " (" + this.unitString + ")" : "");
        }

        public int getColumnWeight() {
            return this.columnWeight;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public void setUnitString(String unitString) {
            this.unitString = unitString;
        }
    }
}

