/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.WizardLauncher;
import com.excentis.products.byteblower.gui.views.LinkMessageDialog;
import com.excentis.products.byteblower.gui.wizards.backtoback.BackToBackWizard;
import com.excentis.products.byteblower.gui.wizards.frameimport.FrameImportWizard;
import com.excentis.products.byteblower.gui.wizards.framesize.FrameSizeWizard;
import com.excentis.products.byteblower.gui.wizards.rfc2544.RFC2544Wizard;
import com.excentis.products.byteblower.gui.wizards.throughput.ThroughputWizard;
import com.excentis.products.byteblower.utils.Utils;
import java.io.File;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    private static Activator plugin;

    private static void openWizard(IWizard wizard) {
        Shell current = PlatformUI.getWorkbench().getDisplay().getActiveShell();
        WizardDialog dialog = new WizardDialog(current, wizard);
        dialog.open();
    }

    public Activator() {
        plugin = this;
    }

    private void showInfoOnce64BitAvailable() {
        if (ByteBlowerPreferences.get64BitVersionAvailableMessageShown()) {
            return;
        }
        ByteBlowerPreferences.set64BitVersionAvailableMessageShown();
        if (Utils.running32Bit()) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            LinkMessageDialog dialog = new LinkMessageDialog(shell);
            dialog.open();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.checkArchive();
        WizardLauncher.registerWizard((String)"Pcap import", (Runnable)new Runnable(){

            @Override
            public void run() {
                Activator.openWizard((IWizard)new FrameImportWizard());
            }
        });
        WizardLauncher.registerWizard((String)"RFC 2544", (Runnable)new Runnable(){

            @Override
            public void run() {
                Activator.openWizard(new RFC2544Wizard());
            }
        });
        WizardLauncher.registerWizard((String)"Back-to-Back", (Runnable)new Runnable(){

            @Override
            public void run() {
                Activator.openWizard(new BackToBackWizard());
            }
        });
        WizardLauncher.registerWizard((String)"Frame size", (Runnable)new Runnable(){

            @Override
            public void run() {
                Activator.openWizard(new FrameSizeWizard());
            }
        });
        WizardLauncher.registerWizard((String)"Throughput", (Runnable)new Runnable(){

            @Override
            public void run() {
                Activator.openWizard(new ThroughputWizard());
            }
        });
        this.showInfoOnce64BitAvailable();
    }

    private void checkArchive() {
        String archiveLocation = ByteBlowerPreferences.getArchiveLocation();
        File archive = new File(archiveLocation);
        if (!archive.exists()) {
            System.out.println("Creating the archive location : " + archiveLocation);
            if (!archive.mkdirs()) {
                System.out.println("Failed to create the archive location...");
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }
}

