/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views;

import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchCopyAction;
import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchCutAction;
import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchDeleteAction;
import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchGroupAction;
import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchNewAction;
import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchPasteAction;
import com.excentis.products.byteblower.gui.history.actiondispatcher.ByteBlowerDispatchUngroupAction;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerComposite;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.history.actions.IByteBlowerViewerComposite;
import com.excentis.products.byteblower.gui.history.actions.IFocusWidgetChangeListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.project.ByteBlowerMenuItemEnabler;
import com.excentis.products.byteblower.gui.project.IByteBlowerMenuItemEnabler;
import com.excentis.products.byteblower.gui.swt.actions.RedoAction;
import com.excentis.products.byteblower.gui.swt.actions.UndoAction;
import com.excentis.products.byteblower.gui.swt.composites.sash.ByteBlowerSashForm;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.views.batch.BatchView;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpView;
import com.excentis.products.byteblower.gui.views.flow.FlowView;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingView;
import com.excentis.products.byteblower.gui.views.multicast.MulticastView;
import com.excentis.products.byteblower.gui.views.port.PortView;
import com.excentis.products.byteblower.gui.views.portforwarding.PortForwardingView;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioView;
import com.excentis.products.byteblower.gui.views.server.ServerView;
import com.excentis.products.byteblower.gui.views.tcp.TcpView;
import com.excentis.products.byteblower.gui.views.vlan.VlanView;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import java.util.ArrayList;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public abstract class ByteBlowerViewPart
extends ViewPart
implements IByteBlowerFocusDispatcher,
IByteBlowerAction,
IByteBlowerMenuItemEnabler {
    private final int MARGIN_WIDTH = 3;
    private final int MARGIN_HEIGHT = 3;
    private Composite parent;
    private ByteBlowerSashForm topComposites;
    private ByteBlowerSashForm bottomComposites;
    private ByteBlowerComposite topLeft = null;
    private ByteBlowerComposite topMiddle = null;
    private ByteBlowerComposite topRight = null;
    private ByteBlowerComposite bottomLeft = null;
    private ByteBlowerComposite bottomMiddle = null;
    private ByteBlowerComposite bottomRight = null;
    private IByteBlowerComposite currentFocusComposite = null;
    private UndoAction undoAction;
    private RedoAction redoAction;
    private ByteBlowerDispatchNewAction newAction;
    private ByteBlowerDispatchDeleteAction deleteAction;
    private ByteBlowerDispatchCutAction cutAction;
    private ByteBlowerDispatchCopyAction copyAction;
    private ByteBlowerDispatchPasteAction pasteAction;
    private ByteBlowerDispatchGroupAction groupAction;
    private ByteBlowerDispatchUngroupAction ungroupAction;
    private static final int[] topWeights = new int[]{1, 1};
    private ArrayList<IFocusWidgetChangeListener> focusChangeListeners;

    private ByteBlowerSashForm getTopComposites() {
        if (this.topComposites == null) {
            this.topComposites = this.createTopSashForm();
        }
        return this.topComposites;
    }

    protected ByteBlowerSashForm getBottomComposites() {
        if (this.bottomComposites == null) {
            this.bottomComposites = this.createBottomSashForm();
        }
        return this.bottomComposites;
    }

    private ByteBlowerSashForm createTopSashForm() {
        return new ByteBlowerSashForm(this.parent, 0);
    }

    private ByteBlowerSashForm createBottomSashForm() {
        return new ByteBlowerSashForm(this.parent, 0);
    }

    protected ByteBlowerComposite getTopLeft() {
        return this.topLeft;
    }

    protected ByteBlowerComposite getBottomLeft() {
        return this.bottomLeft;
    }

    public void dispose() {
        ByteBlowerMenuItemEnabler.removeMenuEnableListener((IByteBlowerMenuItemEnabler)this);
        super.dispose();
    }

    public void setFocus() {
    }

    public void createPartControl(Composite parent) {
        this.registerGlobalActions();
        this.createControls(parent);
        this.focusOnTopLeft();
        this.initToolBar();
        this.setParentLayout(parent);
        this.registerContextMenu();
    }

    private void focusOnTopLeft() {
        this.getTopLeft().setFocus();
    }

    protected void initToolBar() {
    }

    private void registerContextMenu() {
        ByteBlowerMenuItemEnabler.addMenuEnableListener((IByteBlowerMenuItemEnabler)this);
    }

    private void registerGlobalActions() {
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.newAction = new ByteBlowerDispatchNewAction((IByteBlowerFocusDispatcher)this);
        this.deleteAction = new ByteBlowerDispatchDeleteAction((IByteBlowerFocusDispatcher)this);
        this.copyAction = new ByteBlowerDispatchCopyAction((IByteBlowerFocusDispatcher)this);
        this.pasteAction = new ByteBlowerDispatchPasteAction((IByteBlowerFocusDispatcher)this);
        this.cutAction = new ByteBlowerDispatchCutAction((IByteBlowerFocusDispatcher)this);
        this.groupAction = new ByteBlowerDispatchGroupAction((IByteBlowerFocusDispatcher)this);
        this.ungroupAction = new ByteBlowerDispatchUngroupAction((IByteBlowerFocusDispatcher)this);
        IViewSite viewSite = this.getViewSite();
        IActionBars actionBars = viewSite.getActionBars();
        actionBars.setGlobalActionHandler(ActionFactory.NEW.getId(), (IAction)this.newAction);
        actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
        actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
        actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
        actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
        actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
        actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
    }

    private void setParentLayout(Composite parent) {
        FillLayout layout = new FillLayout();
        layout.marginWidth = 3;
        layout.marginHeight = 3;
        parent.setLayout((Layout)layout);
    }

    private void createControls(Composite parent) {
        this.parent = parent;
        this.topLeft = this.createTopLeftControl(parent);
        this.topMiddle = this.createTopMiddleControl(parent);
        this.topRight = this.createTopRightControl(parent);
        this.bottomLeft = this.createBottomLeftControl(parent);
        this.bottomMiddle = this.createBottomMiddleControl(parent);
        this.bottomRight = this.createBottomRightControl(parent);
        if (this.topMiddle != null || this.topRight != null) {
            this.getTopComposites();
            this.topLeft.setParent((Composite)this.topComposites);
            if (this.topMiddle != null) {
                this.topMiddle.setParent((Composite)this.topComposites);
            }
            if (this.topRight != null) {
                this.topRight.setParent((Composite)this.topComposites);
            }
            int[] topWeights = this.getTopWeights();
            this.topComposites.setWeights(topWeights);
        }
        if (this.bottomMiddle != null || this.bottomRight != null) {
            this.getBottomComposites();
            this.bottomLeft.setParent((Composite)this.bottomComposites);
            if (this.bottomMiddle != null) {
                this.bottomMiddle.setParent((Composite)this.bottomComposites);
            }
            if (this.bottomRight != null) {
                this.bottomRight.setParent((Composite)this.bottomComposites);
            }
            int[] bottomWeights = this.getBottomWeights();
            this.bottomComposites.setWeights(bottomWeights);
        }
        if (this.topLeft != null && this.bottomLeft != null) {
            SashForm verticalSashForm = new SashForm(parent, 512);
            if (this.topComposites != null) {
                this.topComposites.setParent((Composite)verticalSashForm);
            } else if (this.topLeft != null) {
                this.topLeft.setParent((Composite)verticalSashForm);
            }
            if (this.bottomComposites != null) {
                this.bottomComposites.setParent((Composite)verticalSashForm);
            } else if (this.bottomLeft != null) {
                this.bottomLeft.setParent((Composite)verticalSashForm);
            }
            int[] verticalWeights = this.getVerticalWeights();
            if (verticalWeights != null) {
                verticalSashForm.setWeights(verticalWeights);
            }
        }
    }

    protected int[] getTopWeights() {
        return topWeights;
    }

    protected int[] getBottomWeights() {
        return null;
    }

    protected int[] getVerticalWeights() {
        return null;
    }

    protected abstract ByteBlowerComposite createTopLeftControl(Composite var1);

    public void doNew() {
        this.newAction.run();
    }

    public void doCut() {
        this.cutAction.run();
    }

    public void doCopy() {
        this.copyAction.run();
    }

    public void doPaste() {
        this.pasteAction.run();
    }

    public void doDelete() {
        this.deleteAction.run();
    }

    public void doGroup() {
        this.groupAction.run();
    }

    public void doUngroup() {
        this.ungroupAction.run();
    }

    public void updateState() {
    }

    public boolean isNewEnabled() {
        System.out.println("ByteBlowerViewPart::isNewEnabled " + this.newAction.isEnabled() + " on " + (Object)((Object)this));
        return this.newAction.isEnabled();
    }

    public boolean isCutEnabled() {
        return this.cutAction.isEnabled();
    }

    public boolean isCopyEnabled() {
        return this.copyAction.isEnabled();
    }

    public boolean isPasteEnabled() {
        return this.pasteAction.isEnabled();
    }

    public boolean isDeleteEnabled() {
        return this.deleteAction.isEnabled();
    }

    public boolean isGroupEnabled() {
        return this.groupAction.isEnabled();
    }

    public boolean isUngroupEnabled() {
        return this.ungroupAction.isEnabled();
    }

    protected ByteBlowerComposite createTopMiddleControl(Composite parent) {
        return null;
    }

    protected ByteBlowerComposite createTopRightControl(Composite parent) {
        return null;
    }

    protected ByteBlowerComposite createBottomLeftControl(Composite parent) {
        return null;
    }

    protected ByteBlowerComposite createBottomMiddleControl(Composite parent) {
        return null;
    }

    protected ByteBlowerComposite createBottomRightControl(Composite parent) {
        return null;
    }

    public void setCurrentFocusWidget(IByteBlowerComposite widget) {
        IByteBlowerComposite oldFocusComposite = this.currentFocusComposite;
        if (widget != this.currentFocusComposite) {
            this.currentFocusComposite = widget;
            this.notifyFocusWidgetChangeListeners(oldFocusComposite, this.currentFocusComposite);
        }
    }

    public IByteBlowerComposite getCurrentFocusComposite() {
        return this.currentFocusComposite;
    }

    public StructuredSelection getCurrentSelection() {
        StructuredViewer viewer = this.getCurrentViewer();
        return (StructuredSelection)viewer.getSelection();
    }

    public StructuredViewer getCurrentParentViewer() {
        return this.currentFocusComposite.getParentViewer();
    }

    public EByteBlowerObject getCurrentParentObject() {
        StructuredViewer parentViewer = this.getCurrentParentViewer();
        if (parentViewer == null) {
            return ByteBlowerGuiResourceController.getProject();
        }
        StructuredSelection selection = (StructuredSelection)parentViewer.getSelection();
        return (EByteBlowerObject)selection.getFirstElement();
    }

    private static IWorkbench getWorkbench() {
        return PlatformUI.getWorkbench();
    }

    private static IWorkbenchWindow getActiveWorkbenchWindow() {
        return ByteBlowerViewPart.getWorkbench().getActiveWorkbenchWindow();
    }

    public static ServerView showServerView() {
        ServerView serverView = (ServerView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.ServerView");
        return serverView;
    }

    public static PortView showPortView() {
        PortView view = (PortView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.PortView");
        return view;
    }

    public static MulticastView showMulticastView() {
        MulticastView view = (MulticastView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.MulticastView");
        return view;
    }

    public static FrameView showFrameView() {
        FrameView view = (FrameView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.FrameView");
        return view;
    }

    public static FrameBlastingView showFrameBlastingView() {
        FrameBlastingView view = (FrameBlastingView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingView");
        return view;
    }

    public static TcpView showTcpView() {
        TcpView view = (TcpView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.tcp.TcpView");
        return view;
    }

    public static FlowView showFlowView() {
        FlowView view = (FlowView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.FlowView");
        return view;
    }

    public static ScenarioView showScenarioView() {
        ScenarioView view = (ScenarioView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.scenario.ScenarioView");
        return view;
    }

    public static BatchView showBatchView() {
        BatchView view = (BatchView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.batch.BatchView");
        return view;
    }

    public static DhcpView showDhcpView() {
        DhcpView view = (DhcpView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.DhcpView");
        return view;
    }

    public static VlanView showVlanView() {
        VlanView view = (VlanView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.VlanView");
        return view;
    }

    public static PortForwardingView showPortForwardingView() {
        PortForwardingView view = (PortForwardingView)ByteBlowerViewPart.showView("com.excentis.products.byteblower.gui.views.PortForwardingView");
        return view;
    }

    public static IViewPart showView(String id) {
        IWorkbenchWindow win = ByteBlowerViewPart.getActiveWorkbenchWindow();
        try {
            return win.getActivePage().showView(id);
        }
        catch (PartInitException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ArrayList<IFocusWidgetChangeListener> getFocusChangeListeners() {
        if (this.focusChangeListeners == null) {
            this.focusChangeListeners = new ArrayList();
        }
        return this.focusChangeListeners;
    }

    public void addFocusWidgetChangeListener(IFocusWidgetChangeListener listener) {
        this.getFocusChangeListeners().add(listener);
    }

    public void removeFocusWidgetChangeListener(IFocusWidgetChangeListener listener) {
        this.getFocusChangeListeners().remove(listener);
    }

    private void notifyFocusWidgetChangeListeners(IByteBlowerComposite oldFocusComposite, IByteBlowerComposite newFocusComposite) {
        for (IFocusWidgetChangeListener listener : this.focusChangeListeners) {
            listener.focusWidgetChanged(oldFocusComposite, newFocusComposite);
        }
    }

    public StructuredViewer getCurrentViewer() {
        IByteBlowerViewerComposite currentViewerComposite = this.getCurrentViewerComposite();
        if (currentViewerComposite != null) {
            currentViewerComposite.getStructuredViewer();
        }
        return null;
    }

    private IByteBlowerViewerComposite getCurrentViewerComposite() {
        IByteBlowerComposite focusComposite = this.getCurrentFocusComposite();
        if (focusComposite instanceof IByteBlowerViewerComposite) {
            return (IByteBlowerViewerComposite)focusComposite;
        }
        return null;
    }
}

