/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.actions;

import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.results.dataprovider.data.entities.TestDataReference;
import com.excentis.products.byteblower.utils.Utils;
import com.excentis.products.byteblower.utils.zip.Zipper;
import java.util.Date;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class OpenProjectAction
extends Action {
    public OpenProjectAction() {
        super("Open Project Backup");
    }

    private void displayError(final String message) {
        Display display = PlatformUI.getWorkbench().getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                MessageDialog.openError((Shell)shell, (String)"Open Project Backup", (String)message);
            }
        });
    }

    public boolean run(TestDataReference selectedTestDataReference) {
        String backupFilename = Utils.getBackupFilename((Date)selectedTestDataReference.getStartTime());
        Path path = new Path(ByteBlowerPreferences.getArchiveLocation());
        path = path.append(backupFilename);
        path = path.addFileExtension("zip");
        String zipfile = path.toOSString();
        String bbpfile = zipfile.replaceAll(".zip", ".bbp");
        boolean unzip = true;
        if (unzip && !Zipper.unzip((String)zipfile, (String)bbpfile)) {
            this.displayError("Failed to unzip the backed up project.");
            return false;
        }
        ByteBlowerGuiResourceController resourceController = ByteBlowerGuiResourceController.getInstance();
        boolean openUnzipped = true;
        if (resourceController.isOpen()) {
            openUnzipped = resourceController.close();
        }
        if (openUnzipped && resourceController.openProject(bbpfile) != null) {
            return unzip;
        }
        return false;
    }
}

