/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.archive.composites;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.report.viewer.ReportViewer;
import com.excentis.products.byteblower.results.dataprovider.data.entities.Report;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

class GeneratedReportsLabelProvider
extends ColumnLabelProvider
implements ITableLabelProvider {
    private static final int COLUMN_REPORT_TIME = 0;
    private static final int COLUMN_REPORT_TYPE = 1;
    private static final int COLUMN_REPORT_FILE = 2;
    private ReportViewer reportViewer = ReportViewer.getInstance();
    public static final String[] columnNames = new String[]{"Time", "Type", "Filename"};
    public static final int[] columnWeights = new int[]{2, 1, 4};
    private final Image reportImage = ImageDescriptor.createFromFile(ImageCache.class, (String)"reports/report.ico").createImage();

    GeneratedReportsLabelProvider() {
    }

    private static boolean isExternalLink(String url) {
        return url != null && url.startsWith("https://") | url.startsWith("http://");
    }

    public Color getForeground(Object element) {
        Color defaultColor = null;
        Report report = (Report)element;
        if (GeneratedReportsLabelProvider.isExternalLink(report.getFileUrl())) {
            return defaultColor;
        }
        if (!ReportViewer.getInstance().reportFileExists(report)) {
            return ExcentisColors.lightgrey;
        }
        return defaultColor;
    }

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        Report report = (Report)element;
        switch (columnIndex) {
            case 0: {
                result = report.getReportGeneration().getGenerationTime().toString();
                break;
            }
            case 1: {
                result = this.reportViewer.getFileFormatString(report.getFileFormat());
                break;
            }
            case 2: {
                result = GeneratedReportsLabelProvider.isExternalLink(report.getFileUrl()) ? "Excentis Cloud" : this.reportViewer.getFilenameWithoutPath(report);
            }
        }
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Image image = null;
        if (columnIndex == 0) {
            image = this.reportImage;
        }
        return image;
    }
}

