/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.batch;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerCellModifier;
import com.excentis.products.byteblower.gui.views.batch.composites.BatchActionComposite;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioView;
import com.excentis.products.byteblower.model.BatchAction;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.BatchActionController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.reader.BatchActionReader;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import java.util.List;
import org.eclipse.swt.widgets.TableItem;

public class BatchActionCellModifier
extends ByteBlowerCellModifier {
    private BatchActionComposite batchActionComposite;

    public BatchActionCellModifier(BatchActionComposite composite) {
        super((ByteBlowerModelTableComposite<?>)composite);
        this.batchActionComposite = composite;
    }

    public boolean canModify(Object element, String property) {
        if (!(element instanceof BatchAction)) {
            return false;
        }
        int columnIndex = this.getColumnIndex(property);
        switch (columnIndex) {
            case 0: {
                return true;
            }
            case 1: {
                this.batchActionComposite.updateScenarioCombo();
                return true;
            }
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.getTableComposite().getColumnIndex(property);
        BatchAction batchAction = (BatchAction)element;
        BatchActionReader reader = ReaderFactory.create((BatchAction)batchAction);
        switch (columnIndex) {
            case 0: {
                return reader.getStartTime();
            }
            case 1: {
                ScenarioReader scenarioReader = reader.getScenarioReader();
                return scenarioReader.objectIsNull() ? 0 : scenarioReader.getIndexInContainer() + 1;
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        int columnIndex = this.getColumnIndex(property);
        Object itemData = null;
        if (element instanceof TableItem) {
            TableItem tableItem = (TableItem)element;
            itemData = tableItem.getData();
        }
        if (itemData instanceof BatchAction) {
            BatchAction batchAction = (BatchAction)itemData;
            UndoableByteBlowerControllerOperation operation = null;
            switch (columnIndex) {
                case 0: {
                    if (value instanceof HighResolutionCalendar) {
                        BatchActionController batchActionController = ControllerFactory.create((BatchAction)batchAction);
                        operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change Batch Action Start Time", batchActionController.setStartTime((HighResolutionCalendar)value));
                        break;
                    }
                }
                case 1: {
                    if (!(value instanceof Integer)) break;
                    ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
                    int index = (Integer)value;
                    if (index == -1) break;
                    BatchActionController batchActionController = new BatchActionController(batchAction);
                    if (this.batchActionComposite.isNewScenario(index)) {
                        operation = this.newScenarioOperation(project, batchActionController);
                        break;
                    }
                    Scenario newScenario = this.batchActionComposite.getScenario(index);
                    if (newScenario == null) break;
                    operation = new UndoableByteBlowerControllerOperation(project, "Change Batch Action Scenario", batchActionController.setScenario(newScenario));
                    break;
                }
            }
            if (operation != null) {
                operation.run();
            }
        }
    }

    private UndoableByteBlowerOperation newScenarioOperation(ByteBlowerProject project, BatchActionController controller) {
        ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
        ByteBlowerProjectController.CommandWithScenarioListReference scenarioCreation = projectController.addPopulatedScenario();
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        compoundController.appendCommand(scenarioCreation.getCommand());
        final Scenario freshScenario = (Scenario)((ScenarioController)((List)scenarioCreation.getCommandReference()).get(0)).getObject();
        compoundController.appendCommand(controller.setScenario(freshScenario));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(project, "New Scenario", compoundController.unwrap());
        operation.addAfterOperationListener(new IAfterOperationListener(){

            public void afterOperation(UndoableByteBlowerOperation operation) {
                ScenarioView.showAndSelect(freshScenario);
            }
        });
        return operation;
    }
}

