/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.dhcp;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.EnumeratorCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.IntegerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpCellModifier;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpComparator;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpTimeoutCellEditor;
import com.excentis.products.byteblower.gui.views.dhcp.actions.CopyDhcp;
import com.excentis.products.byteblower.gui.views.dhcp.actions.CutDhcp;
import com.excentis.products.byteblower.gui.views.dhcp.actions.DeleteDhcp;
import com.excentis.products.byteblower.gui.views.dhcp.actions.NewDhcp;
import com.excentis.products.byteblower.gui.views.dhcp.actions.PasteDhcp;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.RetransmissionPolicy;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

class DhcpComposite
extends ByteBlowerAmountTableComposite<Dhcp> {
    private static final String[] columnNames = new String[]{"Name", "Initial Discover/Solicit Timeout", "Maximum Discover/Solicit Retries", "Initial Request Timeout", "Maximum Request Retries", "Retransmission Policy"};
    private static final int[] columnWeights = new int[]{1, 2, 2, 2, 2, 2};

    public DhcpComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "DhcpComposite", actionInterface, focusDispatcher);
        this.initializeChildClass();
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[columnNames.length];
        editors[0] = new NameCellEditor((Composite)table);
        editors[2] = new IntegerCellEditor((Composite)table, new Integer("999999"));
        editors[1] = new DhcpTimeoutCellEditor((Composite)table);
        editors[4] = new IntegerCellEditor((Composite)table, new Integer("999999"));
        editors[3] = new DhcpTimeoutCellEditor((Composite)table);
        EnumeratorCellEditor policyEditor = new EnumeratorCellEditor((Composite)table, 8);
        policyEditor.setItems(RetransmissionPolicy.VALUES);
        editors[5] = policyEditor;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new DhcpCellModifier(this);
    }

    protected int[] getColumnWeights() {
        return columnWeights;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Dhcp.class;
    }

    protected String getTableLabel() {
        return "Dhcp Configurations for ByteBlower Ports:";
    }

    protected String[] getColumnNames() {
        return columnNames;
    }

    public boolean isCopyDownEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                return true;
            }
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
            case 5: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        return false;
    }

    public boolean isJumpEnabled() {
        return false;
    }

    public void doJump() {
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    public int getChildFeatureId() {
        return 17;
    }

    protected ByteBlowerNewAction<Dhcp> createNewAction() {
        return new NewDhcp(this);
    }

    protected ByteBlowerCutAction<Dhcp> createCutAction() {
        return new CutDhcp((ByteBlowerModelTableComposite<Dhcp>)this);
    }

    protected ByteBlowerCopyAction<Dhcp> createCopyAction() {
        return new CopyDhcp(this);
    }

    protected ByteBlowerPasteAction<Dhcp> createPasteAction() {
        return new PasteDhcp(this);
    }

    protected ByteBlowerDeleteAction<Dhcp> createDeleteAction() {
        return new DeleteDhcp(this);
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new DhcpComparator(columnViewer);
    }
}

