/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.flow;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.listeners.SimpleSelectionListener;
import com.excentis.products.byteblower.gui.views.UnFocusComboEditor;
import com.excentis.products.byteblower.gui.views.flow.FlowTableComposite;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyDescription;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyMulticastDescription;
import com.excentis.products.byteblower.gui.views.flow.UserFriendlyPortDescription;
import com.excentis.products.byteblower.gui.widgets.dialogs.FlowDestinationDialog;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.util.ProjectSwitchNotifier;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

class FlowDestinationEditor
extends UnFocusComboEditor {
    private final List<UserFriendlyDescription> destinations;
    private final Composite sourceWidgeet;
    private final FlowTableComposite flowTable;

    public FlowDestinationEditor(Composite composite, FlowTableComposite flowTableComposite) {
        super(composite, new String[0], 0);
        this.sourceWidgeet = composite;
        this.flowTable = flowTableComposite;
        this.setActivationStyle(1);
        this.addParentSelectionListener((SelectionListener)new SimpleSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Object value = FlowDestinationEditor.this.getValue();
                if (value instanceof UserFriendlyDescription && ((UserFriendlyDescription)value).isCreation()) {
                    FlowDestinationEditor.this.focusLost();
                }
            }
        });
        this.destinations = new ArrayList<UserFriendlyDescription>();
        this.populateDestinations();
    }

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        return control;
    }

    private void populateDestinations() {
        ProjectSwitchNotifier projectNotifier = ProjectSwitchNotifier.getInstance();
        ByteBlowerProject currentProject = projectNotifier.getCurrentProject();
        this.destinations.clear();
        Flow currentFlow = (Flow)this.flowTable.getFirstSelectedObject();
        if (currentProject != null) {
            EList configPorts = currentProject.getByteBlowerGuiPort();
            for (ByteBlowerGuiPort port : configPorts) {
                this.destinations.add(new UserFriendlyPortDescription(port));
            }
            this.destinations.add(new UserFriendlyPortDescription.PortIPv4Create());
            this.destinations.add(new UserFriendlyPortDescription.PortIPv6Create());
            for (final ByteBlowerPortGroup group : currentProject.getPortGroup()) {
                this.destinations.add(new UserFriendlyDescription(){

                    @Override
                    public boolean isCreation() {
                        return false;
                    }

                    @Override
                    public EByteBlowerObject get() {
                        return group;
                    }

                    @Override
                    public String toString() {
                        return group.getName();
                    }
                });
            }
            if (currentFlow == null || !(currentFlow.getFlowTemplate() instanceof TcpFlow)) {
                EList configGroups = currentProject.getMulticastGroup();
                for (MulticastGroup group : configGroups) {
                    this.destinations.add(new UserFriendlyMulticastDescription(group));
                }
                this.destinations.add(new UserFriendlyMulticastDescription.MulticastCreate());
                this.destinations.add(new DestinationDialog(this.sourceWidgeet, this.flowTable, 3, "Broadcast..."));
                this.destinations.add(new DestinationDialog(this.sourceWidgeet, this.flowTable, 4, "Unicast..."));
            }
        }
        if (this.destinations.isEmpty()) {
            this.destinations.add(UserFriendlyPortDescription.empty());
        }
    }

    protected Object doGetValue() {
        Object superValue = super.doGetValue();
        int index = (Integer)superValue;
        if (index >= 0 && index < this.destinations.size()) {
            UserFriendlyDescription desc = this.destinations.get(index);
            if (desc.isCreation()) {
                return desc;
            }
            return desc.get();
        }
        return null;
    }

    protected void doSetValue(Object value) {
        this.populateDestinations();
        String[] names = new String[this.destinations.size()];
        int ctr = 0;
        while (ctr < names.length) {
            names[ctr] = this.destinations.get(ctr).toString();
            ++ctr;
        }
        this.setItems(names);
    }

    private static class DestinationDialog
    implements UserFriendlyDescription {
        private final FlowTableComposite table;
        private final int selectedType;
        private boolean notLaunched = true;
        private final String userText;
        private EByteBlowerObject selection = null;

        public DestinationDialog(Composite compo, FlowTableComposite table, int radioType, String description) {
            this.table = table;
            this.selectedType = radioType;
            this.userText = description;
        }

        @Override
        public EByteBlowerObject get() {
            if (this.notLaunched) {
                this.notLaunched = false;
                Flow flow = (Flow)this.table.getFirstSelectedObject();
                FlowDestinationDialog dialog = new FlowDestinationDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), flow);
                dialog.overrideSelection(this.selectedType);
                int returnCode = dialog.open();
                if (returnCode != 0) {
                    return null;
                }
                FlowController flowController = ControllerFactory.create((Flow)flow);
                FlowDestinationDialog.DestinationInfo info = dialog.getDestinationInfo();
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation(ByteBlowerGuiResourceController.getProject(), "Change Flow Destination");
                switch (info.getType()) {
                    case 1: 
                    case 2: {
                        this.selection = (AddressableDestination)info.getValue();
                        break;
                    }
                    case 3: {
                        String address = (String)info.getValue();
                        operation.appendCommand(flowController.createSetBroadcastDestinationCommand(address));
                        operation.run();
                        break;
                    }
                    case 4: {
                        String address = (String)info.getValue();
                        operation.appendCommand(flowController.createSetUnicastDestinationCommand(address));
                        operation.run();
                    }
                }
            }
            return this.selection;
        }

        @Override
        public String toString() {
            return this.userText;
        }

        @Override
        public boolean isCreation() {
            return false;
        }
    }
}

