/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frame.Layer3_ArpComposite;
import com.excentis.products.byteblower.gui.views.frame.Layer3_Ipv4Composite;
import com.excentis.products.byteblower.gui.views.frame.Layer3_Ipv6Composite;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.utils.Utils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class Layer3Composite
extends FrameComposite {
    public static final String[] L3Types = new String[]{Messages.getString("FrameView.L3.Type.ARP"), Messages.getString("FrameView.L3.Type.Ipv4"), Messages.getString("FrameView.L3.Type.Ipv6")};
    private boolean isInitialized = false;
    private ScrolledComposite l3ScrolledComposite;
    private Composite l3ErrorComposite;
    private Label errorL3;
    private Label lblL3Type;
    private Layer3_Ipv4Composite ipv4Composite;
    private Layer3_Ipv6Composite ipv6Composite;
    private Layer3_ArpComposite arpComposite;

    public Layer3Composite(Composite parent, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.lblL3Type = new Label((Composite)this, 0);
        this.lblL3Type.setLayoutData((Object)new GridData(768));
        new Button((Composite)this, 0).setVisible(false);
        this.l3ScrolledComposite = new ScrolledComposite((Composite)this, 2816);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.l3ScrolledComposite.setLayoutData((Object)gridData);
        this.createL3ErrorComposite();
        this.ipv4Composite = new Layer3_Ipv4Composite((Composite)this.l3ScrolledComposite, 0, this.frameView);
        this.ipv6Composite = new Layer3_Ipv6Composite((Composite)this.l3ScrolledComposite, 0, this.frameView);
        this.arpComposite = new Layer3_ArpComposite((Composite)this.l3ScrolledComposite, 0, this.frameView);
        this.l3ScrolledComposite.setExpandHorizontal(true);
        this.l3ScrolledComposite.setExpandVertical(true);
        this.layout();
    }

    private void createL3ErrorComposite() {
        this.l3ErrorComposite = new Composite((Composite)this.l3ScrolledComposite, 0);
        this.l3ErrorComposite.setLayoutData((Object)new GridData(1808));
        this.l3ErrorComposite.setLayout((Layout)new GridLayout());
        this.errorL3 = new Label(this.l3ErrorComposite, 0);
        this.errorL3.setLayoutData((Object)new GridData(768));
    }

    public void updateL3() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        boolean enable = (frame = this.frameView.getFrame()) != null;
        this.lblL3Type.setVisible(enable);
        this.l3ScrolledComposite.setVisible(enable);
        if (enable) {
            FrameController controller = this.getFrameController();
            EthernetPacket ethernet = controller.getEthernet();
            if (ethernet.isInvalid()) {
                int bitsize = frame.getBytesHexString().length() * 4;
                if (bitsize < 480) {
                    this.errorL3.setText(Messages.getString("FrameView.Error.L2.TooSmall"));
                } else if (bitsize > 65536) {
                    this.errorL3.setText(Messages.getString("FrameView.Error.L2.TooBig"));
                }
            } else {
                int type = ethernet.getType();
                Control currentContent = this.l3ScrolledComposite.getContent();
                switch (type) {
                    case 2048: {
                        this.lblL3Type.setText("IPv4");
                        this.ipv4Composite.updateL3_Ipv4Settings();
                        if (currentContent == this.ipv4Composite) break;
                        this.setContent(this.ipv4Composite);
                        break;
                    }
                    case 2054: {
                        this.lblL3Type.setText("ARP");
                        this.arpComposite.updateL3_ArpSettings();
                        if (currentContent == this.arpComposite) break;
                        this.setContent(this.arpComposite);
                        break;
                    }
                    case 34525: {
                        this.lblL3Type.setText("IPv6");
                        this.ipv6Composite.updateL3_Ipv6Settings();
                        if (currentContent == this.ipv6Composite) break;
                        this.setContent(this.ipv6Composite);
                        break;
                    }
                    default: {
                        this.lblL3Type.setText("Type " + Utils.int2HexString((int)type));
                        this.errorL3.setText("No editor for this type.");
                        if (currentContent == this.l3ErrorComposite) break;
                        this.setContent(this.l3ErrorComposite);
                    }
                }
            }
        }
    }

    private void setContent(Composite composite) {
        Point pt = composite.computeSize(-1, -1);
        this.l3ScrolledComposite.setMinWidth(pt.x);
        this.l3ScrolledComposite.setMinHeight(pt.y);
        this.l3ScrolledComposite.setContent((Control)composite);
        this.l3ScrolledComposite.pack();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!Layer3Composite.this.l3ScrolledComposite.isDisposed() && !Layer3Composite.this.isDisposed()) {
                    Layer3Composite.this.layout();
                    Layer3Composite.this.l3ScrolledComposite.layout();
                }
            }
        });
    }

    @Override
    public void widgetSelected(SelectionEvent e) {
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void modifyText(ModifyEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    Command handleControlEvent(Control control) {
        return null;
    }
}

