/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.ARPPacket;
import com.excentis.products.byteblower.gui.swt.widgets.text.HexTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv4AddressTextFactory_ForByteBlowerGuiPort;
import com.excentis.products.byteblower.gui.swt.widgets.text.MacAddressTextFactory;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.MacAddressController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class Layer3_ArpComposite
extends FrameComposite {
    private static final int L3_ARP_HARDWARETYPE_ETHERNET_INDEX = 0;
    private final String[] ArpHardwareTypes = new String[]{Messages.getString("FrameView.L3.Arp.HardwareType.Ethernet")};
    private static final int L3_ARP_PROTOCOLTYPE_IPV4_INDEX = 0;
    private final String[] ArpProtocolTypes = new String[]{Messages.getString("FrameView.L3.Arp.ProtocolType.Ipv4")};
    private static final int L3_ARP_OPERATION_REQUEST_INDEX = 0;
    private static final int L3_ARP_OPERATION_REPLY_INDEX = 1;
    private final String[] ArpOperationTypes = new String[]{Messages.getString("FrameView.L3.Arp.Operation.Request"), Messages.getString("FrameView.L3.Arp.Operation.Reply")};
    private static final int L3_ARP_HARD_LEN_ETHERNET_INDEX = 0;
    private final String[] ArpHardLengths = new String[]{Messages.getString("FrameView.L3.Arp.HardLen.Ethernet")};
    private static final int L3_ARP_PROT_LEN_IPV4_INDEX = 0;
    private final String[] ArpProtLengths = new String[]{Messages.getString("FrameView.L3.Arp.ProtLen.Ipv4")};
    private Label lblArpHardwareType;
    private Composite compArpHT;
    private Button radioArpHTPredef;
    private Combo cmbArpHTPredef;
    private Button radioArpHTManual;
    private Text txtArpHTManual;
    private Label lblArpProt;
    private Composite compArpProt;
    private Button radioArpProtPredef;
    private Combo cmbArpProtPredef;
    private Button radioArpProtManual;
    private Text txtArpProtManual;
    private Label lblArpHardLen;
    private Button radioArpHardLenPredef;
    private Button radioArpHardLenManual;
    private Combo cmbArpHardLenPredef;
    private Text txtArpHardLen;
    private Button radioArpProtLenPredef;
    private Combo cmbArpProtLenPredef;
    private Button radioArpProtLenManual;
    private Label lblArpProtLen;
    private Text txtArpProtLen;
    private Label lblArpOp;
    private Composite compArpOp;
    private Button radioArpOpPredef;
    private Combo cmbArpOpPredef;
    private Button radioArpOpManual;
    private Text txtArpOpManual;
    private Label lblArpSHA;
    private Composite compArpSHA;
    private Button radioArpSHAAutomatic;
    private Button radioArpSHAManual;
    private Text txtArpSHA;
    private Label lblArpSPA;
    private Composite compArpSPA;
    private Button radioArpSPAAutomatic;
    private Button radioArpSPAManual;
    private Text txtArpSPA;
    private Label lblArpTHA;
    private Composite compArpTHA;
    private Button radioArpTHAAutomatic;
    private Button radioArpTHAManual;
    private Text txtArpTHA;
    private Label lblArpTPA;
    private Composite compArpTPA;
    private Button radioArpTPAAutomatic;
    private Button radioArpTPAManual;
    private Text txtArpTPA;

    public Layer3_ArpComposite(Composite parent, int style, FrameView frameView) {
        super(parent, frameView);
    }

    private Command comboArpHardwareTypeChanged(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                String type = Integer.toHexString(1).toUpperCase();
                int inttype = Integer.valueOf(type, 16);
                return this.getFrameController().setArpHardType(inttype);
            }
        }
        return null;
    }

    private Command comboArpProtocolTypeChanged(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                String type = Integer.toHexString(2048).toUpperCase();
                int inttype = Integer.valueOf(type, 16);
                return this.getFrameController().setArpProType(inttype);
            }
        }
        return null;
    }

    private Command comboArpHardwareLengthChanged(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                String type = Integer.toHexString(6).toUpperCase();
                int inttype = Integer.valueOf(type, 16);
                return this.getFrameController().setArpHardLen(inttype);
            }
        }
        return null;
    }

    private Command comboArpProtocolLengthChanged(int selectedIndex) {
        switch (selectedIndex) {
            case 0: {
                String type = Integer.toHexString(4).toUpperCase();
                int inttype = Integer.valueOf(type, 16);
                return this.getFrameController().setArpProLen(inttype);
            }
        }
        return null;
    }

    private Command comboArpOperationChanged(int selectedIndex) {
        String operation = "";
        switch (selectedIndex) {
            case 0: {
                operation = Integer.toHexString(1).toUpperCase();
                int inttype = Integer.valueOf(operation, 16);
                return this.getFrameController().setArpOperation(inttype);
            }
            case 1: {
                operation = Integer.toHexString(2).toUpperCase();
                int inttype = Integer.valueOf(operation, 16);
                return this.getFrameController().setArpOperation(inttype);
            }
        }
        return null;
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.lblArpHardwareType = new Label(composite, 0);
        this.lblArpHardwareType.setText(Messages.getString("FrameView.L3.Arp.HardwareType"));
        this.compArpHT = new Composite(composite, 2048);
        this.compArpHT.setLayoutData((Object)new GridData(768));
        this.compArpHT.setLayout((Layout)new GridLayout(2, false));
        this.radioArpHTPredef = new Button(this.compArpHT, 16);
        this.radioArpHTPredef.addMouseListener((MouseListener)this);
        this.radioArpHTPredef.setText(Messages.getString("FrameView.L3.Arp.Predef"));
        this.cmbArpHTPredef = new Combo(this.compArpHT, 8);
        int i = 0;
        while (i < this.ArpHardwareTypes.length) {
            this.cmbArpHTPredef.add(this.ArpHardwareTypes[i]);
            ++i;
        }
        this.cmbArpHTPredef.addSelectionListener((SelectionListener)this);
        this.cmbArpHTPredef.select(0);
        this.cmbArpHTPredef.setLayoutData((Object)new GridData(768));
        this.radioArpHTManual = new Button(this.compArpHT, 16);
        this.radioArpHTManual.addMouseListener((MouseListener)this);
        this.radioArpHTManual.setText(Messages.getString("FrameView.L3.Arp.Manual"));
        this.txtArpHTManual = HexTextFactory.create((Composite)this.compArpHT, (int)2048, (int)4);
        this.txtArpHTManual.setLayoutData((Object)new GridData(768));
        this.txtArpHTManual.setEnabled(false);
        this.txtArpHTManual.addModifyListener((ModifyListener)this);
        this.txtArpHTManual.addFocusListener((FocusListener)this);
        this.lblArpProt = new Label(composite, 0);
        this.lblArpProt.setText(Messages.getString("FrameView.L3.Arp.ProtocolType"));
        this.compArpProt = new Composite(composite, 2048);
        this.compArpProt.setLayoutData((Object)new GridData(768));
        this.compArpProt.setLayout((Layout)new GridLayout(2, false));
        this.radioArpProtPredef = new Button(this.compArpProt, 16);
        this.radioArpProtPredef.setText(Messages.getString("FrameView.L3.Arp.Predef"));
        this.radioArpProtPredef.addMouseListener((MouseListener)this);
        this.cmbArpProtPredef = new Combo(this.compArpProt, 8);
        i = 0;
        while (i < this.ArpProtocolTypes.length) {
            this.cmbArpProtPredef.add(this.ArpProtocolTypes[i]);
            ++i;
        }
        this.cmbArpProtPredef.addSelectionListener((SelectionListener)this);
        this.cmbArpProtPredef.select(0);
        this.cmbArpProtPredef.setLayoutData((Object)new GridData(768));
        this.radioArpProtManual = new Button(this.compArpProt, 16);
        this.radioArpProtManual.addMouseListener((MouseListener)this);
        this.radioArpProtManual.setText(Messages.getString("FrameView.L3.Arp.Manual"));
        this.txtArpProtManual = HexTextFactory.create((Composite)this.compArpProt, (int)2048, (int)4);
        this.txtArpProtManual.setLayoutData((Object)new GridData(768));
        this.txtArpProtManual.addModifyListener((ModifyListener)this);
        this.txtArpProtManual.addFocusListener((FocusListener)this);
        this.lblArpHardLen = new Label(composite, 0);
        this.lblArpHardLen.setText(Messages.getString("FrameView.L3.Arp.HLEN"));
        Composite compArpHardLen = new Composite(composite, 2048);
        compArpHardLen.setLayoutData((Object)new GridData(768));
        compArpHardLen.setLayout((Layout)new GridLayout(2, false));
        this.radioArpHardLenPredef = new Button(compArpHardLen, 16);
        this.radioArpHardLenPredef.addMouseListener((MouseListener)this);
        this.radioArpHardLenPredef.setText(Messages.getString("FrameView.L3.Arp.Predef"));
        this.cmbArpHardLenPredef = new Combo(compArpHardLen, 8);
        int i2 = 0;
        while (i2 < this.ArpHardLengths.length) {
            this.cmbArpHardLenPredef.add(this.ArpHardLengths[i2]);
            ++i2;
        }
        this.cmbArpHardLenPredef.addSelectionListener((SelectionListener)this);
        this.cmbArpHardLenPredef.select(0);
        this.cmbArpHardLenPredef.setLayoutData((Object)new GridData(768));
        this.radioArpHardLenManual = new Button(compArpHardLen, 16);
        this.radioArpHardLenManual.addMouseListener((MouseListener)this);
        this.radioArpHardLenManual.setText(Messages.getString("FrameView.L3.Arp.Manual"));
        this.txtArpHardLen = HexTextFactory.create((Composite)compArpHardLen, (int)2048, (int)2);
        this.txtArpHardLen.setLayoutData((Object)new GridData(768));
        this.txtArpHardLen.setEnabled(false);
        this.txtArpHardLen.addModifyListener((ModifyListener)this);
        this.txtArpHardLen.addFocusListener((FocusListener)this);
        this.lblArpProtLen = new Label(composite, 0);
        this.lblArpProtLen.setText(Messages.getString("FrameView.L3.Arp.PLEN"));
        Composite compArpProtLen = new Composite(composite, 2048);
        compArpProtLen.setLayoutData((Object)new GridData(768));
        compArpProtLen.setLayout((Layout)new GridLayout(2, false));
        this.radioArpProtLenPredef = new Button(compArpProtLen, 16);
        this.radioArpProtLenPredef.addMouseListener((MouseListener)this);
        this.radioArpProtLenPredef.setText(Messages.getString("FrameView.L3.Arp.Predef"));
        this.cmbArpProtLenPredef = new Combo(compArpProtLen, 8);
        int i3 = 0;
        while (i3 < this.ArpProtLengths.length) {
            this.cmbArpProtLenPredef.add(this.ArpProtLengths[i3]);
            ++i3;
        }
        this.cmbArpProtLenPredef.addSelectionListener((SelectionListener)this);
        this.cmbArpProtLenPredef.select(0);
        this.cmbArpProtLenPredef.setLayoutData((Object)new GridData(768));
        this.radioArpProtLenManual = new Button(compArpProtLen, 16);
        this.radioArpProtLenManual.addMouseListener((MouseListener)this);
        this.radioArpProtLenManual.setText(Messages.getString("FrameView.L3.Arp.Manual"));
        this.txtArpProtLen = HexTextFactory.create((Composite)compArpProtLen, (int)2048, (int)2);
        this.txtArpProtLen.setLayoutData((Object)new GridData(768));
        this.txtArpProtLen.setEnabled(false);
        this.txtArpProtLen.addModifyListener((ModifyListener)this);
        this.txtArpProtLen.addFocusListener((FocusListener)this);
        this.lblArpOp = new Label(composite, 0);
        this.lblArpOp.setText(Messages.getString("FrameView.L3.Arp.Operation"));
        this.compArpOp = new Composite(composite, 2048);
        this.compArpOp.setLayoutData((Object)new GridData(768));
        this.compArpOp.setLayout((Layout)new GridLayout(2, false));
        this.radioArpOpPredef = new Button(this.compArpOp, 16);
        this.radioArpOpPredef.setText(Messages.getString("FrameView.L3.Arp.Predef"));
        this.radioArpOpPredef.addMouseListener((MouseListener)this);
        this.cmbArpOpPredef = new Combo(this.compArpOp, 8);
        i3 = 0;
        while (i3 < this.ArpOperationTypes.length) {
            this.cmbArpOpPredef.add(this.ArpOperationTypes[i3]);
            ++i3;
        }
        this.cmbArpOpPredef.addSelectionListener((SelectionListener)this);
        this.cmbArpOpPredef.select(0);
        this.cmbArpOpPredef.setLayoutData((Object)new GridData(768));
        this.radioArpOpManual = new Button(this.compArpOp, 16);
        this.radioArpOpManual.addMouseListener((MouseListener)this);
        this.radioArpOpManual.setText(Messages.getString("FrameView.L3.Arp.Manual"));
        this.txtArpOpManual = HexTextFactory.create((Composite)this.compArpOp, (int)2048, (int)4);
        this.txtArpOpManual.setLayoutData((Object)new GridData(768));
        this.txtArpOpManual.addModifyListener((ModifyListener)this);
        this.txtArpOpManual.addFocusListener((FocusListener)this);
        this.lblArpSHA = new Label(composite, 0);
        this.lblArpSHA.setText(Messages.getString("FrameView.L3.Arp.SHA"));
        this.compArpSHA = new Composite(composite, 2048);
        this.compArpSHA.setLayoutData((Object)new GridData(768));
        this.compArpSHA.setLayout((Layout)new GridLayout(2, false));
        this.radioArpSHAAutomatic = new Button(this.compArpSHA, 16);
        this.radioArpSHAAutomatic.setText("Automatic");
        this.radioArpSHAAutomatic.addMouseListener((MouseListener)this);
        new Label(this.compArpSHA, 0);
        this.radioArpSHAManual = new Button(this.compArpSHA, 16);
        this.radioArpSHAManual.setText("Manual:");
        this.radioArpSHAManual.addMouseListener((MouseListener)this);
        this.txtArpSHA = MacAddressTextFactory.instance().create(this.compArpSHA, 2048);
        this.txtArpSHA.setLayoutData((Object)new GridData(768));
        this.txtArpSHA.addModifyListener((ModifyListener)this);
        this.txtArpSHA.addFocusListener((FocusListener)this);
        this.lblArpSPA = new Label(composite, 0);
        this.lblArpSPA.setText(Messages.getString("FrameView.L3.Arp.SPA"));
        this.compArpSPA = new Composite(composite, 2048);
        this.compArpSPA.setLayoutData((Object)new GridData(768));
        this.compArpSPA.setLayout((Layout)new GridLayout(2, false));
        this.radioArpSPAAutomatic = new Button(this.compArpSPA, 16);
        this.radioArpSPAAutomatic.setText("Automatic");
        this.radioArpSPAAutomatic.addMouseListener((MouseListener)this);
        new Label(this.compArpSPA, 0);
        this.radioArpSPAManual = new Button(this.compArpSPA, 16);
        this.radioArpSPAManual.setText("Manual:");
        this.radioArpSPAManual.addMouseListener((MouseListener)this);
        this.txtArpSPA = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create(this.compArpSPA, 2048);
        this.txtArpSPA.setLayoutData((Object)new GridData(768));
        this.txtArpSPA.addModifyListener((ModifyListener)this);
        this.txtArpSPA.addFocusListener((FocusListener)this);
        this.lblArpTHA = new Label(composite, 0);
        this.lblArpTHA.setText(Messages.getString("FrameView.L3.Arp.THA"));
        this.compArpTHA = new Composite(composite, 2048);
        this.compArpTHA.setLayoutData((Object)new GridData(768));
        this.compArpTHA.setLayout((Layout)new GridLayout(2, false));
        this.radioArpTHAAutomatic = new Button(this.compArpTHA, 16);
        this.radioArpTHAAutomatic.setText("Automatic");
        this.radioArpTHAAutomatic.addMouseListener((MouseListener)this);
        new Label(this.compArpTHA, 0);
        this.radioArpTHAManual = new Button(this.compArpTHA, 16);
        this.radioArpTHAManual.setText("Manual:");
        this.radioArpTHAManual.addMouseListener((MouseListener)this);
        this.txtArpTHA = MacAddressTextFactory.instance().create(this.compArpTHA, 2048);
        this.txtArpTHA.setLayoutData((Object)new GridData(768));
        this.txtArpTHA.addModifyListener((ModifyListener)this);
        this.txtArpTHA.addFocusListener((FocusListener)this);
        this.lblArpTPA = new Label(composite, 0);
        this.lblArpTPA.setText(Messages.getString("FrameView.L3.Arp.TPA"));
        this.compArpTPA = new Composite(composite, 2048);
        this.compArpTPA.setLayoutData((Object)new GridData(768));
        this.compArpTPA.setLayout((Layout)new GridLayout(2, false));
        this.radioArpTPAAutomatic = new Button(this.compArpTPA, 16);
        this.radioArpTPAAutomatic.setText("Automatic");
        this.radioArpTPAAutomatic.addMouseListener((MouseListener)this);
        new Label(this.compArpTPA, 0);
        this.radioArpTPAManual = new Button(this.compArpTPA, 16);
        this.radioArpTPAManual.setText("Manual:");
        this.radioArpTPAManual.addMouseListener((MouseListener)this);
        this.txtArpTPA = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create(this.compArpTPA, 2048);
        this.txtArpTPA.setLayoutData((Object)new GridData(768));
        this.txtArpTPA.addModifyListener((ModifyListener)this);
        this.txtArpTPA.addFocusListener((FocusListener)this);
        this.layout();
    }

    private void updateL3_ArpHT() {
        ARPPacket arp = this.getArpPacket();
        int type = arp.getHardType();
        boolean predef = true;
        switch (type) {
            case 1: {
                predef = true;
                this.cmbArpHTPredef.select(0);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioArpHTPredef.setSelection(predef);
        this.cmbArpHTPredef.setEnabled(predef);
        this.radioArpHTManual.setSelection(!predef);
        this.txtArpHTManual.setEnabled(!predef);
    }

    private ARPPacket getArpPacket() {
        return this.getFrameController().getArp();
    }

    private void updateL3_ArpPT() {
        ARPPacket arp = this.getArpPacket();
        int type = arp.getProType();
        boolean predef = true;
        switch (type) {
            case 2048: {
                predef = true;
                this.cmbArpProtPredef.select(0);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioArpProtPredef.setSelection(predef);
        this.cmbArpProtPredef.setEnabled(predef);
        this.radioArpProtManual.setSelection(!predef);
        this.txtArpProtManual.setEnabled(!predef);
    }

    private void updateL3_ArpHL() {
        ARPPacket arp = this.getArpPacket();
        int type = arp.getHardLen();
        boolean predef = true;
        switch (type) {
            case 6: {
                predef = true;
                this.cmbArpHardLenPredef.select(0);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioArpHardLenPredef.setSelection(predef);
        this.cmbArpHardLenPredef.setEnabled(predef);
        this.radioArpHardLenManual.setSelection(!predef);
        this.txtArpHardLen.setEnabled(!predef);
    }

    private void updateL3_ArpPL() {
        ARPPacket arp = this.getArpPacket();
        int type = arp.getProLen();
        boolean predef = true;
        switch (type) {
            case 4: {
                predef = true;
                this.cmbArpProtPredef.select(0);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioArpProtLenPredef.setSelection(predef);
        this.cmbArpProtLenPredef.setEnabled(predef);
        this.radioArpProtLenManual.setSelection(!predef);
        this.txtArpProtLen.setEnabled(!predef);
    }

    private void updateL3_ArpOp() {
        ARPPacket arp = this.getArpPacket();
        int type = arp.getOperation();
        boolean predef = true;
        switch (type) {
            case 1: {
                predef = true;
                this.cmbArpOpPredef.select(0);
                break;
            }
            case 2: {
                predef = true;
                this.cmbArpOpPredef.select(1);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioArpOpPredef.setSelection(predef);
        this.cmbArpOpPredef.setEnabled(predef);
        this.radioArpOpManual.setSelection(!predef);
        this.txtArpOpManual.setEnabled(!predef);
    }

    private void updateL3_ArpSHA(Frame frame) {
        Boolean autoArpSHA = frame.getL3AutoArpSHA();
        boolean auto = autoArpSHA == null ? false : autoArpSHA;
        this.radioArpSHAAutomatic.setSelection(auto);
        this.radioArpSHAManual.setSelection(!auto);
        this.txtArpSHA.setEnabled(!auto);
    }

    private void updateL3_ArpTHA(Frame frame) {
        Boolean autoArpTHA = frame.getL3AutoArpTHA();
        boolean auto = autoArpTHA == null ? false : autoArpTHA;
        this.radioArpTHAAutomatic.setSelection(auto);
        this.radioArpTHAManual.setSelection(!auto);
        this.txtArpTHA.setEnabled(!auto);
    }

    private void updateL3_ArpSPA(Frame frame) {
        Boolean autoArpSPA = frame.getL3AutoArpSPA();
        boolean auto = autoArpSPA == null ? false : autoArpSPA;
        this.radioArpSPAAutomatic.setSelection(auto);
        this.radioArpSPAManual.setSelection(!auto);
        this.txtArpSPA.setEnabled(!auto);
    }

    private void updateL3_ArpTPA(Frame frame) {
        Boolean autoArpTPA = frame.getL3AutoArpTPA();
        boolean auto = autoArpTPA == null ? false : autoArpTPA;
        this.radioArpTPAAutomatic.setSelection(auto);
        this.radioArpTPAManual.setSelection(!auto);
        this.txtArpTPA.setEnabled(!auto);
    }

    public void updateL3_ArpSettings() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        if ((frame = this.frameView.getFrame()) == null) {
            return;
        }
        ARPPacket arp = this.getArpPacket();
        String hardwareType = Integer.toHexString(arp.getHardType()).toUpperCase();
        while (hardwareType.length() < 4) {
            hardwareType = "0" + hardwareType;
        }
        int caretPos = this.txtArpHTManual.getCaretPosition();
        this.txtArpHTManual.setText(hardwareType);
        this.txtArpHTManual.setSelection(caretPos, caretPos);
        this.updateL3_ArpHT();
        String protocolType = Integer.toHexString(arp.getProType()).toUpperCase();
        while (protocolType.length() < 4) {
            protocolType = "0" + protocolType;
        }
        caretPos = this.txtArpProtManual.getCaretPosition();
        this.txtArpProtManual.setText(protocolType);
        this.txtArpProtManual.setSelection(caretPos, caretPos);
        this.updateL3_ArpPT();
        String hardLen = Integer.toHexString(arp.getHardLen()).toUpperCase();
        while (hardLen.length() < 2) {
            hardLen = "0" + hardLen;
        }
        caretPos = this.txtArpHardLen.getCaretPosition();
        this.txtArpHardLen.setText(hardLen);
        this.txtArpHardLen.setSelection(caretPos, caretPos);
        this.updateL3_ArpHL();
        String protLen = Integer.toHexString(arp.getProLen()).toUpperCase();
        while (protLen.length() < 2) {
            protLen = "0" + protLen;
        }
        caretPos = this.txtArpProtLen.getCaretPosition();
        this.txtArpProtLen.setText(protLen);
        this.txtArpProtLen.setSelection(caretPos, caretPos);
        this.updateL3_ArpPL();
        String operation = Integer.toHexString(arp.getOperation()).toUpperCase();
        while (operation.length() != 4) {
            operation = "0" + operation;
        }
        caretPos = this.txtArpOpManual.getCaretPosition();
        this.txtArpOpManual.setText(operation);
        this.txtArpOpManual.setSelection(caretPos, caretPos);
        this.updateL3_ArpOp();
        caretPos = this.txtArpSHA.getCaretPosition();
        this.txtArpSHA.setText(arp.getSHA());
        this.txtArpSHA.setSelection(caretPos, caretPos);
        this.updateL3_ArpSHA(frame);
        caretPos = this.txtArpSPA.getCaretPosition();
        this.txtArpSPA.setText(arp.getSPA());
        this.txtArpSPA.setSelection(caretPos, caretPos);
        this.updateL3_ArpSPA(frame);
        caretPos = this.txtArpTHA.getCaretPosition();
        this.txtArpTHA.setText(arp.getTHA());
        this.txtArpTHA.setSelection(caretPos, caretPos);
        this.updateL3_ArpTHA(frame);
        caretPos = this.txtArpTPA.getCaretPosition();
        this.txtArpTPA.setText(arp.getTPA());
        this.txtArpTPA.setSelection(caretPos, caretPos);
        this.updateL3_ArpTPA(frame);
    }

    public void modifyText(ModifyEvent e) {
        String tpa;
        Control control = (Control)e.widget;
        if (!control.isFocusControl() || this.frameView.isUpdating()) {
            return;
        }
        Command command = null;
        if (control == this.txtArpHTManual) {
            if (HexTextFactory.checkComplete((Text)this.txtArpHTManual)) {
                String type = this.txtArpHTManual.getText();
                int inttype = Integer.valueOf(type, 16);
                command = this.getFrameController().setArpHardType(inttype);
            }
        } else if (control == this.txtArpProtManual) {
            if (HexTextFactory.checkComplete((Text)this.txtArpProtManual)) {
                String type = this.txtArpProtManual.getText();
                int inttype = Integer.valueOf(type, 16);
                command = this.getFrameController().setArpProType(inttype);
            }
        } else if (control == this.txtArpHardLen) {
            if (HexTextFactory.checkComplete((Text)this.txtArpHardLen)) {
                String type = this.txtArpHardLen.getText();
                int inttype = Integer.valueOf(type, 16);
                command = this.getFrameController().setArpHardLen(inttype);
            }
        } else if (control == this.txtArpProtLen) {
            if (HexTextFactory.checkComplete((Text)this.txtArpProtLen)) {
                String type = this.txtArpProtLen.getText();
                int inttype = Integer.valueOf(type, 16);
                command = this.getFrameController().setArpProLen(inttype);
            }
        } else if (control == this.txtArpOpManual) {
            if (HexTextFactory.checkComplete((Text)this.txtArpOpManual)) {
                String operation = this.txtArpOpManual.getText();
                int inttype = Integer.valueOf(operation, 16);
                command = this.getFrameController().setArpOperation(inttype);
            }
        } else if (control == this.txtArpSHA) {
            String sha = this.txtArpSHA.getText();
            if (MacAddressController.isComplete((String)sha)) {
                command = this.getFrameController().setArpSHA(sha);
            }
        } else if (control == this.txtArpTHA) {
            String tha = this.txtArpTHA.getText();
            if (MacAddressController.isComplete((String)tha)) {
                command = this.getFrameController().setArpTHA(tha);
            }
        } else if (control == this.txtArpSPA) {
            String spa = this.txtArpSPA.getText();
            if (Ipv4AddressController.isValid((String)spa)) {
                command = this.getFrameController().setArpSPA(spa);
            }
        } else if (control == this.txtArpTPA && Ipv4AddressController.isValid((String)(tpa = this.txtArpTPA.getText()))) {
            command = this.getFrameController().setArpTPA(tpa);
        }
        this.frameView.executeCommand(command);
    }

    @Override
    Command handleControlEvent(Control control) {
        Command command = null;
        if (control == this.radioArpHTPredef) {
            this.cmbArpHTPredef.setEnabled(true);
            this.txtArpHTManual.setEnabled(false);
            command = this.comboArpHardwareTypeChanged(this.cmbArpHTPredef.getSelectionIndex());
        } else if (control == this.radioArpHTManual) {
            this.cmbArpHTPredef.setEnabled(false);
            this.txtArpHTManual.setEnabled(true);
        } else if (control == this.cmbArpHTPredef) {
            command = this.comboArpHardwareTypeChanged(this.cmbArpHTPredef.getSelectionIndex());
        } else if (control == this.radioArpProtPredef) {
            this.cmbArpProtPredef.setEnabled(true);
            this.txtArpProtManual.setEnabled(false);
            command = this.comboArpProtocolTypeChanged(this.cmbArpProtPredef.getSelectionIndex());
        } else if (control == this.radioArpProtManual) {
            this.cmbArpProtPredef.setEnabled(false);
            this.txtArpProtManual.setEnabled(true);
        } else if (control == this.cmbArpProtPredef) {
            command = this.comboArpProtocolTypeChanged(this.cmbArpProtPredef.getSelectionIndex());
        } else if (control == this.radioArpHardLenPredef) {
            this.cmbArpHardLenPredef.setEnabled(true);
            this.txtArpHardLen.setEnabled(false);
            command = this.comboArpHardwareLengthChanged(this.cmbArpHardLenPredef.getSelectionIndex());
        } else if (control == this.radioArpHardLenManual) {
            this.cmbArpHardLenPredef.setEnabled(false);
            this.txtArpHardLen.setEnabled(true);
        } else if (control == this.cmbArpHardLenPredef) {
            command = this.comboArpHardwareLengthChanged(this.cmbArpHardLenPredef.getSelectionIndex());
        } else if (control == this.radioArpProtLenPredef) {
            this.cmbArpProtLenPredef.setEnabled(true);
            this.txtArpProtLen.setEnabled(false);
            command = this.comboArpProtocolLengthChanged(this.cmbArpProtLenPredef.getSelectionIndex());
        } else if (control == this.radioArpProtLenManual) {
            this.cmbArpProtLenPredef.setEnabled(false);
            this.txtArpProtLen.setEnabled(true);
        } else if (control == this.cmbArpProtLenPredef) {
            command = this.comboArpProtocolLengthChanged(this.cmbArpProtLenPredef.getSelectionIndex());
        } else if (control == this.radioArpOpPredef) {
            this.cmbArpOpPredef.setEnabled(true);
            this.txtArpOpManual.setEnabled(false);
            command = this.comboArpOperationChanged(this.cmbArpOpPredef.getSelectionIndex());
        } else if (control == this.radioArpOpManual) {
            this.cmbArpOpPredef.setEnabled(false);
            this.txtArpOpManual.setEnabled(true);
        } else if (control == this.cmbArpOpPredef) {
            command = this.comboArpOperationChanged(this.cmbArpOpPredef.getSelectionIndex());
        } else if (control == this.radioArpSHAAutomatic) {
            command = this.getFrameController().setL3AutoArpSHA(Boolean.TRUE);
        } else if (control == this.radioArpSHAManual) {
            command = this.getFrameController().setL3AutoArpSHA(Boolean.FALSE);
        } else if (control == this.radioArpSPAAutomatic) {
            command = this.getFrameController().setL3AutoArpSPA(Boolean.TRUE);
        } else if (control == this.radioArpSPAManual) {
            command = this.getFrameController().setL3AutoArpSPA(Boolean.FALSE);
        } else if (control == this.radioArpTHAAutomatic) {
            command = this.getFrameController().setL3AutoArpTHA(Boolean.TRUE);
        } else if (control == this.radioArpTHAManual) {
            command = this.getFrameController().setL3AutoArpTHA(Boolean.FALSE);
        } else if (control == this.radioArpTPAAutomatic) {
            command = this.getFrameController().setL3AutoArpTPA(Boolean.TRUE);
        } else if (control == this.radioArpTPAManual) {
            command = this.getFrameController().setL3AutoArpTPA(Boolean.FALSE);
        }
        return command;
    }

    public void focusLost(FocusEvent e) {
    }
}

