/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.Ipv4Packet;
import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.swt.widgets.text.HexTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv4AddressTextFactory_ForByteBlowerGuiPort;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameL3TosType;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class Layer3_Ipv4Composite
extends FrameComposite {
    private static final int L3_Ipv4_TOS_INDEX = 0;
    private static final int L3_Ipv4_DIFFSERV_INDEX = 1;
    private static final int L3_Ipv4_WME_INDEX = 2;
    private static final int L3_Ipv4_NONE_INDEX = 3;
    private static final int L4_TCP_INDEX = 0;
    private static final int L4_UDP_INDEX = 1;
    private final String[] L3TOSTypes = new String[]{Messages.getString("FrameView.L3.Ip.TOS.TOS"), Messages.getString("FrameView.L3.Ip.TOS.DiffServ"), Messages.getString("FrameView.L3.Ip.TOS.WME"), Messages.getString("FrameView.L3.Ip.TOS.None")};
    private final String[] L4Types = new String[]{Messages.getString("FrameView.L4.Type.Tcp"), Messages.getString("FrameView.L4.Type.Udp")};
    private Label lblL3VER;
    private Text txtL3Ver;
    private Label lblL3HLEN;
    private Label lblL3TotLen;
    private Composite compL3TotLen;
    private Button radioL3TotLenAuto;
    private Button radioL3TotLenManual;
    private Text txtL3TotLen;
    private Label lblL3TOS;
    private Label lblL3TOSMeaning;
    private Composite compL3Tos;
    private Combo comboL3TOSMeaning;
    private Combo comboL3TOSPreselect;
    private Button checkTosFlag0;
    private Button checkTosFlag1;
    private Button checkTosFlag2;
    private Button checkTosFlag3;
    private Button checkTosFlag4;
    private Button checkTosFlag5;
    private Button checkTosFlag6;
    private Button checkTosFlag7;
    private Label lblL3Id;
    private Text txtL3Id;
    private Label lblL3Flags;
    private Label lblL3Frag;
    private Text txtL3Frag;
    private Label lblL3TTL;
    private Text txtL3TTL;
    private Label lblL3Prot;
    private Composite compL3Prot;
    private Button radioL3ProtPredef;
    private Combo cmbL3ProtPredef;
    private Button radioL3ProtManual;
    private Text txtL3ProtManual;
    private Label lblL3HC;
    private Composite compL3Check;
    private Button radioL3HCAutomatic;
    private Button radioL3HCManual;
    private Text txtL3HCManual;
    private Label lblL3SA;
    private Composite compL3SourceIp;
    private Button radioL3SourceIpAutomatic;
    private Button radioL3SourceIpManual;
    private Text txtL3SourceIpManual;
    private Label lblL3DA;
    private Composite compL3DestIp;
    private Button radioL3DestIpAutomatic;
    private Button radioL3DestIpManual;
    private Text txtL3DestIpManual;
    private Composite compL3IpFlags;
    private Button checkL3IpFlagReserved;
    private Button checkL3IpFlagDNF;
    private Button checkL3IpFlagMF;
    private Text txtL3Hlen;
    private TOSPreset[] startPresets = new TOSPreset[0];
    private static Map<String, TOSPreset[]> presets = new HashMap<String, TOSPreset[]>();

    static {
        TOSPreset[] tos = new TOSPreset[]{new TOSPreset("Best Effort", 0), new TOSPreset("Priority", 8), new TOSPreset("Immediate", 16), new TOSPreset("Flash Override", 32), new TOSPreset("Critical", 40), new TOSPreset("Internetwork Control", 48), new TOSPreset("Network Control", 56)};
        presets.put("TOS", tos);
        TOSPreset[] wme = new TOSPreset[]{new TOSPreset("Voice: AC_VO", 96), new TOSPreset("Video: AC_VI", 64), new TOSPreset("Best effort: AC_BE", 0), new TOSPreset("Background: AC_BK", 32)};
        presets.put("WME", wme);
    }

    public Layer3_Ipv4Composite(Composite parent, int style, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayoutData(new GridData(1808));
        this.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.lblL3VER = new Label(composite, 0);
        this.lblL3VER.setText(Messages.getString("FrameView.L3.Ip.VER"));
        this.txtL3Ver = HexTextFactory.create((Composite)composite, (int)2048, (int)1);
        this.txtL3Ver.setLayoutData((Object)new GridData(768));
        this.txtL3Ver.addModifyListener((ModifyListener)this);
        this.txtL3Ver.addFocusListener((FocusListener)this);
        this.lblL3HLEN = new Label(composite, 0);
        this.lblL3HLEN.setText(Messages.getString("FrameView.L3.Ip.HLEN"));
        this.txtL3Hlen = HexTextFactory.create((Composite)composite, (int)2048, (int)1);
        this.txtL3Hlen.setLayoutData((Object)new GridData(768));
        this.txtL3Hlen.addModifyListener((ModifyListener)this);
        this.txtL3Hlen.addFocusListener((FocusListener)this);
        this.lblL3TOS = new Label(composite, 0);
        this.lblL3TOS.setText(Messages.getString("FrameView.L3.Ip.TOS"));
        this.compL3Tos = new Composite(composite, 2048);
        this.compL3Tos.setLayoutData((Object)new GridData(768));
        this.compL3Tos.setLayout((Layout)new GridLayout(2, false));
        this.lblL3TOSMeaning = new Label(this.compL3Tos, 0);
        this.lblL3TOSMeaning.setText(Messages.getString("FrameView.L3.IP.TosMeaning"));
        this.comboL3TOSMeaning = new Combo(this.compL3Tos, 8);
        this.comboL3TOSMeaning.setLayoutData((Object)new GridData(768));
        int i = 0;
        while (i < this.L3TOSTypes.length) {
            this.comboL3TOSMeaning.add(this.L3TOSTypes[i]);
            ++i;
        }
        this.comboL3TOSMeaning.addSelectionListener((SelectionListener)this);
        this.lblL3TOSMeaning = new Label(this.compL3Tos, 0);
        this.lblL3TOSMeaning.setText("Preselect:");
        this.comboL3TOSPreselect = new Combo(this.compL3Tos, 8);
        TOSPreset[] startPresets = presets.get("TOS");
        String[] presetNames = new String[startPresets.length];
        int ctr = 0;
        while (ctr < presetNames.length) {
            presetNames[ctr] = startPresets[ctr].name;
            ++ctr;
        }
        this.comboL3TOSPreselect.setItems(presetNames);
        this.comboL3TOSPreselect.addSelectionListener((SelectionListener)this);
        this.comboL3TOSPreselect.select(0);
        Label dummyLabel = new Label(this.compL3Tos, 0);
        dummyLabel.setVisible(false);
        Composite flagsComp = new Composite(this.compL3Tos, 0);
        flagsComp.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout(1, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        flagsComp.setLayout((Layout)layout);
        this.checkTosFlag0 = new Button(flagsComp, 32);
        this.checkTosFlag0.addSelectionListener((SelectionListener)this);
        this.checkTosFlag1 = new Button(flagsComp, 32);
        this.checkTosFlag1.addSelectionListener((SelectionListener)this);
        this.checkTosFlag2 = new Button(flagsComp, 32);
        this.checkTosFlag2.addSelectionListener((SelectionListener)this);
        this.checkTosFlag3 = new Button(flagsComp, 32);
        this.checkTosFlag3.addSelectionListener((SelectionListener)this);
        this.checkTosFlag4 = new Button(flagsComp, 32);
        this.checkTosFlag4.addSelectionListener((SelectionListener)this);
        this.checkTosFlag5 = new Button(flagsComp, 32);
        this.checkTosFlag5.addSelectionListener((SelectionListener)this);
        this.checkTosFlag6 = new Button(flagsComp, 32);
        this.checkTosFlag6.addSelectionListener((SelectionListener)this);
        this.checkTosFlag7 = new Button(flagsComp, 32);
        this.checkTosFlag7.addSelectionListener((SelectionListener)this);
        this.checkTosFlag0.setLayoutData((Object)new GridData(768));
        this.checkTosFlag1.setLayoutData((Object)new GridData(768));
        this.checkTosFlag2.setLayoutData((Object)new GridData(768));
        this.checkTosFlag3.setLayoutData((Object)new GridData(768));
        this.checkTosFlag4.setLayoutData((Object)new GridData(768));
        this.checkTosFlag5.setLayoutData((Object)new GridData(768));
        this.checkTosFlag6.setLayoutData((Object)new GridData(768));
        this.checkTosFlag7.setLayoutData((Object)new GridData(768));
        this.updateTosTexts(0);
        this.lblL3TotLen = new Label(composite, 0);
        this.lblL3TotLen.setText(Messages.getString("FrameView.L3.Ip.TotLen"));
        this.compL3TotLen = new Composite(composite, 2048);
        this.compL3TotLen.setLayoutData((Object)new GridData(768));
        this.compL3TotLen.setLayout((Layout)new GridLayout(2, false));
        this.radioL3TotLenAuto = new Button(this.compL3TotLen, 16);
        this.radioL3TotLenAuto.setText(Messages.getString("FrameView.L3.Ip.Automatic"));
        this.radioL3TotLenAuto.addMouseListener((MouseListener)this);
        Label dummyLabel2 = new Label(this.compL3TotLen, 0);
        dummyLabel2.setVisible(false);
        this.radioL3TotLenManual = new Button(this.compL3TotLen, 16);
        this.radioL3TotLenManual.setText("Manual (hex):");
        this.radioL3TotLenManual.addMouseListener((MouseListener)this);
        this.txtL3TotLen = HexTextFactory.create((Composite)this.compL3TotLen, (int)2048, (int)4);
        this.txtL3TotLen.setLayoutData((Object)new GridData(768));
        this.txtL3TotLen.setEnabled(false);
        this.txtL3TotLen.addModifyListener((ModifyListener)this);
        this.txtL3TotLen.addFocusListener((FocusListener)this);
        this.lblL3Id = new Label(composite, 0);
        this.lblL3Id.setText(Messages.getString("FrameView.L3.Ip.Id"));
        this.txtL3Id = HexTextFactory.create((Composite)composite, (int)2048, (int)4);
        this.txtL3Id.setLayoutData((Object)new GridData(768));
        this.txtL3Id.addModifyListener((ModifyListener)this);
        this.txtL3Id.addFocusListener((FocusListener)this);
        this.lblL3Flags = new Label(composite, 0);
        this.lblL3Flags.setText(Messages.getString("FrameView.L3.Ip.Flags"));
        this.compL3IpFlags = new Composite(composite, 2048);
        this.compL3IpFlags.setLayoutData((Object)new GridData(768));
        this.compL3IpFlags.setLayout((Layout)new GridLayout(1, false));
        this.checkL3IpFlagReserved = new Button(this.compL3IpFlags, 32);
        this.checkL3IpFlagReserved.setText(Messages.getString("FrameView.L3.Ip.Flag.Unused"));
        this.checkL3IpFlagReserved.addSelectionListener((SelectionListener)this);
        this.checkL3IpFlagDNF = new Button(this.compL3IpFlags, 32);
        this.checkL3IpFlagDNF.setText(Messages.getString("FrameView.L3.Ip.Flag.DNF"));
        this.checkL3IpFlagDNF.addSelectionListener((SelectionListener)this);
        this.checkL3IpFlagMF = new Button(this.compL3IpFlags, 32);
        this.checkL3IpFlagMF.setText(Messages.getString("FrameView.L3.Ip.Flag.MF"));
        this.checkL3IpFlagMF.addSelectionListener((SelectionListener)this);
        this.lblL3Frag = new Label(composite, 0);
        this.lblL3Frag.setText(Messages.getString("FrameView.L3.Ip.FragOffset"));
        this.txtL3Frag = HexTextFactory.create((Composite)composite, (int)2048, (int)4);
        this.txtL3Frag.setLayoutData((Object)new GridData(768));
        this.txtL3Frag.addModifyListener((ModifyListener)this);
        this.txtL3Frag.addFocusListener((FocusListener)this);
        this.lblL3TTL = new Label(composite, 0);
        this.lblL3TTL.setText(Messages.getString("FrameView.L3.Ip.TTL"));
        this.txtL3TTL = HexTextFactory.create((Composite)composite, (int)2048, (int)2);
        this.txtL3TTL.setLayoutData((Object)new GridData(768));
        this.txtL3TTL.addModifyListener((ModifyListener)this);
        this.txtL3TTL.addFocusListener((FocusListener)this);
        this.lblL3Prot = new Label(composite, 0);
        this.lblL3Prot.setText(Messages.getString("FrameView.L3.Ip.Protocol"));
        this.compL3Prot = new Composite(composite, 2048);
        this.compL3Prot.setLayoutData((Object)new GridData(768));
        this.compL3Prot.setLayout((Layout)new GridLayout(2, false));
        this.radioL3ProtPredef = new Button(this.compL3Prot, 16);
        this.radioL3ProtPredef.setText(Messages.getString("FrameView.L3.Ip.Predef"));
        this.radioL3ProtPredef.addMouseListener((MouseListener)this);
        this.cmbL3ProtPredef = new Combo(this.compL3Prot, 8);
        this.cmbL3ProtPredef.setLayoutData((Object)new GridData(768));
        int i2 = 0;
        while (i2 < this.L4Types.length) {
            this.cmbL3ProtPredef.add(this.L4Types[i2]);
            ++i2;
        }
        this.cmbL3ProtPredef.select(0);
        this.cmbL3ProtPredef.addSelectionListener((SelectionListener)this);
        this.radioL3ProtManual = new Button(this.compL3Prot, 16);
        this.radioL3ProtManual.addMouseListener((MouseListener)this);
        this.radioL3ProtManual.setText("Manual (hex):");
        this.txtL3ProtManual = HexTextFactory.create((Composite)this.compL3Prot, (int)2048, (int)2);
        this.txtL3ProtManual.setLayoutData((Object)new GridData(768));
        this.txtL3ProtManual.setEnabled(false);
        this.txtL3ProtManual.addModifyListener((ModifyListener)this);
        this.txtL3ProtManual.addFocusListener((FocusListener)this);
        this.lblL3HC = new Label(composite, 0);
        this.lblL3HC.setText(Messages.getString("FrameView.L3.Ip.HeaderCheck"));
        this.compL3Check = new Composite(composite, 2048);
        this.compL3Check.setLayoutData((Object)new GridData(768));
        this.compL3Check.setLayout((Layout)new GridLayout(2, false));
        this.radioL3HCAutomatic = new Button(this.compL3Check, 16);
        this.radioL3HCAutomatic.setText(Messages.getString("FrameView.L3.Ip.Automatic"));
        this.radioL3HCAutomatic.addMouseListener((MouseListener)this);
        Label dummyLabel3 = new Label(this.compL3Check, 0);
        dummyLabel3.setVisible(false);
        this.radioL3HCManual = new Button(this.compL3Check, 16);
        this.radioL3HCManual.addMouseListener((MouseListener)this);
        this.radioL3HCManual.setText("Manual (hex):");
        this.txtL3HCManual = HexTextFactory.create((Composite)this.compL3Check, (int)2048, (int)4);
        this.txtL3HCManual.setLayoutData((Object)new GridData(768));
        this.txtL3HCManual.setEnabled(false);
        this.txtL3HCManual.addModifyListener((ModifyListener)this);
        this.txtL3HCManual.addFocusListener((FocusListener)this);
        this.lblL3SA = new Label(composite, 0);
        this.lblL3SA.setText(Messages.getString("FrameView.L3.Ip.SA"));
        this.compL3SourceIp = new Composite(composite, 2048);
        this.compL3SourceIp.setLayoutData((Object)new GridData(768));
        this.compL3SourceIp.setLayout((Layout)new GridLayout(2, false));
        this.radioL3SourceIpAutomatic = new Button(this.compL3SourceIp, 16);
        this.radioL3SourceIpAutomatic.setText(Messages.getString("FrameView.L3.Ip.Automatic"));
        this.radioL3SourceIpAutomatic.addMouseListener((MouseListener)this);
        Label dummyLabel4 = new Label(this.compL3SourceIp, 0);
        dummyLabel4.setVisible(false);
        this.radioL3SourceIpManual = new Button(this.compL3SourceIp, 16);
        this.radioL3SourceIpManual.addMouseListener((MouseListener)this);
        this.radioL3SourceIpManual.setText(Messages.getString("FrameView.L3.Ip.Manual"));
        this.txtL3SourceIpManual = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create(this.compL3SourceIp, 2048);
        this.txtL3SourceIpManual.setLayoutData((Object)new GridData(768));
        this.txtL3SourceIpManual.addModifyListener((ModifyListener)this);
        this.txtL3SourceIpManual.addFocusListener((FocusListener)this);
        this.lblL3DA = new Label(composite, 0);
        this.lblL3DA.setText(Messages.getString("FrameView.L3.Ip.DA"));
        this.compL3DestIp = new Composite(composite, 2048);
        this.compL3DestIp.setLayoutData((Object)new GridData(768));
        this.compL3DestIp.setLayout((Layout)new GridLayout(2, false));
        this.radioL3DestIpAutomatic = new Button(this.compL3DestIp, 16);
        this.radioL3DestIpAutomatic.setText(Messages.getString("FrameView.L3.Ip.Automatic"));
        this.radioL3DestIpAutomatic.addMouseListener((MouseListener)this);
        Label dummyLabel5 = new Label(this.compL3DestIp, 0);
        dummyLabel5.setVisible(false);
        this.radioL3DestIpManual = new Button(this.compL3DestIp, 16);
        this.radioL3DestIpManual.addMouseListener((MouseListener)this);
        this.radioL3DestIpManual.setText(Messages.getString("FrameView.L3.Ip.Manual"));
        this.txtL3DestIpManual = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create(this.compL3DestIp, 2048);
        this.txtL3DestIpManual.setLayoutData((Object)new GridData(768));
        this.txtL3DestIpManual.addModifyListener((ModifyListener)this);
        this.txtL3DestIpManual.addFocusListener((FocusListener)this);
    }

    private void updateTosTexts(int index) {
        switch (index) {
            case 0: 
            case 2: {
                this.checkTosFlag0.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.0"));
                this.checkTosFlag1.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.1"));
                this.checkTosFlag2.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.2"));
                this.checkTosFlag3.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.3"));
                this.checkTosFlag4.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.4"));
                this.checkTosFlag5.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.5"));
                this.checkTosFlag6.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.6"));
                this.checkTosFlag7.setText(Messages.getString("FrameView.L3.Ip.TOS.TOS.7"));
                break;
            }
            case 1: {
                this.checkTosFlag0.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.0"));
                this.checkTosFlag1.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.1"));
                this.checkTosFlag2.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.2"));
                this.checkTosFlag3.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.3"));
                this.checkTosFlag4.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.4"));
                this.checkTosFlag5.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.5"));
                this.checkTosFlag6.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.6"));
                this.checkTosFlag7.setText(Messages.getString("FrameView.L3.Ip.TOS.DIFFSERV.7"));
                break;
            }
            case 3: {
                this.checkTosFlag0.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.0"));
                this.checkTosFlag1.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.1"));
                this.checkTosFlag2.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.2"));
                this.checkTosFlag3.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.3"));
                this.checkTosFlag4.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.4"));
                this.checkTosFlag5.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.5"));
                this.checkTosFlag6.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.6"));
                this.checkTosFlag7.setText(Messages.getString("FrameView.L3.Ip.TOS.NONE.7"));
                break;
            }
        }
    }

    private void updateL3HigherLevelProtocol(int protocol) {
        boolean predef = true;
        switch (protocol) {
            case 6: {
                predef = true;
                this.cmbL3ProtPredef.select(0);
                break;
            }
            case 17: {
                predef = true;
                this.cmbL3ProtPredef.select(1);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioL3ProtPredef.setSelection(predef);
        this.cmbL3ProtPredef.setEnabled(predef);
        this.radioL3ProtManual.setSelection(!predef);
        this.txtL3ProtManual.setEnabled(!predef);
    }

    public void updateL3_Ipv4Settings() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        if ((frame = this.frameView.getFrame()) == null) {
            return;
        }
        Ipv4Packet ipv4 = this.getFrameController().getIpv4();
        int caretPos = this.txtL3Ver.getCaretPosition();
        this.txtL3Ver.setText(Integer.toHexString(ipv4.getVersion()).toUpperCase());
        this.txtL3Ver.setSelection(caretPos, caretPos);
        caretPos = this.txtL3Hlen.getCaretPosition();
        this.txtL3Hlen.setText(Integer.toHexString(ipv4.getIHL()).toUpperCase());
        this.txtL3Hlen.setSelection(caretPos, caretPos);
        switch (frame.getL3TosType().getValue()) {
            case 0: {
                this.comboL3TOSMeaning.select(0);
                this.updateTosTexts(0);
                this.updatePresetList("TOS", ipv4.getTOS());
                break;
            }
            case 1: {
                this.comboL3TOSMeaning.select(1);
                this.updateTosTexts(1);
                this.updatePresetList("TOS", ipv4.getTOS());
                break;
            }
            case 2: {
                this.comboL3TOSMeaning.select(3);
                this.updateTosTexts(3);
                this.updatePresetList("None", ipv4.getTOS());
                break;
            }
            case 3: {
                this.comboL3TOSMeaning.select(2);
                this.updateTosTexts(2);
                this.updatePresetList("WME", ipv4.getTOS());
                break;
            }
        }
        int tosbits = ipv4.getTOS();
        this.checkTosFlag7.setSelection((tosbits >> 0 & 1) == 1);
        this.checkTosFlag6.setSelection((tosbits >> 1 & 1) == 1);
        this.checkTosFlag5.setSelection((tosbits >> 2 & 1) == 1);
        this.checkTosFlag4.setSelection((tosbits >> 3 & 1) == 1);
        this.checkTosFlag3.setSelection((tosbits >> 4 & 1) == 1);
        this.checkTosFlag2.setSelection((tosbits >> 5 & 1) == 1);
        this.checkTosFlag1.setSelection((tosbits >> 6 & 1) == 1);
        this.checkTosFlag0.setSelection((tosbits >> 7 & 1) == 1);
        int ipLen = ipv4.getLen();
        String len = Integer.toHexString(ipLen).toUpperCase();
        while (len.length() < 4) {
            len = "0" + len;
        }
        this.radioL3TotLenAuto.setSelection(frame.getL3AutoTotLen().booleanValue());
        this.radioL3TotLenManual.setSelection(frame.getL3AutoTotLen() == false);
        caretPos = this.txtL3TotLen.getCaretPosition();
        this.txtL3TotLen.setText(len);
        this.txtL3TotLen.setSelection(caretPos, caretPos);
        this.txtL3TotLen.setEnabled(frame.getL3AutoTotLen() == false);
        String id = Integer.toHexString(ipv4.getId()).toUpperCase();
        while (id.length() < 4) {
            id = "0" + id;
        }
        caretPos = this.txtL3Id.getCaretPosition();
        this.txtL3Id.setText(id);
        this.txtL3Id.setSelection(caretPos, caretPos);
        String flags = ipv4.getFlags();
        this.checkL3IpFlagReserved.setSelection(flags.indexOf("Reserved") != -1);
        this.checkL3IpFlagDNF.setSelection(flags.indexOf("DNF") != -1);
        this.checkL3IpFlagMF.setSelection(flags.indexOf("MF") != -1);
        String frag = Integer.toHexString(ipv4.getFragmentOffset()).toUpperCase();
        while (frag.length() < 4) {
            frag = "0" + frag;
        }
        caretPos = this.txtL3Frag.getCaretPosition();
        this.txtL3Frag.setText(frag);
        this.txtL3Frag.setSelection(caretPos, caretPos);
        String ttl = Integer.toHexString(ipv4.getTTL()).toUpperCase();
        while (ttl.length() < 2) {
            ttl = "0" + ttl;
        }
        caretPos = this.txtL3TTL.getCaretPosition();
        this.txtL3TTL.setText(ttl);
        this.txtL3TTL.setSelection(caretPos, caretPos);
        int l4Protocol = ipv4.getProtocol();
        String prot = Integer.toHexString(l4Protocol).toUpperCase();
        while (prot.length() < 2) {
            prot = "0" + prot;
        }
        caretPos = this.txtL3ProtManual.getCaretPosition();
        this.txtL3ProtManual.setText(prot);
        this.txtL3ProtManual.setSelection(caretPos, caretPos);
        this.updateL3HigherLevelProtocol(l4Protocol);
        boolean autoCheck = frame.getL3AutoHeaderCheck();
        this.radioL3HCAutomatic.setSelection(autoCheck);
        this.radioL3HCManual.setSelection(!autoCheck);
        caretPos = this.txtL3HCManual.getCaretPosition();
        this.txtL3HCManual.setEnabled(!autoCheck);
        this.txtL3HCManual.setSelection(caretPos, caretPos);
        int realCheck = ipv4.getCheckSum();
        String check = Integer.toHexString(realCheck);
        while (check.length() < 4) {
            check = "0" + check;
        }
        this.txtL3HCManual.setText(check);
        boolean autoSource = frame.getL3AutoSourceIp();
        this.radioL3SourceIpAutomatic.setSelection(autoSource);
        this.radioL3SourceIpManual.setSelection(!autoSource);
        this.txtL3SourceIpManual.setEnabled(!autoSource);
        caretPos = this.txtL3SourceIpManual.getCaretPosition();
        this.txtL3SourceIpManual.setText(ipv4.getSourceAddress());
        this.txtL3SourceIpManual.setSelection(caretPos, caretPos);
        boolean autoDest = frame.getL3AutoDestIp();
        this.radioL3DestIpAutomatic.setSelection(autoDest);
        this.radioL3DestIpManual.setSelection(!autoDest);
        this.txtL3DestIpManual.setEnabled(!autoDest);
        caretPos = this.txtL3DestIpManual.getCaretPosition();
        this.txtL3DestIpManual.setText(ipv4.getDestinationAddress());
        this.txtL3DestIpManual.setSelection(caretPos, caretPos);
    }

    private void updatePresetList(String type, int currentValue) {
        this.startPresets = presets.getOrDefault(type, new TOSPreset[0]);
        String[] newPresetNames = new String[this.startPresets.length + 1];
        String[] currentNames = this.comboL3TOSPreselect.getItems();
        boolean same = newPresetNames.length == currentNames.length;
        int preselect = Integer.MIN_VALUE;
        int ctr = 0;
        while (ctr < this.startPresets.length) {
            TOSPreset preset = this.startPresets[ctr];
            if (preset.value == currentValue) {
                preselect = ctr;
            }
            newPresetNames[ctr] = preset.name;
            same = same && preset.name == currentNames[ctr];
            ++ctr;
        }
        String custom = "Custom ";
        if (preselect < 0) {
            custom = TOSPreset.createLabel(custom, currentValue);
            preselect = this.startPresets.length;
        }
        same = same && custom == currentNames[currentNames.length - 1];
        newPresetNames[newPresetNames.length - 1] = custom;
        if (!same) {
            this.comboL3TOSPreselect.setItems(newPresetNames);
        }
        this.comboL3TOSPreselect.select(preselect);
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (!control.isFocusControl() || this.frameView.isUpdating()) {
            return;
        }
        FrameController frameController = this.getFrameController();
        Command command = null;
        if (control == this.txtL3Ver) {
            String l3Ver = this.txtL3Ver.getText();
            command = frameController.setIPv4Version(Integer.parseInt(l3Ver, 16));
        } else if (control == this.txtL3Hlen) {
            String l3HLen = this.txtL3Hlen.getText();
            command = frameController.setIPv4IHL(Integer.parseInt(l3HLen, 16));
        } else if (control == this.txtL3TotLen) {
            if (HexTextFactory.checkComplete((Text)this.txtL3TotLen)) {
                String totlen = this.txtL3TotLen.getText();
                int inttotlen = Integer.valueOf(totlen, 16);
                command = frameController.setIPv4Len(inttotlen);
            }
        } else if (control == this.txtL3Id) {
            if (HexTextFactory.checkComplete((Text)this.txtL3Id)) {
                String id = this.txtL3Id.getText();
                int intid = Integer.valueOf(id, 16);
                command = frameController.setIPv4Id(intid);
            }
        } else if (control == this.txtL3Frag) {
            if (HexTextFactory.checkComplete((Text)this.txtL3Frag)) {
                String frag = this.txtL3Frag.getText();
                int intfrag = Integer.parseInt(frag, 16);
                if (intfrag > 8191) {
                    this.txtL3Frag.setForeground(ExcentisColors.red);
                } else {
                    this.txtL3Frag.setForeground(null);
                    command = frameController.setIPv4FragmentOffset(intfrag);
                }
            }
        } else if (control == this.txtL3TTL) {
            if (HexTextFactory.checkComplete((Text)this.txtL3TTL)) {
                String ttl = this.txtL3TTL.getText();
                int intttl = Integer.parseInt(ttl, 16);
                command = frameController.setIPv4TTL(intttl);
            }
        } else if (control == this.txtL3ProtManual) {
            if (HexTextFactory.checkComplete((Text)this.txtL3ProtManual)) {
                command = this.changeL3Type();
            }
        } else if (control == this.txtL3HCManual) {
            if (HexTextFactory.checkComplete((Text)this.txtL3HCManual)) {
                String check = this.txtL3HCManual.getText();
                int intcheck = Integer.valueOf(check, 16);
                command = frameController.setIPv4CheckSum(intcheck);
            }
        } else if (control == this.txtL3SourceIpManual) {
            if (Ipv4AddressController.isValid((String)this.txtL3SourceIpManual.getText())) {
                String sourceIp = this.txtL3SourceIpManual.getText();
                command = frameController.setIPv4SourceAddress(sourceIp);
            }
        } else if (control == this.txtL3DestIpManual && Ipv4AddressController.isValid((String)this.txtL3DestIpManual.getText())) {
            String destIp = this.txtL3DestIpManual.getText();
            command = frameController.setIPv4DestinationAddress(destIp);
        }
        this.frameView.executeCommand(command);
    }

    private Command changeL3Type() {
        String type = this.txtL3ProtManual.getText();
        int newType = Integer.valueOf(type, 16);
        FrameController frameController = this.getFrameController();
        return frameController.setIpv4Protocol(newType);
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    Command handleControlEvent(Control control) {
        int idx;
        Command command = null;
        FrameController frameController = this.getFrameController();
        if (control == this.comboL3TOSMeaning) {
            int index = this.comboL3TOSMeaning.getSelectionIndex();
            FrameL3TosType tosType = FrameL3TosType.TOS_LITERAL;
            switch (index) {
                case 0: {
                    tosType = FrameL3TosType.TOS_LITERAL;
                    break;
                }
                case 1: {
                    tosType = FrameL3TosType.DIFF_SERV_LITERAL;
                    break;
                }
                case 3: {
                    tosType = FrameL3TosType.MANUAL_LITERAL;
                    break;
                }
                case 2: {
                    tosType = FrameL3TosType.WME_LITERAL;
                }
            }
            command = frameController.setIPv4TosType(tosType);
        } else if (control == this.checkTosFlag0) {
            command = frameController.updateTosFlag(7, this.checkTosFlag0.getSelection());
        } else if (control == this.checkTosFlag1) {
            command = frameController.updateTosFlag(6, this.checkTosFlag1.getSelection());
        } else if (control == this.checkTosFlag2) {
            command = frameController.updateTosFlag(5, this.checkTosFlag2.getSelection());
        } else if (control == this.checkTosFlag3) {
            command = frameController.updateTosFlag(4, this.checkTosFlag3.getSelection());
        } else if (control == this.checkTosFlag4) {
            command = frameController.updateTosFlag(3, this.checkTosFlag4.getSelection());
        } else if (control == this.checkTosFlag5) {
            command = frameController.updateTosFlag(2, this.checkTosFlag5.getSelection());
        } else if (control == this.checkTosFlag6) {
            command = frameController.updateTosFlag(1, this.checkTosFlag6.getSelection());
        } else if (control == this.checkTosFlag7) {
            command = frameController.updateTosFlag(0, this.checkTosFlag7.getSelection());
        } else if (control == this.radioL3TotLenAuto) {
            command = frameController.setIPv4AutoTotLen();
        } else if (control == this.radioL3TotLenManual) {
            command = frameController.setIPv4AutoTotLen(Boolean.FALSE);
        } else if (control == this.checkL3IpFlagReserved || control == this.checkL3IpFlagDNF || control == this.checkL3IpFlagMF) {
            String flags = "";
            if (this.checkL3IpFlagReserved.getSelection()) {
                flags = String.valueOf(flags) + "Reserved";
            }
            if (this.checkL3IpFlagDNF.getSelection()) {
                if (flags.length() > 0) {
                    flags = String.valueOf(flags) + "|";
                }
                flags = String.valueOf(flags) + "DNF";
            }
            if (this.checkL3IpFlagMF.getSelection()) {
                if (flags.length() > 0) {
                    flags = String.valueOf(flags) + "|";
                }
                flags = String.valueOf(flags) + "MF";
            }
            command = frameController.setIPv4Flags(flags);
        } else if (control == this.radioL3ProtPredef || control == this.cmbL3ProtPredef) {
            switch (this.cmbL3ProtPredef.getSelectionIndex()) {
                case 0: {
                    command = frameController.setIpv4Protocol(6);
                    break;
                }
                case 1: {
                    command = frameController.setIpv4Protocol(17);
                    break;
                }
            }
        } else if (control == this.radioL3HCAutomatic) {
            command = frameController.setL3AutoHeaderCheck();
        } else if (control == this.radioL3HCManual) {
            command = frameController.setIPv4AutoHeaderCheck(Boolean.FALSE);
        } else if (control == this.radioL3DestIpAutomatic) {
            command = frameController.setIPv4AutoDestIp(Boolean.TRUE);
        } else if (control == this.radioL3DestIpManual) {
            command = frameController.setIPv4AutoDestIp(Boolean.FALSE);
        } else if (control == this.radioL3SourceIpAutomatic) {
            command = frameController.setIPv4AutoSourceIp(Boolean.TRUE);
        } else if (control == this.radioL3SourceIpManual) {
            command = frameController.setIPv4AutoSourceIp(Boolean.FALSE);
        } else if (control == this.comboL3TOSPreselect && (idx = this.comboL3TOSPreselect.getSelectionIndex()) >= 0 && idx < this.startPresets.length) {
            TOSPreset selection = this.startPresets[idx];
            CompoundCommandController compound = CompoundCommandController.createInstance();
            int ctr = 0;
            while (ctr < 8) {
                compound.appendCommand(frameController.updateTosFlag(ctr, (selection.value & 1 << ctr) > 0));
                ++ctr;
            }
            command = compound.unwrap();
        }
        boolean inManual = this.radioL3ProtManual.getSelection();
        this.cmbL3ProtPredef.setEnabled(!inManual);
        this.txtL3ProtManual.setEnabled(inManual);
        return command;
    }

    private static class TOSPreset {
        final int value;
        final String name;

        public TOSPreset(String name, int value) {
            this.value = value;
            this.name = TOSPreset.createLabel(name, value);
        }

        static String createLabel(String name, int value) {
            return String.format("%s (0x%02X)", name, 0xFF & value);
        }
    }
}

