/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.Ipv6AddressField;
import com.excentis.products.byteblower.frame.Ipv6Packet;
import com.excentis.products.byteblower.gui.swt.widgets.text.HexTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv6AddressTextFactory;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.FrameController;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class Layer3_Ipv6Composite
extends FrameComposite {
    private static final int L4_TCP_INDEX = 0;
    private static final int L4_UDP_INDEX = 1;
    private final String[] L4Types = new String[]{Messages.getString("FrameView.L4.Type.Tcp"), Messages.getString("FrameView.L4.Type.Udp")};
    private Label lblVersion;
    private Text txtVersion;
    private Label lblTrafficClass;
    private Text txtTrafficClass;
    private Label lblFlowLabel;
    private Text txtFlowLabel;
    private Label lblPayloadLength;
    private Composite compPayloadLength;
    private Button radioAutoPayloadLength;
    private Button radioManualPayloadLength;
    private Text txtPayloadLength;
    private Label lblNextHeader;
    private Composite compNextHeader;
    private Button radioNextHeaderPredef;
    private Combo cmbNextHeaderPredef;
    private Button radioNextHeaderManual;
    private Text txtNextHeaderManual;
    private Label lblHopLimit;
    private Text txtHopLimit;
    private Label lblLSourceIpv6;
    private Composite compSourceIpv6;
    private Button radioSourceIpv6Automatic;
    private Button radioSourceIpv6Manual;
    private Text txtSourceIpv6Manual;
    private Label lblDestinationIpv6;
    private Composite compDestinationIpv6;
    private Button radioDestinationIpv6Automatic;
    private Button radioDestinationIpv6Manual;
    private Text txtDestinationIpv6Manual;

    public Layer3_Ipv6Composite(Composite parent, int style, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout());
        Composite composite = new Composite((Composite)this, 0);
        composite.setLayoutData((Object)new GridData(1808));
        composite.setLayout((Layout)new GridLayout(2, false));
        this.lblVersion = new Label(composite, 0);
        this.lblVersion.setText("Version (hex)");
        this.txtVersion = HexTextFactory.create((Composite)composite, (int)2048, (int)1);
        this.txtVersion.setLayoutData((Object)new GridData(768));
        this.txtVersion.addModifyListener((ModifyListener)this);
        this.txtVersion.addFocusListener((FocusListener)this);
        this.lblTrafficClass = new Label(composite, 0);
        this.lblTrafficClass.setText("Traffic Class (hex)");
        this.txtTrafficClass = HexTextFactory.create((Composite)composite, (int)2048, (int)2);
        this.txtTrafficClass.setLayoutData((Object)new GridData(768));
        this.txtTrafficClass.addModifyListener((ModifyListener)this);
        this.txtTrafficClass.addFocusListener((FocusListener)this);
        this.lblFlowLabel = new Label(composite, 0);
        this.lblFlowLabel.setText("Flow Label (hex)");
        this.txtFlowLabel = HexTextFactory.create((Composite)composite, (int)2048, (int)5);
        this.txtFlowLabel.setLayoutData((Object)new GridData(768));
        this.txtFlowLabel.addModifyListener((ModifyListener)this);
        this.txtFlowLabel.addFocusListener((FocusListener)this);
        this.lblPayloadLength = new Label(composite, 0);
        this.lblPayloadLength.setText("Payload Length");
        this.compPayloadLength = new Composite(composite, 2048);
        this.compPayloadLength.setLayoutData((Object)new GridData(768));
        this.compPayloadLength.setLayout((Layout)new GridLayout(2, false));
        this.radioAutoPayloadLength = new Button(this.compPayloadLength, 16);
        this.radioAutoPayloadLength.setText("Automatic");
        this.radioAutoPayloadLength.addMouseListener((MouseListener)this);
        Label dummyLabel2 = new Label(this.compPayloadLength, 0);
        dummyLabel2.setVisible(false);
        this.radioManualPayloadLength = new Button(this.compPayloadLength, 16);
        this.radioManualPayloadLength.setText("Manual (hex):");
        this.radioManualPayloadLength.addMouseListener((MouseListener)this);
        this.txtPayloadLength = HexTextFactory.create((Composite)this.compPayloadLength, (int)2048, (int)4);
        this.txtPayloadLength.setLayoutData((Object)new GridData(768));
        this.txtPayloadLength.setEnabled(false);
        this.txtPayloadLength.addModifyListener((ModifyListener)this);
        this.txtPayloadLength.addFocusListener((FocusListener)this);
        this.lblNextHeader = new Label(composite, 0);
        this.lblNextHeader.setText("Next Header");
        this.compNextHeader = new Composite(composite, 2048);
        this.compNextHeader.setLayoutData((Object)new GridData(768));
        this.compNextHeader.setLayout((Layout)new GridLayout(2, false));
        this.radioNextHeaderPredef = new Button(this.compNextHeader, 16);
        this.radioNextHeaderPredef.setText("Predefined:");
        this.radioNextHeaderPredef.addMouseListener((MouseListener)this);
        this.cmbNextHeaderPredef = new Combo(this.compNextHeader, 8);
        this.cmbNextHeaderPredef.setLayoutData((Object)new GridData(768));
        int i = 0;
        while (i < this.L4Types.length) {
            this.cmbNextHeaderPredef.add(this.L4Types[i]);
            ++i;
        }
        this.cmbNextHeaderPredef.select(0);
        this.cmbNextHeaderPredef.addSelectionListener((SelectionListener)this);
        this.radioNextHeaderManual = new Button(this.compNextHeader, 16);
        this.radioNextHeaderManual.addMouseListener((MouseListener)this);
        this.radioNextHeaderManual.setText("Manual (hex):");
        this.txtNextHeaderManual = HexTextFactory.create((Composite)this.compNextHeader, (int)2048, (int)2);
        this.txtNextHeaderManual.setLayoutData((Object)new GridData(768));
        this.txtNextHeaderManual.setEnabled(false);
        this.txtNextHeaderManual.addModifyListener((ModifyListener)this);
        this.txtNextHeaderManual.addFocusListener((FocusListener)this);
        this.lblHopLimit = new Label(composite, 0);
        this.lblHopLimit.setText("Hop Limit (hex)");
        this.txtHopLimit = HexTextFactory.create((Composite)composite, (int)2048, (int)2);
        this.txtHopLimit.setLayoutData((Object)new GridData(768));
        this.txtHopLimit.addModifyListener((ModifyListener)this);
        this.txtHopLimit.addFocusListener((FocusListener)this);
        this.lblLSourceIpv6 = new Label(composite, 0);
        this.lblLSourceIpv6.setText("Source Ipv6 Address");
        this.compSourceIpv6 = new Composite(composite, 2048);
        this.compSourceIpv6.setLayoutData((Object)new GridData(768));
        this.compSourceIpv6.setLayout((Layout)new GridLayout(2, false));
        this.radioSourceIpv6Automatic = new Button(this.compSourceIpv6, 16);
        this.radioSourceIpv6Automatic.setText("Automatic");
        this.radioSourceIpv6Automatic.addMouseListener((MouseListener)this);
        Label dummyLabel4 = new Label(this.compSourceIpv6, 0);
        dummyLabel4.setVisible(false);
        this.radioSourceIpv6Manual = new Button(this.compSourceIpv6, 16);
        this.radioSourceIpv6Manual.addMouseListener((MouseListener)this);
        this.radioSourceIpv6Manual.setText("Manual:");
        this.txtSourceIpv6Manual = Ipv6AddressTextFactory.instance().create(this.compSourceIpv6, 2048);
        this.txtSourceIpv6Manual.setLayoutData((Object)new GridData(768));
        this.txtSourceIpv6Manual.addModifyListener((ModifyListener)this);
        this.txtSourceIpv6Manual.addFocusListener((FocusListener)this);
        this.lblDestinationIpv6 = new Label(composite, 0);
        this.lblDestinationIpv6.setText("Destination Ipv6 Address");
        this.compDestinationIpv6 = new Composite(composite, 2048);
        this.compDestinationIpv6.setLayoutData((Object)new GridData(768));
        this.compDestinationIpv6.setLayout((Layout)new GridLayout(2, false));
        this.radioDestinationIpv6Automatic = new Button(this.compDestinationIpv6, 16);
        this.radioDestinationIpv6Automatic.setText("Automatic");
        this.radioDestinationIpv6Automatic.addMouseListener((MouseListener)this);
        Label dummyLabel5 = new Label(this.compDestinationIpv6, 0);
        dummyLabel5.setVisible(false);
        this.radioDestinationIpv6Manual = new Button(this.compDestinationIpv6, 16);
        this.radioDestinationIpv6Manual.addMouseListener((MouseListener)this);
        this.radioDestinationIpv6Manual.setText("Manual:");
        this.txtDestinationIpv6Manual = Ipv6AddressTextFactory.instance().create(this.compDestinationIpv6, 2048);
        this.txtDestinationIpv6Manual.setLayoutData((Object)new GridData(768));
        this.txtDestinationIpv6Manual.addModifyListener((ModifyListener)this);
        this.txtDestinationIpv6Manual.addFocusListener((FocusListener)this);
        this.layout();
    }

    public void updateL3_Ipv6Settings() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        if ((frame = this.getFrameController().getFrame()) == null) {
            return;
        }
        Ipv6Packet ipv6 = this.getFrameController().getIpv6();
        int caretPos = this.txtVersion.getCaretPosition();
        this.txtVersion.setText(Integer.toHexString(ipv6.getVersion()).toUpperCase());
        this.txtVersion.setSelection(caretPos, caretPos);
        String trafficClass = String.format("%02X", ipv6.getTrafficClass());
        caretPos = this.txtTrafficClass.getCaretPosition();
        this.txtTrafficClass.setText(trafficClass);
        this.txtTrafficClass.setSelection(caretPos, caretPos);
        String flowLabel = Integer.toHexString(ipv6.getFlowLabel()).toUpperCase();
        while (flowLabel.length() < 5) {
            flowLabel = "0" + flowLabel;
        }
        caretPos = this.txtFlowLabel.getCaretPosition();
        this.txtFlowLabel.setText(flowLabel);
        this.txtFlowLabel.setSelection(caretPos, caretPos);
        int payloadLength = ipv6.getPayloadLength();
        String len = Integer.toHexString(payloadLength).toUpperCase();
        while (len.length() < 4) {
            len = "0" + len;
        }
        boolean auto = frame.getL3AutoIpv6PayloadLength();
        this.radioAutoPayloadLength.setSelection(auto);
        this.radioManualPayloadLength.setSelection(!auto);
        this.txtPayloadLength.setEnabled(frame.getL3AutoIpv6PayloadLength() == false);
        caretPos = this.txtPayloadLength.getCaretPosition();
        this.txtPayloadLength.setText(len);
        this.txtPayloadLength.setSelection(caretPos, caretPos);
        int l4Protocol = ipv6.getNextHeader();
        String nextHeader = Integer.toHexString(l4Protocol).toUpperCase();
        while (nextHeader.length() < 2) {
            nextHeader = "0" + nextHeader;
        }
        caretPos = this.txtNextHeaderManual.getCaretPosition();
        this.txtNextHeaderManual.setText(nextHeader);
        this.txtNextHeaderManual.setSelection(caretPos, caretPos);
        this.updateNextHeader(l4Protocol);
        String hopLimit = Integer.toHexString(ipv6.getHopLimit()).toUpperCase();
        while (hopLimit.length() < 2) {
            hopLimit = "0" + hopLimit;
        }
        caretPos = this.txtHopLimit.getCaretPosition();
        this.txtHopLimit.setText(hopLimit);
        this.txtHopLimit.setSelection(caretPos, caretPos);
        boolean autoSource = frame.getL3AutoIpv6Source();
        this.radioSourceIpv6Automatic.setSelection(autoSource);
        this.radioSourceIpv6Manual.setSelection(!autoSource);
        this.txtSourceIpv6Manual.setEnabled(!autoSource);
        if (!this.txtSourceIpv6Manual.isFocusControl()) {
            caretPos = this.txtSourceIpv6Manual.getCaretPosition();
            this.txtSourceIpv6Manual.setText(ipv6.getSourceAddress());
            this.txtSourceIpv6Manual.setSelection(caretPos, caretPos);
        }
        boolean autoDestination = frame.getL3AutoIpv6Destination();
        this.radioDestinationIpv6Automatic.setSelection(autoDestination);
        this.radioDestinationIpv6Manual.setSelection(!autoDestination);
        this.txtDestinationIpv6Manual.setEnabled(!autoDestination);
        if (!this.txtDestinationIpv6Manual.isFocusControl()) {
            caretPos = this.txtDestinationIpv6Manual.getCaretPosition();
            this.txtDestinationIpv6Manual.setText(ipv6.getDestinationAddress());
            this.txtDestinationIpv6Manual.setSelection(caretPos, caretPos);
        }
    }

    private void updateNextHeader(int protocol) {
        boolean predef = true;
        switch (protocol) {
            case 6: {
                predef = true;
                this.cmbNextHeaderPredef.select(0);
                break;
            }
            case 17: {
                predef = true;
                this.cmbNextHeaderPredef.select(1);
                break;
            }
            default: {
                predef = false;
            }
        }
        this.radioNextHeaderPredef.setSelection(predef);
        this.cmbNextHeaderPredef.setEnabled(predef);
        this.radioNextHeaderManual.setSelection(!predef);
        this.txtNextHeaderManual.setEnabled(!predef);
    }

    public void modifyText(ModifyEvent e) {
        String address;
        Control control = (Control)e.widget;
        if (!control.isFocusControl() || this.frameView.isUpdating()) {
            return;
        }
        FrameController frameController = this.getFrameController();
        Command command = null;
        if (control == this.txtVersion) {
            if (HexTextFactory.checkComplete((Text)this.txtVersion)) {
                String version = this.txtVersion.getText();
                command = frameController.setIpv6Version(Integer.parseInt(version, 16));
            }
        } else if (control == this.txtTrafficClass) {
            if (HexTextFactory.checkComplete((Text)this.txtTrafficClass)) {
                String trafficClass = this.txtTrafficClass.getText();
                command = frameController.setIpv6TrafficClass(Integer.parseInt(trafficClass, 16));
            }
        } else if (control == this.txtFlowLabel) {
            if (HexTextFactory.checkComplete((Text)this.txtFlowLabel)) {
                String flowLabel = this.txtFlowLabel.getText();
                command = frameController.setIpv6FlowLabel(Integer.parseInt(flowLabel, 16));
            }
        } else if (control == this.txtPayloadLength) {
            if (HexTextFactory.checkComplete((Text)this.txtPayloadLength)) {
                String payloadLen = this.txtPayloadLength.getText();
                int intPayloadLen = Integer.valueOf(payloadLen, 16);
                command = frameController.setIpv6PayloadLength(intPayloadLen);
            }
        } else if (control == this.txtNextHeaderManual) {
            if (HexTextFactory.checkComplete((Text)this.txtNextHeaderManual)) {
                String type = this.txtNextHeaderManual.getText();
                int nextHeader = Integer.valueOf(type, 16);
                command = frameController.setIpv6NextHeader(nextHeader);
            }
        } else if (control == this.txtHopLimit) {
            if (HexTextFactory.checkComplete((Text)this.txtHopLimit)) {
                String hopLimit = this.txtHopLimit.getText();
                command = frameController.setIpv6HopLimit(Integer.parseInt(hopLimit, 16));
            }
        } else if (control == this.txtSourceIpv6Manual) {
            String address2 = this.txtSourceIpv6Manual.getText();
            if (Ipv6AddressField.isValid((String)address2, (boolean)true, (boolean)true)) {
                command = frameController.setIpv6SourceAddress(address2);
            }
        } else if (control == this.txtDestinationIpv6Manual && Ipv6AddressField.isValid((String)(address = this.txtDestinationIpv6Manual.getText()), (boolean)true, (boolean)true)) {
            command = frameController.setIpv6DestinationAddress(address);
        }
        this.frameView.executeCommand(command);
    }

    private Command comboNextHeaderChanged(int selectedIndex) {
        int inttype;
        FrameController frameController = this.getFrameController();
        switch (selectedIndex) {
            case 0: {
                inttype = 6;
                break;
            }
            case 1: {
                inttype = 17;
                break;
            }
            default: {
                return null;
            }
        }
        return frameController.setIpv6NextHeader(inttype);
    }

    @Override
    Command handleControlEvent(Control control) {
        FrameController frameController = this.getFrameController();
        Command command = null;
        if (control == this.radioAutoPayloadLength) {
            command = frameController.setL3AutoIpv6PayloadLength();
        } else if (control == this.radioManualPayloadLength) {
            command = frameController.setL3AutoIpv6PayloadLength(Boolean.FALSE);
        } else if (control == this.radioNextHeaderPredef) {
            command = this.comboNextHeaderChanged(this.cmbNextHeaderPredef.getSelectionIndex());
        } else if (control == this.cmbNextHeaderPredef) {
            command = this.comboNextHeaderChanged(this.cmbNextHeaderPredef.getSelectionIndex());
        } else if (control == this.radioSourceIpv6Automatic) {
            command = frameController.setL3AutoIpv6Source(Boolean.TRUE);
        } else if (control == this.radioSourceIpv6Manual) {
            command = frameController.setL3AutoIpv6Source(Boolean.FALSE);
        } else if (control == this.radioDestinationIpv6Automatic) {
            command = frameController.setL3AutoIpv6Destination(Boolean.TRUE);
        } else if (control == this.radioDestinationIpv6Manual) {
            command = frameController.setL3AutoIpv6Destination(Boolean.FALSE);
        }
        boolean headerManual = this.radioNextHeaderManual.getSelection();
        this.cmbNextHeaderPredef.setEnabled(!headerManual);
        this.txtNextHeaderManual.setEnabled(headerManual);
        return command;
    }

    public void focusLost(FocusEvent e) {
    }
}

