/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frame;

import com.excentis.products.byteblower.frame.EthernetPacket;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frame.FrameComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.frame.Layer4_TcpComposite;
import com.excentis.products.byteblower.gui.views.frame.Layer4_UdpComposite;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.utils.Utils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class Layer4Composite
extends FrameComposite {
    private boolean isInitialized = false;
    private ScrolledComposite l4ScrolledComposite;
    private Composite l4ErrorComposite;
    private Label errorL4;
    private Label lblL4Type;
    private Layer4_TcpComposite tcpComposite;
    private Layer4_UdpComposite udpComposite;

    public Layer4Composite(Composite parent, FrameView frameView) {
        super(parent, frameView);
    }

    private void initialize() {
        this.setLayout((Layout)new GridLayout(2, false));
        this.lblL4Type = new Label((Composite)this, 0);
        this.lblL4Type.setLayoutData((Object)new GridData(768));
        new Button((Composite)this, 0).setVisible(false);
        this.l4ScrolledComposite = new ScrolledComposite((Composite)this, 2816);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.l4ScrolledComposite.setLayoutData((Object)gridData);
        this.createL4ErrorComposite();
        this.tcpComposite = new Layer4_TcpComposite((Composite)this.l4ScrolledComposite, this.frameView);
        this.udpComposite = new Layer4_UdpComposite((Composite)this.l4ScrolledComposite, this.frameView);
        Point pt = this.tcpComposite.computeSize(-1, -1);
        this.l4ScrolledComposite.setMinWidth(pt.x);
        this.l4ScrolledComposite.setMinHeight(pt.y);
        this.l4ScrolledComposite.setExpandHorizontal(true);
        this.l4ScrolledComposite.setExpandVertical(true);
        this.layout();
    }

    private void createL4ErrorComposite() {
        this.l4ErrorComposite = new Composite((Composite)this.l4ScrolledComposite, 0);
        this.l4ErrorComposite.setLayoutData((Object)new GridData(1808));
        this.l4ErrorComposite.setLayout((Layout)new GridLayout());
        this.errorL4 = new Label(this.l4ErrorComposite, 0);
        this.errorL4.setLayoutData((Object)new GridData(768));
    }

    public void updateL4() {
        Frame frame;
        if (!this.isInitialized) {
            this.initialize();
            this.isInitialized = true;
        }
        boolean enable = (frame = this.frameView.getFrame()) != null;
        this.lblL4Type.setVisible(enable);
        this.l4ScrolledComposite.setVisible(enable);
        if (enable) {
            FrameController controller = this.getFrameController();
            EthernetPacket ethernet = controller.getEthernet();
            int layer4Type = controller.getCurrentLayer4Type();
            Control currentContent = this.l4ScrolledComposite.getContent();
            if (ethernet.isInvalid()) {
                int bitsize = frame.getBytesHexString().length() * 4;
                if (bitsize < 480) {
                    this.errorL4.setText(Messages.getString("FrameView.Error.L2.TooSmall"));
                } else if (bitsize > 65536) {
                    this.errorL4.setText(Messages.getString("FrameView.Error.L2.TooBig"));
                }
                this.setContent(this.l4ErrorComposite);
            } else {
                switch (layer4Type) {
                    case 0: {
                        this.lblL4Type.setText("TCP");
                        this.tcpComposite.updateL4_TcpSettings();
                        if (currentContent == this.tcpComposite) break;
                        this.setContent(this.tcpComposite);
                        break;
                    }
                    case 1: {
                        this.lblL4Type.setText("UDP");
                        this.udpComposite.updateL4_UdpSettings();
                        if (currentContent == this.udpComposite) break;
                        this.setContent(this.udpComposite);
                        break;
                    }
                    case 2: {
                        int l4Type = controller.getL4Type();
                        String info = "Type " + Utils.int2HexString((int)l4Type);
                        this.lblL4Type.setText(info);
                        this.errorL4.setText("No editor for this type.");
                        if (currentContent == this.l4ErrorComposite) break;
                        this.setContent(this.l4ErrorComposite);
                        break;
                    }
                    default: {
                        this.lblL4Type.setText("Unknown");
                        this.errorL4.setText("");
                        if (currentContent == this.l4ErrorComposite) break;
                        this.setContent(this.l4ErrorComposite);
                    }
                }
            }
        }
    }

    private void setContent(Composite composite) {
        Point pt = composite.computeSize(-1, -1);
        this.l4ScrolledComposite.setMinWidth(pt.x);
        this.l4ScrolledComposite.setMinHeight(pt.y);
        this.l4ScrolledComposite.setContent((Control)composite);
        this.l4ScrolledComposite.pack();
        Display.getCurrent().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!Layer4Composite.this.l4ScrolledComposite.isDisposed() && !Layer4Composite.this.isDisposed()) {
                    Layer4Composite.this.l4ScrolledComposite.layout();
                    Layer4Composite.this.layout();
                }
            }
        });
    }

    @Override
    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    @Override
    public void widgetSelected(SelectionEvent selectionEvent) {
    }

    public void modifyText(ModifyEvent e) {
    }

    public void focusLost(FocusEvent e) {
    }

    @Override
    Command handleControlEvent(Control control) {
        return null;
    }
}

