/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frameblasting;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.frameblasting.FrameBlastingSettingsComposite;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameModifier;
import com.excentis.products.byteblower.model.FrameSizeModifier;
import com.excentis.products.byteblower.model.GrowingSizeModifier;
import com.excentis.products.byteblower.model.MultipleBurst;
import com.excentis.products.byteblower.model.RandomSizeModifier;
import com.excentis.products.byteblower.model.ThroughputType;
import com.excentis.products.byteblower.model.TimingModifier;
import com.excentis.products.byteblower.model.reader.FrameBlastingFlowReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import com.excentis.products.byteblower.utils.Utils;
import java.math.BigDecimal;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

class FrameBlastingSettingsText
extends ByteBlowerComposite {
    private StyledText settingsText;

    public FrameBlastingSettingsText(FrameBlastingSettingsComposite parent) {
        super((Composite)parent, 2048);
        this.createContents();
    }

    public void addMouseListener(MouseListener listener) {
        this.settingsText.addMouseListener(listener);
    }

    private void createContents() {
        this.settingsText = new StyledText((Composite)this, 778);
        this.settingsText.setBackground(this.getBackground());
        this.setLayout((Layout)new GridLayout());
        this.settingsText.setLayoutData((Object)new GridData(1808));
    }

    void updateText(FrameBlastingFlow flowTemplate) {
        int[] boldStart = new int[16];
        int[] boldEnd = new int[16];
        int[] redStart = new int[5];
        int[] redEnd = new int[5];
        if (this.settingsText.isDisposed()) {
            return;
        }
        if (flowTemplate == null || flowTemplate.eContainer() == null) {
            this.settingsText.setText("");
            return;
        }
        FrameBlastingFlowReader reader = ReaderFactory.create((FrameBlastingFlow)flowTemplate);
        String text = "";
        int ora_start2 = text.length();
        text = String.valueOf(text) + "Speed:\r\n";
        int ora_end2 = text.length();
        text = String.valueOf(text) + "Intended Load: ";
        DataRateUnit unit = flowTemplate.getDataRateUnit();
        String formattedDataRate = reader.getThroughputString(unit);
        if (reader.dataRateTooBig()) {
            redStart[3] = text.length();
            text = String.valueOf(text) + formattedDataRate + " ";
            text = String.valueOf(text) + unit.getName();
            redEnd[3] = text.length();
        } else {
            boldStart[1] = text.length();
            text = String.valueOf(text) + formattedDataRate + " ";
            text = String.valueOf(text) + unit.getName();
            boldEnd[1] = text.length();
        }
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "Physical Load: ";
        String physicalDataRate = reader.getThroughputString(ThroughputType.FRAME_AND_ALL_OTHER_FIELDS, unit);
        if (reader.dataRateTooBig()) {
            redStart[4] = text.length();
            text = String.valueOf(text) + physicalDataRate + " ";
            text = String.valueOf(text) + unit.getName();
            redEnd[4] = text.length();
        } else {
            boldStart[14] = text.length();
            text = String.valueOf(text) + physicalDataRate + " ";
            text = String.valueOf(text) + unit.getName();
            boldEnd[14] = text.length();
        }
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.General_IPG") + " ";
        HighResolutionCalendar frameInterval = flowTemplate.getFrameInterval();
        if (frameInterval != null) {
            String frameIntervalTxt = HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)frameInterval, (boolean)false, (boolean)true);
            if (reader.dataRateTooBig()) {
                redStart[0] = text.length();
                text = String.valueOf(text) + frameIntervalTxt + " ";
                redEnd[0] = text.length();
            } else {
                boldStart[12] = text.length();
                text = String.valueOf(text) + frameIntervalTxt + " ";
                boldEnd[12] = text.length();
            }
        }
        text = String.valueOf(text) + "\r\n";
        text = String.valueOf(text) + "Frame Rate: ";
        BigDecimal framesPerSecond = reader.getFrameRate();
        String framesPerSec = Utils.trim((String)framesPerSecond.toString(), (int)6);
        if (reader.dataRateTooBig()) {
            redStart[1] = text.length();
            text = String.valueOf(text) + framesPerSec + " ";
            redEnd[1] = text.length();
        } else {
            boldStart[11] = text.length();
            text = String.valueOf(text) + framesPerSec + " ";
            boldEnd[11] = text.length();
        }
        text = String.valueOf(text) + "Frames/s\r\n";
        int ora_start3 = text.length();
        text = String.valueOf(text) + "\r\n" + Messages.getString("FlowTemplatesView.Settings.TimingModifier") + "\r\n";
        int ora_end3 = text.length();
        TimingModifier timing = flowTemplate.getTimingModifier();
        if (flowTemplate.getTimingModifier() == null) {
            text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.NotUsed") + "\r\n";
        } else if (timing != null && timing instanceof MultipleBurst) {
            MultipleBurst multipleBurst = (MultipleBurst)timing;
            text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.Timing_Type") + " ";
            boldStart[3] = text.length();
            text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.Timing_MultipleBurst") + "\r\n";
            boldEnd[3] = text.length();
            text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.Timing_InterBurstGap") + " ";
            boldStart[5] = text.length();
            HighResolutionCalendar gap = new HighResolutionCalendar(new Long(multipleBurst.getInterBurstGap()));
            text = String.valueOf(text) + HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)gap, (boolean)false, (boolean)true) + " ";
            boldEnd[5] = text.length();
            text = String.valueOf(text) + "\r\n";
            text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.Timing_NofFramesPerBurst") + " ";
            boldStart[4] = text.length();
            text = String.valueOf(text) + multipleBurst.getNofFramesPerBurst() + "\r\n";
            boldEnd[4] = text.length();
            if (frameInterval != null) {
                text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.Total_Burst_duration") + " ";
                boldStart[15] = text.length();
                HighResolutionCalendar cel = new HighResolutionCalendar(Long.valueOf((long)(Double.parseDouble(multipleBurst.getNofFramesPerBurst()) * (double)frameInterval.getTimeInNanoseconds() + (double)gap.getTimeInNanoseconds())));
                text = String.valueOf(text) + HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)cel, (boolean)false, (boolean)true) + "\r\n";
                boldEnd[15] = text.length();
            }
        }
        text = String.valueOf(text) + "\r\n";
        int ora_start4 = text.length();
        text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSizeModifier") + "\r\n";
        int ora_end4 = text.length();
        if (flowTemplate.getFrameModifier() == null) {
            text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.NotUsed");
        } else {
            FrameModifier frame = flowTemplate.getFrameModifier();
            if (frame != null && frame instanceof FrameSizeModifier) {
                FrameSizeModifier frameSize = (FrameSizeModifier)frame;
                if (frameSize instanceof RandomSizeModifier) {
                    RandomSizeModifier randomSizeModifier = (RandomSizeModifier)frameSize;
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize") + " ";
                    boldStart[6] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Random") + "\r\n";
                    boldEnd[6] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Min") + " ";
                    boldStart[7] = text.length();
                    text = String.valueOf(text) + randomSizeModifier.getMinSize() + " bytes\r\n";
                    boldEnd[7] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Max") + " ";
                    boldStart[8] = text.length();
                    text = String.valueOf(text) + randomSizeModifier.getMaxSize() + " bytes\r\n";
                    boldEnd[8] = text.length();
                } else if (frameSize instanceof GrowingSizeModifier) {
                    GrowingSizeModifier growingSizeModifier = (GrowingSizeModifier)frameSize;
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize") + " ";
                    boldStart[6] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Growing") + "\r\n";
                    boldEnd[6] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Min") + " ";
                    boldStart[7] = text.length();
                    text = String.valueOf(text) + growingSizeModifier.getMinSize() + " bytes\r\n";
                    boldEnd[7] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Max") + " ";
                    boldStart[8] = text.length();
                    text = String.valueOf(text) + growingSizeModifier.getMaxSize() + " bytes\r\n";
                    boldEnd[8] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_Step") + " ";
                    boldStart[9] = text.length();
                    text = String.valueOf(text) + growingSizeModifier.getStepSize() + " bytes\r\n";
                    boldEnd[9] = text.length();
                    text = String.valueOf(text) + Messages.getString("FlowTemplatesView.Settings.FrameSize_It") + " ";
                    boldStart[10] = text.length();
                    text = String.valueOf(text) + growingSizeModifier.getFrameIteration() + " times\r\n";
                    boldEnd[10] = text.length();
                }
            }
        }
        this.settingsText.setText(text);
        StyleRange styleRange = new StyleRange();
        styleRange.start = ora_start2;
        styleRange.length = ora_end2 - ora_start2;
        styleRange.fontStyle = 1;
        styleRange.foreground = ExcentisColors.blue;
        this.settingsText.setStyleRange(styleRange);
        styleRange = new StyleRange();
        styleRange.start = ora_start3;
        styleRange.length = ora_end3 - ora_start3;
        styleRange.fontStyle = 1;
        styleRange.foreground = ExcentisColors.blue;
        this.settingsText.setStyleRange(styleRange);
        styleRange = new StyleRange();
        styleRange.start = ora_start4;
        styleRange.length = ora_end4 - ora_start4;
        styleRange.fontStyle = 1;
        styleRange.foreground = ExcentisColors.blue;
        this.settingsText.setStyleRange(styleRange);
        int i = 0;
        while (i < boldEnd.length) {
            if (boldStart[i] != boldEnd[i]) {
                styleRange = new StyleRange();
                styleRange.start = boldStart[i];
                styleRange.length = boldEnd[i] - boldStart[i];
                styleRange.fontStyle = 1;
                this.settingsText.setStyleRange(styleRange);
            }
            ++i;
        }
        i = 0;
        while (i < 5) {
            if (redStart[i] != redEnd[i]) {
                styleRange = new StyleRange();
                styleRange.start = redStart[i];
                styleRange.length = redEnd[i] - redStart[i];
                styleRange.fontStyle = 1;
                styleRange.foreground = new Color(null, 255, 0, 0);
                this.settingsText.setStyleRange(styleRange);
            }
            ++i;
        }
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    public void updateWidgets() {
    }

    protected void projectChanged(ByteBlowerProject project) {
    }
}

