/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.frameblasting;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;

class FrameCellEditor
extends ComboBoxCellEditor
implements SelectionListener {
    public static final String FRAME_EDITOR_OPTION_NO = "";
    public static final String FRAME_EDITOR_OPTION_NEW = "New Frame...";

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        CCombo combo = (CCombo)control;
        combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    public FrameCellEditor(Table table) {
        super((Composite)table, new String[0], 0);
        this.setActivationStyle(1);
    }

    private String[] getItemList() {
        EList<Frame> frames = this.getAllFrames();
        int itemCount = frames.size();
        String[] frameNames = new String[2 + itemCount];
        frameNames[0] = FRAME_EDITOR_OPTION_NO;
        int i = 1;
        for (Frame frame : frames) {
            frameNames[i++] = frame.getName();
        }
        frameNames[i] = FRAME_EDITOR_OPTION_NEW;
        return frameNames;
    }

    public Object doGetValue() {
        Object superValue = super.doGetValue();
        Integer integer = (Integer)superValue;
        Object returnValue = FRAME_EDITOR_OPTION_NO;
        int index = integer;
        if (index > 0) {
            EList<Frame> allFrames = this.getAllFrames();
            returnValue = --index < allFrames.size() ? allFrames.get(index) : FRAME_EDITOR_OPTION_NEW;
        }
        return returnValue;
    }

    protected void doSetValue(Object value) {
        int index = 0;
        if (value != null) {
            Frame Frame2 = (Frame)value;
            index = this.getAllFrames().indexOf((Object)Frame2) + 1;
        }
        this.setItems(this.getItemList());
        super.doSetValue((Object)index);
    }

    private EList<Frame> getAllFrames() {
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        ByteBlowerProject project = (ByteBlowerProject)projectController.getObject();
        return project.getFrame();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.doGetValue() == FRAME_EDITOR_OPTION_NEW) {
            this.focusLost();
        }
    }
}

