/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui;

import com.excentis.products.byteblower.gui.views.hex.gui.HexTablePointer;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

class GotoDialog
extends Dialog {
    private Shell dialog;
    private Button btnDecAddress;
    private Button btnHexAddress;
    private Text txtAddress;
    private Button btnAbsoluteMode;
    private Button btnRelativeDownMode;
    private Button btnRelativeUpMode;
    private int rowIndex;
    private int columnIndex;
    private HexTablePointer newPosition;

    public GotoDialog(Shell parent, int style, int rowIndex, int columnIndex) {
        super(parent, style);
        this.rowIndex = rowIndex;
        this.columnIndex = columnIndex;
    }

    public HexTablePointer open() {
        this.dialog = new Shell(this.getParent(), this.getStyle());
        GridLayout grid = new GridLayout();
        grid.numColumns = 1;
        this.dialog.setText("Go to address");
        this.dialog.setLayout((Layout)grid);
        Composite inputPanel = new Composite((Composite)this.dialog, 0);
        GridLayout inputGrid = new GridLayout();
        inputGrid.numColumns = 2;
        inputGrid.marginHeight = 0;
        inputGrid.marginWidth = 0;
        inputGrid.horizontalSpacing = 5;
        inputPanel.setLayout((Layout)inputGrid);
        inputPanel.setLayoutData((Object)new GridData(16));
        Composite addressPanel = new Composite(inputPanel, 0);
        GridLayout addressGrid = new GridLayout();
        addressGrid.numColumns = 1;
        addressPanel.setLayout((Layout)addressGrid);
        addressPanel.setLayoutData((Object)new GridData(16));
        this.createAddressPanel(addressPanel);
        Composite modePanel = new Composite(inputPanel, 0);
        GridLayout modeGrid = new GridLayout();
        modeGrid.numColumns = 1;
        modePanel.setLayout((Layout)modeGrid);
        modePanel.setLayoutData((Object)new GridData(16));
        this.createModePanel(modePanel);
        Composite buttonPanel = new Composite((Composite)this.dialog, 0);
        GridLayout buttonGrid = new GridLayout();
        buttonGrid.numColumns = 2;
        buttonPanel.setLayout((Layout)buttonGrid);
        buttonPanel.setLayoutData((Object)new GridData(128));
        this.createButtonPanel(buttonPanel);
        this.dialog.pack();
        this.dialog.open();
        while (!this.dialog.isDisposed()) {
            if (this.getParent().getDisplay().readAndDispatch()) continue;
            this.getParent().getDisplay().sleep();
        }
        return this.newPosition;
    }

    private void createAddressPanel(Composite parent) {
        Group addressGroup = new Group(parent, 0);
        addressGroup.setLayoutData((Object)new GridData(1040));
        addressGroup.setText("Address");
        GridLayout addressLayout = new GridLayout();
        addressLayout.numColumns = 1;
        addressGroup.setLayout((Layout)addressLayout);
        this.btnDecAddress = new Button((Composite)addressGroup, 16);
        this.btnDecAddress.setText("Decimal");
        this.btnDecAddress.setSelection(true);
        this.btnHexAddress = new Button((Composite)addressGroup, 16);
        this.btnHexAddress.setText("Hexadecimal");
        this.btnHexAddress.setSelection(false);
        this.txtAddress = new Text((Composite)addressGroup, 2052);
        this.txtAddress.setTextLimit(8);
        this.txtAddress.setText("");
        this.txtAddress.setFocus();
    }

    private void createModePanel(Composite parent) {
        Group modeGroup = new Group(parent, 0);
        modeGroup.setLayoutData((Object)new GridData(1040));
        modeGroup.setText("Mode");
        GridLayout modeLayout = new GridLayout();
        modeLayout.numColumns = 1;
        modeGroup.setLayout((Layout)modeLayout);
        this.btnAbsoluteMode = new Button((Composite)modeGroup, 16);
        this.btnAbsoluteMode.setText("Absolute");
        this.btnAbsoluteMode.setSelection(true);
        this.btnRelativeDownMode = new Button((Composite)modeGroup, 16);
        this.btnRelativeDownMode.setText("Relative down");
        this.btnRelativeDownMode.setSelection(false);
        this.btnRelativeUpMode = new Button((Composite)modeGroup, 16);
        this.btnRelativeUpMode.setText("Relative up");
        this.btnRelativeUpMode.setSelection(false);
    }

    private void createButtonPanel(Composite parent) {
        Button ok = new Button(parent, 8);
        ok.setText("OK");
        GridData data = new GridData();
        data.widthHint = 75;
        ok.setLayoutData((Object)data);
        ok.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GotoDialog.this.calculateNewPosition();
                if (GotoDialog.this.newPosition != null) {
                    GotoDialog.this.dialog.dispose();
                }
            }
        });
        Button cancel = new Button(parent, 8);
        cancel.setText("Cancel");
        data = new GridData();
        data.widthHint = 75;
        cancel.setLayoutData((Object)data);
        cancel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GotoDialog.this.dialog.dispose();
            }
        });
    }

    private void calculateNewPosition() {
        int iAddress = 0;
        String sAddress = this.txtAddress.getText();
        boolean addressIsDec = this.btnDecAddress.getSelection();
        this.newPosition = null;
        if (sAddress.length() == 0) {
            MessageDialog.openError((Shell)this.getParent().getShell(), (String)"Frame Error", (String)"Address is missing!");
            this.txtAddress.setFocus();
            return;
        }
        try {
            iAddress = Integer.parseInt(sAddress, addressIsDec ? 10 : 16);
        }
        catch (NumberFormatException numberFormatException) {
            MessageDialog.openError((Shell)this.getParent().getShell(), (String)"Frame Error", (String)("Address: Incorrect number format!\nPlease enter a valid " + (addressIsDec ? "decimal" : "hexadecimal") + " number."));
            this.txtAddress.setFocus();
            this.txtAddress.selectAll();
            return;
        }
        if (iAddress < 0) {
            MessageDialog.openError((Shell)this.getParent().getShell(), (String)"Frame Error", (String)"Address cannot be negative!");
            this.txtAddress.setFocus();
            this.txtAddress.selectAll();
            return;
        }
        this.newPosition = this.btnAbsoluteMode.getSelection() ? new HexTablePointer(0, 0).move(iAddress) : (this.btnRelativeDownMode.getSelection() ? new HexTablePointer(this.rowIndex, this.columnIndex).move(iAddress - 1) : new HexTablePointer(this.rowIndex, this.columnIndex).move(-iAddress - 1));
    }
}

