/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui;

import com.excentis.products.byteblower.gui.swt.widgets.ByteBlowerComposite;
import com.excentis.products.byteblower.gui.views.frame.FrameView;
import com.excentis.products.byteblower.gui.views.hex.core.Hex;
import com.excentis.products.byteblower.gui.views.hex.gui.AddDataDialog;
import com.excentis.products.byteblower.gui.views.hex.gui.DeleteDataDialog;
import com.excentis.products.byteblower.gui.views.hex.gui.GotoDialog;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTable;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTableItem;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTablePointer;
import com.excentis.products.byteblower.gui.views.hex.gui.events.CellEditorKeyListener;
import com.excentis.products.byteblower.gui.views.hex.gui.events.CursorKeyListener;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.object.control.ByteController;
import com.excentis.products.byteblower.utils.Utils;
import org.eclipse.emf.common.command.Command;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.ControlEditor;
import org.eclipse.swt.custom.TableCursor;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class HexEditorControl
extends ByteBlowerComposite {
    private final FrameView frameView;
    private TableCursor cursor;
    private HexTable hexTable;
    private Label label;
    private Label statusOffset;
    private Label statusValue;
    private Label statusFileSize;
    private byte[] buffer = new byte[11000];
    public static boolean isShifting = false;
    private CursorKeyListener cursorKeyListener;
    private static final int popupPosCut = 0;
    private static final int popupPosCopy = 1;
    private static final int popupPosPaste = 2;
    private static final int popupPosSep1 = 3;
    private static final int popupPosDel = 4;
    private static final int popupPosSep2 = 5;
    private static final int popupPosInsert = 6;
    private static final int popupPosAppend = 7;
    private static final int popupPosSep3 = 8;
    private static final int popupPosDelete = 9;
    private static final int popupPosSep4 = 10;
    private static final int popupPosGoto = 11;

    public HexEditorControl(FrameView frameView, Composite parent) {
        super(parent, frameView.getFrameTableComposite());
        this.frameView = frameView;
        this.initialize();
    }

    public void update() {
        this.updateTable();
        this.updateWidgets();
        this.updateCursor();
        this.updateStatusPanel();
    }

    private void updateTable() {
        FrameController frameController = this.getFrameController();
        if (frameController == null) {
            this.hexTable.reset();
        } else {
            String hexBytes = frameController.getHexBytes();
            int frameSize = hexBytes.length() / 2;
            if (frameSize <= 0) {
                this.hexTable.addDummyItem();
            } else {
                boolean reset;
                int bufferIndex = 0;
                int dataAvailable = frameSize;
                int biggestDataIndex = (dataAvailable - 1) / 16;
                int biggestRowIndex = this.hexTable.getItemCount() - 1;
                boolean bl = reset = biggestDataIndex != biggestRowIndex;
                if (reset) {
                    this.hexTable.reset();
                } else {
                    this.hexTable.resetIndex();
                }
                while (dataAvailable > 0) {
                    int nofBytesToRead = dataAvailable <= 11000 ? dataAvailable : 11000;
                    int nofBytesRead = this.readPartIntoBuffer(hexBytes, nofBytesToRead);
                    dataAvailable -= nofBytesRead;
                    if (reset) {
                        this.hexTable.addData(bufferIndex, this.buffer, nofBytesRead);
                    } else {
                        this.hexTable.updateData(bufferIndex, this.buffer, nofBytesRead);
                    }
                    ++bufferIndex;
                }
            }
        }
    }

    private int readPartIntoBuffer(String bytesHexString, int nofBytesToRead) {
        int j = 0;
        int i = 0;
        while (i < nofBytesToRead * 2) {
            String byteString = bytesHexString.substring(i, i + 2);
            Byte byto = ByteController.getHexByte((String)byteString);
            this.buffer[j++] = byto;
            i += 2;
        }
        return nofBytesToRead;
    }

    public void updateWidgets() {
        FrameController controller = this.getFrameController();
        boolean enable = controller != null;
        this.label.setEnabled(enable);
        Table table = this.hexTable.getTable();
        table.setHeaderVisible(enable);
        table.setEnabled(enable);
    }

    public Table getTable() {
        return this.hexTable.getTable();
    }

    private void updateCursor() {
        if (this.cursor != null) {
            this.cursor.redraw();
        }
    }

    private void initialize() {
        GridLayout layout = new GridLayout(3, false);
        this.setLayout((Layout)layout);
        this.label = new Label((Composite)this, 0);
        this.label.setText("Bytes:");
        new Button((Composite)this, 0).setVisible(false);
        new Button((Composite)this, 0).setVisible(false);
        this.createHexTable();
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 3;
        this.hexTable.setLayoutData(gridData);
        this.createOffsetPanel();
        this.createValuePanel();
        this.createFileSizePanel();
        this.updateWidgets();
    }

    public HexTable getHexTable() {
        return this.hexTable;
    }

    public FrameView getFrameView() {
        return this.frameView;
    }

    public void dispose() {
        if (this.hexTable != null) {
            this.hexTable.dispose();
            this.hexTable = null;
        }
        if (this.cursor != null) {
            this.cursor.dispose();
            this.cursor = null;
        }
    }

    private void createHexTable() {
        Menu menu = this.createPopupMenu();
        this.hexTable = new HexTable(this, 2564);
        this.hexTable.setHeaderVisible(true);
        this.hexTable.setLinesVisible(true);
        this.hexTable.setBackground(new Color((Device)Display.getCurrent(), Hex.COLOR_BACKGROUND_TABLE));
        this.hexTable.setForeground(new Color((Device)Display.getCurrent(), Hex.COLOR_FOREGROUND_TABLE));
        this.hexTable.setMenu(menu);
        this.cursor = new TableCursor(this.hexTable.getTable(), 0);
        this.cursor.setMenu(menu);
        ControlEditor editor = new ControlEditor((Composite)this.cursor);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        this.addCursorListeners(this.cursor, editor);
        this.createTableHeader(this.hexTable);
    }

    private void createOffsetPanel() {
        this.statusOffset = new Label((Composite)this, 2048);
        GridData gridData = new GridData(768);
        this.statusOffset.setLayoutData((Object)gridData);
    }

    private void createValuePanel() {
        this.statusValue = new Label((Composite)this, 2048);
        GridData gridData = new GridData(768);
        this.statusValue.setLayoutData((Object)gridData);
    }

    public void hiliteShiftSelection() {
        this.hexTable.hiliteShiftSelection();
    }

    private void createFileSizePanel() {
        this.statusFileSize = new Label((Composite)this, 2048);
        GridData gridData = new GridData(768);
        this.statusFileSize.setLayoutData((Object)gridData);
    }

    private void addCursorListeners(final TableCursor cursor, ControlEditor editor) {
        this.cursorKeyListener = new CursorKeyListener(this, cursor, editor);
        cursor.addKeyListener((KeyListener)this.cursorKeyListener);
        MouseListener mouseListener = new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                if (e.button == 1) {
                    HexEditorControl.this.locationChange();
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        };
        cursor.addMouseListener(mouseListener);
        cursor.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HexEditorControl.this.locationChange();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                HexEditorControl.this.hexTable.setSelection(new TableItem[]{cursor.getRow()});
            }
        });
    }

    private void locationChange() {
        this.refreshSelection();
        if (this.cursorKeyListener.getText() != null) {
            this.cursorKeyListener.getCellEditorKeyListener().closeCellEditor(this.cursorKeyListener.getEventItem(), this.cursorKeyListener.getEventColumn(), "0" + this.cursorKeyListener.getText().getText().toUpperCase());
            this.saveFrame();
        }
    }

    private boolean isInShiftBlock(int row, int column) {
        int endCol;
        int startCol;
        int shiftRow = CellEditorKeyListener.shiftRow;
        int shiftCol = CellEditorKeyListener.shiftColumn;
        int selectedRow = CellEditorKeyListener.selectedRow;
        int selectedCol = CellEditorKeyListener.selectedColumn;
        if (selectedRow == -1 || selectedCol == -1) {
            return false;
        }
        if (shiftRow == -1 || shiftCol == -1) {
            shiftRow = selectedRow;
            shiftCol = selectedCol;
        }
        int startRow = Math.min(shiftRow, selectedRow);
        int endRow = Math.max(shiftRow, selectedRow);
        if (shiftRow < selectedRow) {
            startCol = shiftCol;
            endCol = selectedCol;
        } else if (shiftRow == selectedRow) {
            startCol = Math.min(shiftCol, selectedCol);
            endCol = Math.max(shiftCol, selectedCol);
        } else {
            startCol = selectedCol;
            endCol = shiftCol;
        }
        boolean in = false;
        if (row == startRow && row == endRow) {
            in = column >= startCol && column <= endCol;
        } else if (row == startRow) {
            in = column >= startCol;
        } else if (row == endRow) {
            in = column <= endCol;
        } else if (row > startRow && row < endRow) {
            in = true;
        }
        return in;
    }

    private void refreshSelection() {
        TableItem selectedItem = this.cursor.getRow();
        if (selectedItem != null) {
            this.hexTable.setSelection(new TableItem[]{selectedItem});
            int row = this.hexTable.getItem(this.cursor.getRow()).getIndex();
            int column = this.cursor.getColumn();
            if (!this.isInShiftBlock(row, column)) {
                CellEditorKeyListener.selectedRow = row;
                CellEditorKeyListener.selectedColumn = column;
                if (isShifting) {
                    this.hexTable.hiliteShiftSelection();
                } else {
                    this.hexTable.unHilite();
                }
            }
        }
        this.updateStatusPanel();
        this.updateCutCopyPasteDel();
    }

    public void updateCutCopyPasteDel() {
    }

    private void createTableHeader(HexTable table) {
        int i = 0;
        while (i < 17) {
            TableColumn tableColumn = new TableColumn(table.getTable(), 0x1000000);
            tableColumn.setResizable(true);
            if (i == 0) {
                tableColumn.setText("Offset");
            } else if (i >= 1 && i <= 16) {
                tableColumn.setText(Integer.toHexString(i - 1).toUpperCase());
            }
            ++i;
        }
        table.onResize();
    }

    private Menu createPopupMenu() {
        Menu popUpMenu = new Menu((Decorations)this.getShell(), 8);
        return popUpMenu;
    }

    private void popupMenuInsertData(int rowIndex, int columnIndex) {
        AddDataDialog addDataDialog = new AddDataDialog(this.getShell(), 67680, 1);
        addDataDialog.setText("Insert data");
        int[] addDialogResult = addDataDialog.open();
        if (addDialogResult == null) {
            return;
        }
        int dataSize = addDialogResult[0];
        int dataValue = addDialogResult[1];
        if (dataSize <= 0) {
            return;
        }
        int tableSize = this.hexTable.getTableSize();
        if (tableSize + dataSize >= 8192) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Frame size", (String)"The maximum frame size is reached. (8192 bytes)");
            dataSize = 8192 - tableSize;
        }
        if (dataSize <= 0) {
            return;
        }
        this.hexTable.insertData(dataSize, dataValue, rowIndex, columnIndex - 1, true);
        this.saveFrame();
        this.updateStatusPanel();
    }

    private void popupMenuAppendData(int rowIndex, int columnIndex) {
        AddDataDialog addDataDialog = new AddDataDialog(this.getShell(), 67680, 2);
        addDataDialog.setText("Append data");
        int[] addDialogResult = addDataDialog.open();
        if (addDialogResult == null) {
            return;
        }
        int dataSize = addDialogResult[0];
        int dataValue = addDialogResult[1];
        if (dataSize <= 0) {
            return;
        }
        int tableSize = this.hexTable.getTableSize();
        if (tableSize + dataSize >= 8192) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Frame size", (String)"The maximum frame size is reached. (8192 bytes)");
            dataSize = 8192 - tableSize;
        }
        if (dataSize <= 0) {
            return;
        }
        this.hexTable.appendData(dataSize, dataValue, rowIndex, columnIndex, true);
        this.saveFrame();
        this.updateStatusPanel();
    }

    private void popupMenuDeleteData(int rowIndex, int columnIndex) {
        DeleteDataDialog deleteDataDialog = new DeleteDataDialog(this.getShell(), 67680);
        deleteDataDialog.setText("Delete data");
        int delSize = deleteDataDialog.open();
        if (delSize == 0) {
            return;
        }
        this.hexTable.deleteData(delSize, rowIndex, columnIndex - 1, true);
        this.saveFrame();
        this.updateStatusPanel();
    }

    public void saveFrame() {
        String newHexBytes = this.getHexBytes();
        FrameController frameController = this.getFrameController();
        Command command = frameController.setCorrectedHexBytes(newHexBytes);
        this.frameView.executeCommand(command);
    }

    private FrameController getFrameController() {
        return this.frameView.getFrameController();
    }

    private String getHexBytes() {
        try {
            String bytesHexString = "";
            int n = 0;
            byte[] tempBuffer = new byte[16];
            int itemCount = this.hexTable.getItemCount();
            int i = 0;
            while (i < itemCount) {
                n = this.hexTable.getRowData(tempBuffer, i);
                int j = 0;
                while (j < n) {
                    byte curByte = tempBuffer[j];
                    String byteHex = Utils.byte2string((byte)curByte);
                    bytesHexString = String.valueOf(bytesHexString) + byteHex;
                    ++j;
                }
                ++i;
            }
            return bytesHexString;
        }
        catch (Exception e) {
            System.out.println("Error saving frame !!!");
            e.printStackTrace();
            return null;
        }
    }

    private void popupMenuGoto(int rowIndex, int columnIndex) {
        GotoDialog gotoDialog = new GotoDialog(this.getShell(), 67680, rowIndex, columnIndex);
        HexTablePointer p = gotoDialog.open();
        if (p == null) {
            return;
        }
        if (p.getRowIndex() < 0 || p.getColumnIndex() < 0) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Frame Error", (String)"Address is out of range!");
            this.cursor.setSelection(0, 1);
            this.cursor.redraw();
            this.hexTable.setSelection(0);
            this.updateStatusPanel();
            return;
        }
        try {
            this.cursor.setSelection(p.getRowIndex(), p.getColumnIndex() + 1);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            int numRows = this.hexTable.getItemCount();
            int lastRowIndex = numRows > 0 ? numRows - 1 : numRows;
            MessageDialog.openError((Shell)this.getShell(), (String)"Frame Error", (String)"Address is out of range!");
            this.cursor.setSelection(lastRowIndex, this.hexTable.getItem(this.hexTable.getItemCount() - 1).getItemSize());
            this.cursor.redraw();
            this.hexTable.setSelection(lastRowIndex);
            this.updateStatusPanel();
            return;
        }
        this.cursor.setSelection(p.getRowIndex(), p.getColumnIndex() + 1);
        this.cursor.redraw();
        this.hexTable.setSelection(p.getRowIndex());
        this.updateStatusPanel();
    }

    public void updateStatusPanel() {
        String aid;
        int rowIndex = this.hexTable.getSelectionIndex();
        int columnIndex = this.cursor.getColumn();
        HexTableItem item = this.hexTable.getItem(rowIndex);
        if (item == null) {
            this.statusOffset.setText("");
            this.statusValue.setText("");
        } else {
            String cellData = item.getText(columnIndex);
            if (columnIndex < 1 || columnIndex > 16 || cellData.length() == 0 || cellData.equals("  ")) {
                this.statusOffset.setText("");
                this.statusValue.setText("");
            } else {
                HexTablePointer p = new HexTablePointer(rowIndex, columnIndex - 1);
                int offset = p.getOffset();
                int tableSize = this.hexTable.getTableSize();
                int ratio = tableSize > 1 ? 100 * offset / (tableSize - 1) : 100;
                aid = String.format("Offset: 0x%X of 0x%X (%d %%)", offset, tableSize - 1, ratio);
                this.statusOffset.setText(aid);
                this.statusOffset.setToolTipText(aid);
                String value = item.getText(columnIndex);
                int number = Integer.parseInt(value, 16);
                String binString = Integer.toBinaryString(number);
                aid = String.format("Value: 0x%02X (hex) = %d (dec) = %s (bin) ", number, number, binString);
                this.statusValue.setText(aid);
                this.statusValue.setToolTipText(aid);
            }
        }
        int tableSize = this.hexTable.getTableSize();
        if (tableSize == 0) {
            this.statusFileSize.setText("");
            this.statusFileSize.setToolTipText("");
        } else {
            aid = " Frame Length: " + tableSize + " bytes ";
            this.statusFileSize.setText(aid);
            this.statusFileSize.setToolTipText(aid);
        }
    }

    void redrawCursor() {
        this.cursor.redraw();
    }

    void setCursorSelection(int row, int column) {
        this.cursor.setSelection(row, column);
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        this.update();
    }

    protected void projectChanged(ByteBlowerProject project) {
        this.update();
    }
}

