/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.hex.gui;

import com.excentis.products.byteblower.gui.colors.ExcentisColors;
import com.excentis.products.byteblower.gui.views.hex.gui.HexTable;
import com.excentis.products.byteblower.utils.Utils;
import java.io.UnsupportedEncodingException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;

public class HexTableItem
extends Item
implements Cloneable {
    private TableItem tableItem;
    private HexTable parent;
    private int tableIndex;

    HexTableItem(HexTable parent, int style) {
        super((Widget)parent, style);
        this.parent = parent;
        this.tableIndex = parent.addItem(this);
        this.tableItem = new TableItem(parent.getTable(), style);
        this.tableItem.setData((Object)this);
    }

    HexTableItem(HexTable parent, int style, int index) {
        super((Widget)parent, style, index);
        this.parent = parent;
        this.tableIndex = parent.addItem(this);
        this.tableItem = new TableItem(parent.getTable(), style, index);
        this.tableItem.setData((Object)this);
    }

    HexTableItem getItem(TableItem tableItem) {
        if (tableItem == null) {
            return null;
        }
        if (this.tableItem == tableItem) {
            return this;
        }
        return null;
    }

    public int getIndex() {
        return this.tableIndex;
    }

    public Display getDisplay() {
        HexTable parent = this.parent;
        if (parent == null) {
            throw new SWTError(24);
        }
        return parent.getDisplay();
    }

    public TableItem getItem() {
        return this.tableItem;
    }

    public HexTable getParent() {
        return this.parent;
    }

    public void setText(int index, String string) {
        if (this.tableItem == null) {
            System.out.println("ERROR IN HEXTABLEITEM");
        }
        this.tableItem.setText(index, string);
    }

    public String getText(int index) {
        return this.tableItem.getText(index);
    }

    void delete(int columnIndexBegin) {
        this.delete(columnIndexBegin, 15);
    }

    private void delete(int columnIndexBegin, int columnIndexEnd) {
        int i = columnIndexBegin;
        while (i <= columnIndexEnd) {
            this.tableItem.setText(i + 1, "  ");
            ++i;
        }
    }

    public void setBackground(Color color) {
        this.tableItem.setBackground(color);
    }

    public void setForeground(Color color) {
        this.tableItem.setForeground(color);
    }

    public void setBackground(int index, Color color) {
        this.tableItem.setBackground(index, color);
    }

    void setForeground(int index, Color color) {
        this.tableItem.setForeground(index, color);
    }

    public void dispose() {
        super.dispose();
        if (!this.parent.isInDispose() && this.tableItem != null) {
            this.tableItem.dispose();
        }
        this.tableItem = null;
    }

    void itemFiller() {
        int i = 0;
        while (i < 16) {
            if (this.tableItem.getText(i + 1).length() == 0) {
                this.tableItem.setText(i + 1, "  ");
            }
            ++i;
        }
    }

    public int getItemSize() {
        int numDataCells = 0;
        int i = 0;
        while (i < 16) {
            String data = this.tableItem.getText(i + 1);
            if (!data.equals("  ") && data.length() > 0) {
                ++numDataCells;
            }
            ++i;
        }
        return numDataCells;
    }

    private String getHexString(int n) {
        String nString = Integer.toHexString(n).toUpperCase();
        return String.valueOf("00000000".substring(nString.length())) + nString;
    }

    int addData(int bufferIndex, int rowIndex, byte[] buffer, int dataAvailable, int dataStartIndex) {
        int dataCounter = 0;
        if (dataStartIndex >= dataAvailable) {
            return -1;
        }
        int currentItemSize = this.getItemSize();
        if (currentItemSize == 16) {
            return 0;
        }
        this.tableItem.setText(0, this.getHexString(bufferIndex * 11000 + 16 * rowIndex));
        int i = currentItemSize;
        while (i < 16 && dataStartIndex + dataCounter < dataAvailable) {
            this.tableItem.setText(i + 1, Utils.byte2string((byte)buffer[dataStartIndex + dataCounter]));
            ++dataCounter;
            ++i;
        }
        this.itemFiller();
        return dataCounter;
    }

    int updateData(int bufferIndex, int rowIndex, byte[] buffer, int dataAvailable, int dataStartIndex) {
        int dataCounter = 0;
        if (dataStartIndex >= dataAvailable) {
            return -1;
        }
        this.tableItem.setText(0, this.getHexString(bufferIndex * 11000 + 16 * rowIndex));
        int i = 0;
        while (i < 16 && dataStartIndex + dataCounter < dataAvailable) {
            String oldText = this.tableItem.getText(i + 1);
            String newText = Utils.byte2string((byte)buffer[dataStartIndex + dataCounter]);
            boolean color = oldText == "  " ? false : !oldText.equals(newText);
            this.tableItem.setText(i + 1, newText);
            this.tableItem.setForeground(i + 1, (Color)(color ? ExcentisColors.blue : null));
            ++dataCounter;
            ++i;
        }
        while (i < 16) {
            this.tableItem.setText(i + 1, "");
            ++i;
        }
        this.itemFiller();
        return dataCounter;
    }

    public boolean refreshCharacterView(String encoding) {
        int rowLength = 16;
        byte[] hexData = new byte[1];
        StringBuffer stringData = new StringBuffer(16);
        try {
            int j = 0;
            while (j < rowLength) {
                String str = this.tableItem.getText(j + 1);
                if (str.equals("  ")) {
                    stringData.append("                ".substring(j));
                    break;
                }
                hexData[0] = Utils.string2byte((String)str);
                str = new String(hexData, encoding);
                stringData.append(Character.isWhitespace(str.charAt(0)) && !Character.isSpaceChar(str.charAt(0)) || Character.isISOControl(str.charAt(0)) ? "." : str);
                str = null;
                ++j;
            }
            this.tableItem.setText(16, stringData.toString());
            stringData = null;
        }
        catch (UnsupportedEncodingException e) {
            MessageDialog.openWarning((Shell)this.parent.getShell(), (String)"Frame Error", (String)("Exception in displayCharacterView(), encoding = " + encoding + ":\n" + e.toString()));
            return false;
        }
        return true;
    }
}

