/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.multicast;

import com.excentis.products.byteblower.gui.views.editors.AbstractCellModifier;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastGroupComposite;
import com.excentis.products.byteblower.model.MulticastGroup;
import com.excentis.products.byteblower.model.control.MulticastGroupController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.reader.MulticastGroupReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.swt.widgets.TableItem;

public class MulticastCellModifier
extends AbstractCellModifier {
    private MulticastGroupComposite composite;

    public MulticastCellModifier(MulticastGroupComposite composite) {
        this.composite = composite;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    private MulticastGroupReader getReader(Object element) {
        MulticastGroup group = (MulticastGroup)element;
        return ReaderFactory.create((MulticastGroup)group);
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.composite.getColumnIndex(property);
        MulticastGroupReader reader = this.getReader(element);
        switch (columnIndex) {
            case 0: {
                return reader.getName();
            }
            case 1: {
                return reader.getIpAddress();
            }
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        Object itemData = null;
        if (element instanceof TableItem) {
            TableItem tableItem = (TableItem)element;
            itemData = tableItem.getData();
        }
        if (!(itemData instanceof MulticastGroup)) {
            return;
        }
        MulticastGroup multicastGroup = (MulticastGroup)itemData;
        MulticastGroupController multicastGroupController = MulticastGroupController.createInstance((MulticastGroup)multicastGroup);
        switch (this.composite.getColumnIndex(property)) {
            case 0: {
                if (!(value instanceof String)) break;
                this.runUndoableOperation("Change Multicast Group name", multicastGroupController.setName((String)value));
                break;
            }
            case 1: {
                if (!(value instanceof NetworkAddressBytes)) break;
                this.runUndoableOperation("Change Multicast Group IP address", multicastGroupController.setMulticastIpAddress((NetworkAddressBytes)value));
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid column index.");
            }
        }
    }
}

