/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.multicast;

import com.excentis.products.byteblower.gui.views.editors.AbstractCellModifier;
import com.excentis.products.byteblower.gui.views.multicast.composites.MulticastSourceIpAddressesComposite;
import com.excentis.products.byteblower.model.IpAddress;
import com.excentis.products.byteblower.model.MulticastSourceGroup;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.MulticastSourceGroupController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.widgets.TableItem;

public class MulticastSourceGroupIpCellModifier
extends AbstractCellModifier {
    private MulticastSourceIpAddressesComposite composite;

    public MulticastSourceGroupIpCellModifier(MulticastSourceIpAddressesComposite composite) {
        this.composite = composite;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        switch (this.composite.getColumnIndex(property)) {
            case 0: {
                if (element instanceof IpAddress) {
                    return (IpAddress)element;
                }
                return null;
            }
        }
        throw new AssertionError((Object)"Invalid column index.");
    }

    public void modify(Object element, String property, Object value) {
        if (value == null) {
            return;
        }
        switch (this.composite.getColumnIndex(property)) {
            case 0: {
                Command newCommand;
                if (!(value instanceof NetworkAddressBytes)) break;
                Object itemData = null;
                if (element instanceof TableItem) {
                    TableItem tableItem = (TableItem)element;
                    itemData = tableItem.getData();
                }
                if (!(itemData instanceof IpAddress)) {
                    return;
                }
                IpAddress currentIpAddress = (IpAddress)itemData;
                MulticastSourceGroup multicastSourceGroup = this.composite.getSelectedMulticastSourceGroup();
                MulticastSourceGroupController multicastSourceGroupController = ControllerFactory.create((MulticastSourceGroup)multicastSourceGroup);
                try {
                    newCommand = multicastSourceGroupController.setIpAddress(currentIpAddress, (NetworkAddressBytes)value);
                }
                catch (IllegalArgumentException e) {
                    System.err.println("Caught Exception while Updating Multicast Source Group `" + multicastSourceGroupController.getName() + "' Ip Address:");
                    e.printStackTrace(System.err);
                    break;
                }
                this.runUndoableOperation("Change Multicast Source Group IP Address", newCommand);
                break;
            }
            default: {
                throw new AssertionError((Object)"Invalid column index.");
            }
        }
    }
}

