/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.views.dhcp.DhcpView;
import com.excentis.products.byteblower.gui.views.port.composites.Ipv6PortComposite;
import com.excentis.products.byteblower.gui.views.vlan.VlanView;
import com.excentis.products.byteblower.gui.widgets.composites.YesNoCellEditor;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv6Configuration;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerPortGroupController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.EthernetConfigurationController;
import com.excentis.products.byteblower.model.control.Ipv6ConfigurationController;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.VlanStackController;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.ByteBlowerPortGroupReader;
import com.excentis.products.byteblower.model.reader.Ipv6ConfigurationReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.List;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.swt.widgets.TreeItem;

public class ByteBlowerIpv6PortCellModifier
implements ICellModifier {
    private Ipv6PortComposite ipv6Composite;

    public ByteBlowerIpv6PortCellModifier(Ipv6PortComposite ipv6Composite) {
        this.ipv6Composite = ipv6Composite;
    }

    public boolean canModify(Object element, String property) {
        int columnIndex = this.ipv6Composite.getColumnIndex(property);
        if (element instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)element));
            boolean isDockedOnMobileDevice = reader.isDockedOnMobileDevice();
            switch (columnIndex) {
                case 1: 
                case 2: {
                    return !isDockedOnMobileDevice;
                }
                case 3: 
                case 4: 
                case 5: {
                    if (isDockedOnMobileDevice) {
                        return false;
                    }
                    if (reader.isActiveLayer3Configuration(SupportedLayer3Configuration.IPV6)) {
                        return reader.getIpv6ConfigurationReader().usesFixedAdress();
                    }
                    return false;
                }
                case 6: {
                    return true;
                }
                case 7: 
                case 8: {
                    if (!isDockedOnMobileDevice) break;
                    return false;
                }
            }
            return true;
        }
        if (element instanceof ByteBlowerPortGroup) {
            switch (columnIndex) {
                case 0: {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.ipv6Composite.getColumnIndex(property);
        if (element instanceof ByteBlowerGuiPort) {
            ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)((ByteBlowerGuiPort)element));
            Ipv6ConfigurationReader ipv6ConfigReader = reader.getIpv6ConfigurationReader();
            switch (columnIndex) {
                case 0: {
                    return reader.getName();
                }
                case 1: {
                    return reader.getMacAddressReader();
                }
                case 2: {
                    return reader.getDhcpv6();
                }
                case 3: {
                    return ipv6ConfigReader.getAddressReader().getObject();
                }
                case 4: {
                    return ipv6ConfigReader.getDefaultRouterReader().getObject();
                }
                case 5: {
                    return ipv6ConfigReader.getPrefixLength();
                }
                case 6: {
                    return YesNoCellEditor.toValue((boolean)reader.isNatted());
                }
                case 7: {
                    return reader.getVlanStack();
                }
                case 8: {
                    return reader.getMtuInteger();
                }
                case 9: {
                    return reader.getObject();
                }
            }
        } else if (element instanceof ByteBlowerPortGroup) {
            ByteBlowerPortGroupReader reader = ReaderFactory.create((ByteBlowerPortGroup)((ByteBlowerPortGroup)element));
            switch (columnIndex) {
                case 0: {
                    return reader.getName();
                }
            }
            return false;
        }
        return null;
    }

    public void modify(Object element, String property, Object value) {
        UndoableByteBlowerControllerOperation operation;
        block40: {
            ByteBlowerProject project;
            Object itemData;
            int columnIndex;
            block39: {
                columnIndex = this.ipv6Composite.getColumnIndex(property);
                TreeItem item = (TreeItem)element;
                itemData = item.getData();
                operation = null;
                project = ByteBlowerGuiResourceController.getProject();
                if (!(itemData instanceof ByteBlowerGuiPort)) break block39;
                ByteBlowerGuiPort byteblowerGuiPort = (ByteBlowerGuiPort)itemData;
                Ipv6Configuration modifyIpv6Configuration = byteblowerGuiPort.getIpv6Configuration();
                ByteBlowerGuiPortController portController = new ByteBlowerGuiPortController(byteblowerGuiPort);
                switch (columnIndex) {
                    case 0: {
                        if (value instanceof String) {
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change Port Name", portController.checkAndSetName((String)value));
                        }
                        break block40;
                    }
                    case 1: {
                        if (value instanceof NetworkAddressBytes) {
                            EthernetConfigurationController ethernetConfigurationController = new EthernetConfigurationController((EthernetConfiguration)byteblowerGuiPort.getLayer2Configuration());
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change MAC Address", ethernetConfigurationController.setMacAddress((NetworkAddressBytes)value));
                        }
                        break block40;
                    }
                    case 2: {
                        Ipv6ConfigurationController configController = portController.getIpv6ConfigurationController();
                        if (value instanceof Dhcp) {
                            Dhcp dhcp = (Dhcp)value;
                            operation = new UndoableByteBlowerControllerOperation(project, "Change DHCPv6", configController.setDhcpv6(dhcp));
                        } else if (value instanceof String) {
                            String dhcpOption = (String)value;
                            if (dhcpOption.equals("Fixed")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Set Configuration Fixed", configController.setFixed());
                            } else if (dhcpOption.equals("Auto Configuration")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Set Auto Configuration ", configController.setAuto());
                            } else if (dhcpOption.equals("New Dhcp...")) {
                                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                                ByteBlowerProjectController.CommandWithDhcpListReference commandWithDhcpListReference = projectController.addDhcp();
                                CompoundCommandController compoundController = CompoundCommandController.createInstance();
                                compoundController.appendCommand(commandWithDhcpListReference.getCommand());
                                final Dhcp newDhcp = (Dhcp)((DhcpController)((List)commandWithDhcpListReference.getCommandReference()).get(0)).getObject();
                                compoundController.appendCommand(configController.setDhcpv6(newDhcp));
                                operation = new UndoableByteBlowerControllerOperation(project, "New DHCPv6", compoundController.unwrap());
                                operation.addAfterOperationListener(new IAfterOperationListener(){

                                    public void afterOperation(UndoableByteBlowerOperation operation) {
                                        DhcpView.showAndSelect(newDhcp);
                                    }
                                });
                            } else {
                                System.err.println("ByteBlowerIpv4PortCellModifier : invalid DHCP option !");
                            }
                        }
                        break block40;
                    }
                    case 3: {
                        if (value instanceof NetworkAddressBytes) {
                            Ipv6ConfigurationController ipv6ConfigurationController = new Ipv6ConfigurationController(modifyIpv6Configuration);
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change IPv6 Address", ipv6ConfigurationController.setIpAddress((NetworkAddressBytes)value));
                        }
                        break block40;
                    }
                    case 4: {
                        if (value instanceof NetworkAddressBytes) {
                            Ipv6ConfigurationController ipv6ConfigurationController = new Ipv6ConfigurationController(modifyIpv6Configuration);
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "IPv6 Router Address", ipv6ConfigurationController.setDefaultRouter((NetworkAddressBytes)value));
                        }
                        break block40;
                    }
                    case 5: {
                        if (value instanceof Integer) {
                            Ipv6ConfigurationController ipv6ConfigurationController = new Ipv6ConfigurationController(modifyIpv6Configuration);
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change IPv6 Prefix", ipv6ConfigurationController.setPrefixLength((Integer)value));
                        }
                        break block40;
                    }
                    case 6: {
                        operation = value instanceof Integer && YesNoCellEditor.fromValue((int)((Integer)value)) ? new UndoableByteBlowerControllerOperation(project, "Enable IPv6 firewall", portController.setNatAutomaticDiscovery()) : new UndoableByteBlowerControllerOperation(project, "No Ipv6 firewall", portController.clearNat());
                        break block40;
                    }
                    case 7: {
                        if (value instanceof VlanStack) {
                            VlanStack vlanStack = (VlanStack)value;
                            operation = new UndoableByteBlowerControllerOperation(project, "Change VLAN Stack", portController.setVlanStack((Object)vlanStack).getCommand());
                        } else if (value instanceof String) {
                            String vlanOption = (String)value;
                            if (vlanOption.equals("No")) {
                                operation = new UndoableByteBlowerControllerOperation(project, "Change VLAN", portController.clearVlanStack().getCommand());
                            } else if (vlanOption.equals("New VLAN Stack...")) {
                                ByteBlowerProjectController projectController = new ByteBlowerProjectController(project);
                                ByteBlowerProjectController.CommandWithVlanStackListReference commandWithVlanStackListReference = projectController.addVlanStack();
                                CompoundCommandController compoundController = CompoundCommandController.createInstance();
                                compoundController.appendCommand(commandWithVlanStackListReference.getCommand());
                                final VlanStack newVlanStack = (VlanStack)((VlanStackController)((List)commandWithVlanStackListReference.getCommandReference()).get(0)).getObject();
                                compoundController.appendCommand(portController.setVlanStack((Object)newVlanStack).getCommand());
                                operation = new UndoableByteBlowerControllerOperation(project, "New VLAN Stack", compoundController.unwrap());
                                operation.addAfterOperationListener(new IAfterOperationListener(){

                                    public void afterOperation(UndoableByteBlowerOperation operation) {
                                        VlanView.showAndSelect(newVlanStack);
                                    }
                                });
                            } else {
                                System.err.println("ByteBlowerIpv6PortCellModifier : invalid VLAN option !");
                            }
                        }
                        break block40;
                    }
                    case 8: {
                        if (value instanceof Integer) {
                            operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Change MTU", portController.setMTU(Long.valueOf(((Integer)value).longValue())));
                        }
                        break block40;
                    }
                    case 9: {
                        break block40;
                    }
                    default: {
                        System.out.println("ByteBlowerIpv6PortCellModifier : invalid case !");
                        return;
                    }
                }
            }
            if (itemData instanceof ByteBlowerPortGroup) {
                switch (columnIndex) {
                    case 0: {
                        if (!(value instanceof String)) break;
                        ByteBlowerPortGroup group = (ByteBlowerPortGroup)itemData;
                        ByteBlowerPortGroupController controller = ControllerFactory.create((ByteBlowerPortGroup)group);
                        operation = new UndoableByteBlowerControllerOperation(project, "Change Group Name", controller.checkAndSetName((String)value));
                    }
                }
            }
        }
        if (operation != null) {
            operation.run();
        }
    }
}

