/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port;

import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class DHCPv4CellEditor
extends ComboBoxCellEditor
implements SelectionListener {
    private TreeViewer treeViewer;
    static final String DHCP_EDITOR_OPTION_FIXED = "Fixed";
    static final String DHCP_EDITOR_OPTION_NEW = "New Dhcp...";
    private static final int NOF_FIXED_ITEMS = 2;
    private static final int POS_FIXED = 0;
    private static final int POS_ITEMS = 1;

    protected Control createControl(Composite parent) {
        Control control = super.createControl(parent);
        CCombo combo = (CCombo)control;
        combo.addSelectionListener((SelectionListener)this);
        return control;
    }

    public DHCPv4CellEditor(TreeViewer treeViewer) {
        super((Composite)treeViewer.getTree(), new String[0], 0);
        this.treeViewer = treeViewer;
        this.setActivationStyle(1);
    }

    private String[] getItemList() {
        ByteBlowerGuiPort selectedPort = (ByteBlowerGuiPort)((StructuredSelection)this.treeViewer.getSelection()).getFirstElement();
        ByteBlowerProject project = selectedPort.getByteBlowerProject();
        EList dhcps = project.getDhcp();
        int itemCount = dhcps.size();
        String[] names = new String[2 + itemCount];
        names[0] = DHCP_EDITOR_OPTION_FIXED;
        int i = 1;
        for (Dhcp dhcp : dhcps) {
            names[i++] = dhcp.getName();
        }
        names[i] = DHCP_EDITOR_OPTION_NEW;
        return names;
    }

    public Object doGetValue() {
        Object superValue = super.doGetValue();
        Integer intValue = (Integer)superValue;
        Object returnValue = DHCP_EDITOR_OPTION_FIXED;
        int index = intValue;
        if (index > 0) {
            EList<Dhcp> allDhcps = this.getAllDhcps();
            returnValue = --index < allDhcps.size() ? this.getAllDhcps().get(index) : DHCP_EDITOR_OPTION_NEW;
        }
        return returnValue;
    }

    protected void doSetValue(Object value) {
        int index = 0;
        if (value != null) {
            Dhcp dhcp = (Dhcp)value;
            index = this.getAllDhcps().indexOf((Object)dhcp) + 1;
        }
        this.setItems(this.getItemList());
        super.doSetValue((Object)index);
    }

    private EList<Dhcp> getAllDhcps() {
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        ByteBlowerProject project = (ByteBlowerProject)projectController.getObject();
        return project.getDhcp();
    }

    public void widgetDefaultSelected(SelectionEvent arg0) {
    }

    public void widgetSelected(SelectionEvent selectionEvent) {
        if (this.doGetValue() == DHCP_EDITOR_OPTION_NEW) {
            this.focusLost();
        }
    }
}

