/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.port.dnd;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerOperation;
import com.excentis.products.byteblower.gui.history.operations.after.IAfterOperationListener;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.dnd.ByteBlowerDropAdapter;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerPortGroup;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.SupportedLayer3Configuration;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.domain.ByteBlowerEditingDomainProvider;
import com.excentis.products.byteblower.model.domain.IByteBlowerEditingDomain;
import com.excentis.products.byteblower.model.reader.ByteBlowerGuiPortReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.model.reader.impl.ByteBlowerGuiPortReaderImpl;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.AddCommand;
import org.eclipse.emf.edit.command.MoveCommand;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;

public class PortTableDropAdapter
extends ByteBlowerDropAdapter
implements IAfterOperationListener {
    private SupportedLayer3Configuration supportedLayer3Configuration;

    public PortTableDropAdapter(Viewer viewer, Class<?> dropClass, SupportedLayer3Configuration mySupportedLayer3Configuration) {
        super(viewer, dropClass);
        this.supportedLayer3Configuration = mySupportedLayer3Configuration;
    }

    public void dragOver(DropTargetEvent event) {
        TreeItem item;
        Widget widget = event.item;
        Object itemData = null;
        if (widget instanceof TreeItem && (item = (TreeItem)widget) != null) {
            itemData = item.getData();
        }
        this.updateDropInfo(itemData);
    }

    private void updateDropInfo(Object itemData) {
        this.dropParent = ByteBlowerGuiResourceController.getProject();
        if (itemData != null) {
            if (itemData instanceof ByteBlowerGuiPort) {
                ByteBlowerGuiPort dropPort = (ByteBlowerGuiPort)itemData;
                ByteBlowerGuiPortReader reader = ReaderFactory.create((ByteBlowerGuiPort)dropPort);
                if (reader.isPartOfGroup()) {
                    this.dropIndex = reader.getGroup().getMembers().indexOf((Object)dropPort);
                    this.dropParent = reader.getGroup();
                } else {
                    this.dropIndex = ReaderFactory.getIndexInContainer((EByteBlowerObject)dropPort);
                }
            } else if (itemData instanceof ByteBlowerPortGroup) {
                ByteBlowerPortGroup dropGroup = (ByteBlowerPortGroup)itemData;
                this.dropIndex = ReaderFactory.getIndexInContainer((EByteBlowerObject)dropGroup);
                this.dropParent = dropGroup;
            }
        }
    }

    public boolean validateDrop(Object target, int operation, TransferData transferType) {
        return true;
    }

    public boolean performDrop(Object data) {
        if (data == null) {
            return false;
        }
        StructuredSelection portData = (StructuredSelection)data;
        Command command = PortTableDropAdapter.drop(portData.toList(), this.dropIndex, this.dropParent, this.supportedLayer3Configuration);
        if (command == null) {
            return false;
        }
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), portData.size() > 1 ? "Move Ports" : "Move Port", command);
        operation.run();
        return true;
    }

    public static Command drop(List<?> portData, int dropIndex, EObject dropParent, SupportedLayer3Configuration layer3) {
        ByteBlowerProject dropProject;
        int localDropIndex = dropIndex;
        UniqueEList portsList = new UniqueEList();
        UniqueEList groupList = new UniqueEList();
        try {
            for (Object draggedObject : portData) {
                if (draggedObject instanceof ByteBlowerGuiPort) {
                    portsList.add((Object)((ByteBlowerGuiPort)draggedObject));
                    continue;
                }
                if (draggedObject instanceof ByteBlowerGuiPortConfiguration) {
                    portsList.add((Object)((ByteBlowerGuiPortConfiguration)draggedObject).getByteBlowerGuiPort());
                    continue;
                }
                if (!(draggedObject instanceof ByteBlowerPortGroup)) continue;
                groupList.add((Object)((ByteBlowerPortGroup)draggedObject));
            }
        }
        catch (Exception exception) {
            localDropIndex = 0;
        }
        CompoundCommandController compound = CompoundCommandController.createInstance();
        IByteBlowerEditingDomain editingDomain = ByteBlowerEditingDomainProvider.getByteBlowerEditingDomain();
        if (!portsList.isEmpty()) {
            ByteBlowerGuiPortReader reader;
            if (dropParent instanceof ByteBlowerProject) {
                dropProject = (ByteBlowerProject)dropParent;
                for (Iterator port : portsList) {
                    reader = ReaderFactory.create((ByteBlowerGuiPort)port);
                    if (reader.isPartOfGroup()) {
                        compound.appendCommand(RemoveCommand.create((EditingDomain)editingDomain, (Object)reader.getGroup(), (Object)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, (Object)port));
                    }
                    compound.appendCommand(MoveCommand.create((EditingDomain)editingDomain, (Object)dropProject, (Object)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PROJECT__BYTE_BLOWER_GUI_PORT, (Object)port, (int)localDropIndex));
                }
            } else if (dropParent instanceof ByteBlowerPortGroup) {
                ByteBlowerPortGroup dropGroup = (ByteBlowerPortGroup)dropParent;
                for (Iterator port : portsList) {
                    reader = ReaderFactory.create((ByteBlowerGuiPort)port);
                    boolean add = true;
                    if (reader.isPartOfGroup()) {
                        ByteBlowerPortGroup group = reader.getGroup();
                        if (group == dropGroup) {
                            add = false;
                            compound.appendCommand(MoveCommand.create((EditingDomain)editingDomain, (Object)group, (Object)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, (Object)port, (int)localDropIndex));
                        } else {
                            compound.appendCommand(RemoveCommand.create((EditingDomain)editingDomain, (Object)group, (Object)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, (Object)port));
                        }
                    }
                    if (!add) continue;
                    compound.appendCommand(AddCommand.create((EditingDomain)editingDomain, (Object)dropGroup, (Object)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PORT_GROUP__MEMBERS, (Object)port, (int)localDropIndex));
                }
            }
            for (ByteBlowerGuiPort byteblowerGuiPort : portsList) {
                ByteBlowerGuiPortReaderImpl reader2 = new ByteBlowerGuiPortReaderImpl(byteblowerGuiPort);
                if (reader2.isActiveLayer3Configuration(layer3)) continue;
                ByteBlowerGuiPortController byteblowerGuiPortController = new ByteBlowerGuiPortController(byteblowerGuiPort);
                compound.appendCommand(byteblowerGuiPortController.switchLayer3(layer3));
            }
        }
        if (!groupList.isEmpty() && dropParent instanceof ByteBlowerProject) {
            dropProject = (ByteBlowerProject)dropParent;
            int nofGroups = dropProject.getPortGroup().size();
            if (localDropIndex >= nofGroups) {
                localDropIndex = nofGroups - 1;
            }
            for (ByteBlowerPortGroup group : groupList) {
                compound.appendCommand(MoveCommand.create((EditingDomain)editingDomain, (Object)dropProject, (Object)ByteblowerguimodelPackage.Literals.BYTE_BLOWER_PROJECT__PORT_GROUP, (Object)group, (int)localDropIndex));
                for (ByteBlowerGuiPort member : group.getMembers()) {
                    ByteBlowerGuiPortReaderImpl reader = new ByteBlowerGuiPortReaderImpl(member);
                    if (reader.isActiveLayer3Configuration(layer3)) continue;
                    ByteBlowerGuiPortController byteblowerGuiPortController = new ByteBlowerGuiPortController(member);
                    compound.appendCommand(byteblowerGuiPortController.switchLayer3(layer3));
                }
            }
        }
        return compound.unwrap();
    }

    public void afterOperation(UndoableByteBlowerOperation operation) {
        Viewer viewer = this.getViewer();
        if (!viewer.getControl().isDisposed()) {
            viewer.refresh();
        }
    }
}

