/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.portforwarding;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.views.editors.AbstractCellModifier;
import com.excentis.products.byteblower.gui.views.portforwarding.composites.PortForwardingComposite;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.PortForwarding;
import com.excentis.products.byteblower.model.PortForwardingProtocol;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.NetworkAddressBytes;
import com.excentis.products.byteblower.model.control.PortForwardingController;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.TableItem;

public class PortForwardingCellModifier
extends AbstractCellModifier {
    private PortForwardingComposite portForwardingComposite;

    public PortForwardingCellModifier(PortForwardingComposite PortForwardingView2) {
        this.portForwardingComposite = PortForwardingView2;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.portForwardingComposite.getColumnIndex(property);
        Object result = null;
        PortForwarding portForwarding = (PortForwarding)element;
        switch (columnIndex) {
            case 0: {
                result = portForwarding.getName();
                break;
            }
            case 1: {
                result = portForwarding.isAutomaticPublicIpv4();
                break;
            }
            case 2: {
                result = portForwarding.getAutomaticPublicIpv4ProbePort();
                break;
            }
            case 3: {
                result = portForwarding.getAutomaticPublicIpv4ProbeProtocol();
                break;
            }
            case 4: {
                result = portForwarding.getManualPublicIpv4();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.portForwardingComposite.getColumnIndex(property);
        TableItem item = (TableItem)element;
        PortForwarding portForwarding = (PortForwarding)item.getData();
        PortForwardingController controller = ControllerFactory.create((PortForwarding)portForwarding);
        if (value == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                String newName = ((String)value).trim();
                if (!OldNamingTools.nameIsUnique((EObject)portForwarding, (String)newName)) break;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Port Forwarding", (EByteBlowerObject)portForwarding, ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME, (Object)newName);
                operation.run();
                break;
            }
            case 1: {
                Boolean automatic = (Boolean)value;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Port Forwarding", (EByteBlowerObject)portForwarding, ByteblowerguimodelPackage.Literals.PORT_FORWARDING__AUTOMATIC_PUBLIC_IPV4, (Object)automatic);
                operation.run();
                break;
            }
            case 2: {
                Integer port = (Integer)value;
                ByteBlowerSetOperation operation = new ByteBlowerSetOperation("Change Port Forwarding", (EByteBlowerObject)portForwarding, ByteblowerguimodelPackage.Literals.PORT_FORWARDING__AUTOMATIC_PUBLIC_IPV4_PROBE_PORT, (Object)port);
                operation.run();
                break;
            }
            case 3: {
                PortForwardingProtocol protocol = (PortForwardingProtocol)value;
                this.runUndoableOperation("Change Port Forwarding", controller.setAutomaticDiscoveryProtocol(protocol));
                break;
            }
            case 4: {
                NetworkAddressBytes address = (NetworkAddressBytes)value;
                this.runUndoableOperation("Change Port Forwarding", controller.setManualPublicIpAddress(address));
                break;
            }
            default: {
                System.out.println("invalid case !");
                return;
            }
        }
    }
}

