/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.portforwarding;

import com.excentis.products.byteblower.gui.views.editors.AbstractCellModifier;
import com.excentis.products.byteblower.gui.views.portforwarding.composites.PortMappingComposite;
import com.excentis.products.byteblower.model.PortForwardingProtocol;
import com.excentis.products.byteblower.model.PortMapping;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.PortMappingController;
import org.eclipse.swt.widgets.TableItem;

public class PortMappingCellModifier
extends AbstractCellModifier {
    private PortMappingComposite portMappingComposite;

    public PortMappingCellModifier(PortMappingComposite PortMappingView) {
        this.portMappingComposite = PortMappingView;
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.portMappingComposite.getColumnIndex(property);
        Object result = null;
        PortMapping portMapping = (PortMapping)element;
        switch (columnIndex) {
            case 0: {
                result = portMapping.getPrivatePort();
                break;
            }
            case 1: {
                result = portMapping.getPublicPort();
                break;
            }
            case 2: {
                result = portMapping.getProtocol();
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.portMappingComposite.getColumnIndex(property);
        TableItem item = (TableItem)element;
        PortMapping portMapping = (PortMapping)item.getData();
        PortMappingController controller = ControllerFactory.create((PortMapping)portMapping);
        if (value == null) {
            return;
        }
        switch (columnIndex) {
            case 0: {
                Integer port = (Integer)value;
                this.runUndoableOperation("Change Port Mapping", controller.setPrivatePort(port));
                break;
            }
            case 1: {
                Integer port = (Integer)value;
                this.runUndoableOperation("Change Port Mapping", controller.setPublicPort(port));
                break;
            }
            case 2: {
                PortForwardingProtocol protocol = (PortForwardingProtocol)value;
                this.runUndoableOperation("Change Port Mapping", controller.setProtocol(protocol));
                break;
            }
            default: {
                System.out.println("invalid case !");
                return;
            }
        }
    }
}

