/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.scenario.composites;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.NameCellEditor;
import com.excentis.products.byteblower.gui.runner.GuiRunner;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerRunTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerTablePopupMenu;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerCopyDownAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerRunAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.IByteBlowerTableViewer;
import com.excentis.products.byteblower.gui.views.Messages;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioCellModifier;
import com.excentis.products.byteblower.gui.views.scenario.actions.CopyScenarioAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.CutScenarioAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.DeleteScenarioAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.NewScenarioAction;
import com.excentis.products.byteblower.gui.views.scenario.actions.PasteScenarioAction;
import com.excentis.products.byteblower.gui.views.scenario.composites.RunPopupMenu;
import com.excentis.products.byteblower.gui.views.scenario.composites.ScenarioComparator;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.reader.ScenarioReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;

public class ScenarioComposite
extends ByteBlowerRunTableComposite<Scenario> {
    private static final String[] COLUMN_NAMES = new String[]{Messages.getString("ScenarioView.Column.Name"), Messages.getString("ScenarioView.Column.Duration")};
    private static final int[] COLUMN_WEIGHTS = new int[]{1, 1};
    private Scenario currentSelection;
    private Adapter statusUpdateAdapter = new StatusUpdateAdapter();

    protected ByteBlowerTablePopupMenu createPopupMenu() {
        return new RunPopupMenu(this.getShell(), this.actionInterface, (IByteBlowerRunAction)this, (IByteBlowerCopyDownAction)this, (IByteBlowerTableViewer)this.getTableViewer());
    }

    public ScenarioComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher) {
        super(parent, "ScenarioComposite", actionInterface, focusDispatcher);
        this.addSelectionListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Scenario newScenario = (Scenario)selection.getFirstElement();
                if (newScenario == ScenarioComposite.this.currentSelection) {
                    return;
                }
                if (ScenarioComposite.this.currentSelection != null) {
                    ScenarioController oldScenarioController = ControllerFactory.create((Scenario)ScenarioComposite.this.currentSelection);
                    oldScenarioController.removeAdapter(ScenarioComposite.this.statusUpdateAdapter);
                }
                if (newScenario != null) {
                    ScenarioController newScenarioController = ControllerFactory.create((Scenario)newScenario);
                    newScenarioController.addAdapter(ScenarioComposite.this.statusUpdateAdapter);
                }
                ScenarioComposite.this.currentSelection = newScenario;
            }
        });
        this.currentSelection = (Scenario)this.getFirstSelectedObject();
        GuiRunner.getInstance().addListener(new GuiRunner.ActiveJobListener(){

            public void activeScenarioJobChanged() {
                ScenarioComposite.this.updateRunButton();
            }

            public void activeScenarioPaused(GuiRunner.Resumer resume) {
            }

            public void activeScenarioResumed() {
            }
        });
    }

    public void doJump() {
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[COLUMN_NAMES.length];
        NameCellEditor nameEditor = new NameCellEditor((Composite)table);
        editors[0] = nameEditor;
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new ScenarioCellModifier(this);
    }

    protected int[] getColumnWeights() {
        return COLUMN_WEIGHTS;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return ByteBlowerProject.class;
    }

    public int getChildFeatureId() {
        return 5;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Scenario.class;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
    }

    protected String getTableLabel() {
        return "Scenarios:";
    }

    protected String[] getColumnNames() {
        return COLUMN_NAMES;
    }

    public boolean isCopyDownEnabled() {
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        return this.getCurrentColumn() == 0;
    }

    public boolean isCopyDownDecEnabled() {
        return false;
    }

    public Object getInitialInput() {
        return this.getProject();
    }

    public void doRun() {
        Scenario scenario = this.getSelectedScenario();
        if (scenario == null) {
            System.out.println("Scenario is null");
            return;
        }
        GuiRunner.getInstance().scheduleScenario(scenario);
    }

    public boolean isRunEnabled() {
        boolean canRun;
        boolean bl = canRun = !GuiRunner.getInstance().isRunning();
        if (!canRun) {
            return false;
        }
        Scenario selectedScenario = this.getSelectedScenario();
        if (selectedScenario == null) {
            return false;
        }
        ScenarioReader reader = ReaderFactory.create((Scenario)selectedScenario);
        return !reader.hasErrorStatus();
    }

    private Scenario getSelectedScenario() {
        return (Scenario)this.getFirstSelectedObject();
    }

    protected String getRunButtonText() {
        return "Run";
    }

    protected String getRunButtonTooltipText() {
        return "Run Selected Scenario";
    }

    protected ByteBlowerNewAction<Scenario> createNewAction() {
        return new NewScenarioAction(this);
    }

    protected ByteBlowerCutAction<Scenario> createCutAction() {
        return new CutScenarioAction(this);
    }

    protected ByteBlowerCopyAction<Scenario> createCopyAction() {
        return new CopyScenarioAction(this);
    }

    protected ByteBlowerPasteAction<Scenario> createPasteAction() {
        return new PasteScenarioAction(this);
    }

    protected ByteBlowerDeleteAction<Scenario> createDeleteAction() {
        return new DeleteScenarioAction(this);
    }

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        return new ScenarioComparator(columnViewer);
    }

    private class StatusUpdateAdapter
    extends AdapterImpl {
        private StatusUpdateAdapter() {
        }

        public void notifyChanged(Notification notification) {
            switch (notification.getFeatureID(Scenario.class)) {
                case 1: {
                    ScenarioComposite.this.updateRunButton();
                    return;
                }
            }
        }
    }
}

