/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.scenario.dnd;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerMoveOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.dnd.ByteBlowerDropAdapter;
import com.excentis.products.byteblower.model.FlowMeasurement;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.reader.impl.FlowMeasurementReaderImpl;
import com.excentis.products.byteblower.model.reader.impl.ScenarioReaderImpl;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;

public class FlowMeasurementTableDropAdapter
extends ByteBlowerDropAdapter {
    private EList<FlowMeasurement> getFlowMeasurements(Scenario scenario) {
        ScenarioReaderImpl reader = new ScenarioReaderImpl(scenario);
        return reader.getFlowMeasurements();
    }

    public FlowMeasurementTableDropAdapter(Viewer viewer, Class<?> dropClass) {
        super(viewer, dropClass);
    }

    public boolean performDrop(Object data) {
        StructuredSelection draggedData = (StructuredSelection)data;
        int nofDraggedObjects = draggedData.size();
        int localDropIndex = this.dropIndex;
        if (nofDraggedObjects == 0) {
            return false;
        }
        FlowMeasurement firstFlowMeasurement = (FlowMeasurement)draggedData.getFirstElement();
        Scenario scenario = firstFlowMeasurement.getScenario();
        EList<FlowMeasurement> scenarioActions = this.getFlowMeasurements(scenario);
        FlowMeasurement dropFlowMeasurement = (FlowMeasurement)scenarioActions.get(localDropIndex);
        ByteBlowerMoveOperation operation = new ByteBlowerMoveOperation(ByteBlowerGuiResourceController.getProject(), "Move Scenario Action" + (nofDraggedObjects > 1 ? "s" : ""));
        FlowMeasurementReaderImpl reader = new FlowMeasurementReaderImpl(dropFlowMeasurement);
        HighResolutionCalendar newTime = reader.getStartTime();
        for (Object draggedObject : draggedData) {
            if (!this.dropClass.isInstance(draggedObject)) continue;
            FlowMeasurement draggedFlowMeasurement = (FlowMeasurement)draggedObject;
            FlowMeasurementController controller = ControllerFactory.create((FlowMeasurement)draggedFlowMeasurement);
            operation.appendCommand(controller.delayStartTime(newTime));
        }
        operation.run();
        return true;
    }
}

