/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.tcp;

import com.excentis.products.byteblower.gui.history.operations.ByteBlowerSetOperation;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.ByteBlowerCellModifier;
import com.excentis.products.byteblower.gui.views.tcp.RateLimit;
import com.excentis.products.byteblower.gui.views.tcp.TcpComposite;
import com.excentis.products.byteblower.gui.views.tcp.TcpPayload;
import com.excentis.products.byteblower.model.ByteblowerguimodelPackage;
import com.excentis.products.byteblower.model.DataRateUnit;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.HTTPMethod;
import com.excentis.products.byteblower.model.PayloadUnit;
import com.excentis.products.byteblower.model.TCPCongestionAvoidanceAlgorithm;
import com.excentis.products.byteblower.model.TcpFlow;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.TcpFlowController;
import com.excentis.products.byteblower.model.provider.TcpFlowItemProvider;
import com.excentis.products.byteblower.model.reader.TcpFlowReader;
import com.excentis.products.byteblower.model.util.OldNamingTools;
import java.math.BigInteger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.TableItem;

class TcpCellModifier
extends ByteBlowerCellModifier {
    public TcpCellModifier(TcpComposite parent) {
        super((ByteBlowerModelTableComposite<?>)parent);
    }

    public boolean canModify(Object element, String property) {
        return true;
    }

    public Object getValue(Object element, String property) {
        int columnIndex = this.getColumnIndex(property);
        Object result = null;
        TcpFlow tcp = (TcpFlow)element;
        switch (columnIndex) {
            case 0: {
                result = tcp.getName();
                break;
            }
            case 1: {
                String payloadSize = tcp.getPayloadSize();
                float payload = payloadSize.equals("Unlimited") ? 0.0f : Float.valueOf(payloadSize).floatValue();
                PayloadUnit payloadUnit = tcp.getPayloadUnit();
                result = new TcpPayload(payload, payloadUnit);
                break;
            }
            case 2: {
                float throughput = tcp.getRateLimit();
                DataRateUnit unit = tcp.getRateLimitUnit();
                result = new RateLimit(throughput, unit);
                break;
            }
            case 3: {
                result = new BigInteger(tcp.getWindowSize());
                break;
            }
            case 4: {
                result = tcp.isWindowScaling();
                break;
            }
            case 5: {
                result = (int)new Integer(tcp.getRcvWindowScale());
                break;
            }
            case 6: {
                result = Integer.toString(tcp.getSlowStart());
                break;
            }
            case 7: {
                result = tcp.getHTTPMethod();
                break;
            }
            case 8: {
                result = tcp.isL4s();
                break;
            }
            case 9: {
                result = tcp.getTCPCongestionAvoidanceAlgorithm();
                break;
            }
            case 10: {
                result = tcp.getClientPort();
                break;
            }
            case 11: {
                result = tcp.getServerPort();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }

    public void modify(Object element, String property, Object value) {
        int columnIndex = this.getColumnIndex(property);
        TableItem item = (TableItem)element;
        TcpFlow tcpFlowTemplate = (TcpFlow)item.getData();
        if (value == null) {
            return;
        }
        ByteBlowerSetOperation operation = null;
        TcpFlowController controller = ControllerFactory.create((TcpFlow)tcpFlowTemplate);
        switch (columnIndex) {
            case 0: {
                String newName = ((String)value).trim();
                if (!OldNamingTools.nameIsUnique((EObject)tcpFlowTemplate, (String)newName)) break;
                operation = new ByteBlowerSetOperation("Change Flow Template Name", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.EBYTE_BLOWER_OBJECT__NAME, (Object)newName);
                break;
            }
            case 1: {
                TcpPayload tcpPayload = (TcpPayload)value;
                String duration = tcpPayload.getPayloadString();
                operation = new ByteBlowerSetOperation("Change TCP Payload Size", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__PAYLOAD_SIZE, (Object)duration);
                operation.appendCommand(controller.setPayloadUnit(tcpPayload.getUnit()));
                break;
            }
            case 2: {
                RateLimit rateLimit = (RateLimit)value;
                operation = new ByteBlowerSetOperation("Change TCP Rate Limit", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__RATE_LIMIT, (Object)Float.valueOf(rateLimit.getThroughput()));
                operation.appendCommand(controller.setRateLimitUnit(rateLimit.getUnit()));
                break;
            }
            case 3: {
                BigInteger receiveWindow = (BigInteger)value;
                operation = new ByteBlowerSetOperation("Change TCP Window Size", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SIZE, (Object)receiveWindow.toString());
                break;
            }
            case 4: {
                Boolean enable = (Boolean)value;
                operation = new ByteBlowerSetOperation(String.valueOf(enable != false ? "Enable" : "Disable") + " Window Scaling", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__WINDOW_SCALING, (Object)enable);
                break;
            }
            case 5: {
                int index = (Integer)value;
                if (index < 0 || index >= TcpFlowItemProvider.scaleValueChoices.length) break;
                byte bvalue = (byte)(index % 256);
                operation = new ByteBlowerSetOperation("Change Window Scale Value", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__RCV_WINDOW_SCALE, (Object)bvalue);
                break;
            }
            case 6: {
                String stringValue = (String)value;
                int slowStart = stringValue.equals("65535 (old default)") ? 65535 : (stringValue.equals(TcpFlowReader.predefinedInfiniteSlowStartString) ? Integer.MAX_VALUE : Integer.valueOf(stringValue));
                operation = new ByteBlowerSetOperation("Change Slow Start Value", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__SLOW_START, (Object)slowStart);
                break;
            }
            case 7: {
                HTTPMethod newMethod = (HTTPMethod)value;
                operation = new ByteBlowerSetOperation("Change HTTP Method", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__HTTP_METHOD, (Object)newMethod);
                break;
            }
            case 8: {
                Boolean enable = (Boolean)value;
                operation = new ByteBlowerSetOperation(String.valueOf(enable != false ? "Enable" : "Disable") + " L4S", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__L4S, (Object)enable);
                break;
            }
            case 9: {
                TCPCongestionAvoidanceAlgorithm newCAA = (TCPCongestionAvoidanceAlgorithm)value;
                operation = new ByteBlowerSetOperation("Change TCP Congestion Avoidance Algorithm", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__TCP_CONGESTION_AVOIDANCE_ALGORITHM, (Object)newCAA);
                break;
            }
            case 10: {
                operation = new ByteBlowerSetOperation("Change TCP ClientPort", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__CLIENT_PORT, value);
                break;
            }
            case 11: {
                operation = new ByteBlowerSetOperation("Change TCP Server Port", (EByteBlowerObject)tcpFlowTemplate, ByteblowerguimodelPackage.Literals.TCP_FLOW__SERVER_PORT, value);
                break;
            }
            default: {
                System.out.println("invalid case !");
                return;
            }
        }
        if (operation != null) {
            operation.run();
        }
    }
}

