/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.views.vlan;

import com.excentis.products.byteblower.gui.history.actions.IByteBlowerFocusDispatcher;
import com.excentis.products.byteblower.gui.jface.viewers.ShortCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.SpinnerCellEditor;
import com.excentis.products.byteblower.gui.jface.viewers.YesNoComboBoxCellEditor;
import com.excentis.products.byteblower.gui.preferences.ByteBlowerPreferences;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCopyAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerCutAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerDeleteAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerNewAction;
import com.excentis.products.byteblower.gui.swt.actions.project.ByteBlowerPasteAction;
import com.excentis.products.byteblower.gui.swt.sorting.ByteBlowerComparator;
import com.excentis.products.byteblower.gui.swt.widgets.IByteBlowerAction;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerAmountTableComposite;
import com.excentis.products.byteblower.gui.swt.widgets.table.ByteBlowerModelTableComposite;
import com.excentis.products.byteblower.gui.views.vlan.VlanCellModifier;
import com.excentis.products.byteblower.gui.views.vlan.VlanComparator;
import com.excentis.products.byteblower.gui.views.vlan.VlanStackComposite;
import com.excentis.products.byteblower.gui.views.vlan.actions.CopyVlan;
import com.excentis.products.byteblower.gui.views.vlan.actions.CutVlan;
import com.excentis.products.byteblower.gui.views.vlan.actions.DeleteVlan;
import com.excentis.products.byteblower.gui.views.vlan.actions.NewVlan;
import com.excentis.products.byteblower.gui.views.vlan.actions.PasteVlan;
import com.excentis.products.byteblower.gui.views.vlan.dnd.VlanTableDropAdapter;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.EByteBlowerObject;
import com.excentis.products.byteblower.model.Vlan;
import com.excentis.products.byteblower.model.VlanStack;
import com.excentis.products.byteblower.model.reader.VlanReader;
import com.excentis.products.byteblower.model.reader.VlanStackReader;
import com.excentis.products.byteblower.model.reader.factory.ReaderFactory;
import com.excentis.products.byteblower.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;

class VlanComposite
extends ByteBlowerAmountTableComposite<Vlan>
implements Adapter {
    VlanComparator comparator;
    private static final String[] columnNames = new String[]{"TPID", "VLAN Identifier", "Priority Code Point", "Drop Eligible (= Canonical Format Indicator)"};
    private Label labelFrameHint;
    private Button buttonOrder;
    private static final int[] columnWeights = new int[]{3, 2, 2, 3};
    private VlanStack activeStack = null;

    protected ByteBlowerComparator createViewerComparator(ColumnViewer columnViewer) {
        this.comparator = new VlanComparator(columnViewer);
        return this.comparator;
    }

    public static ArrayList<Integer> getProtocolIdIntegers() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int[] nArray = VlanReader.TPID_OPTIONS;
        int n = VlanReader.TPID_OPTIONS.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            list.add(i);
            ++n2;
        }
        return list;
    }

    public static ArrayList<String> getProtocolIdStrings() {
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < VlanReader.TPID_OPTIONS.length) {
            list.add("0x" + Utils.int2HexString((int)VlanReader.TPID_OPTIONS[i]) + " (" + VlanReader.TPID_INFO[i] + ")");
            ++i;
        }
        return list;
    }

    public VlanComposite(Composite parent, IByteBlowerAction actionInterface, IByteBlowerFocusDispatcher focusDispatcher, VlanStackComposite vlanStackComposite) {
        super(parent, "VlanComposite", actionInterface, focusDispatcher, (ByteBlowerModelTableComposite)vlanStackComposite);
        this.initializeChildClass();
        this.createBottomInfo();
    }

    private void createBottomInfo() {
        this.labelFrameHint = new Label((Composite)this, 4);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.labelFrameHint.setLayoutData((Object)gridData);
        this.buttonOrder = new Button((Composite)this, 0);
        this.buttonOrder.setText("Change Sorting Direction");
        this.buttonOrder.addSelectionListener((SelectionListener)this);
        gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.buttonOrder.setLayoutData((Object)gridData);
        this.updateBottomInfo();
    }

    private void updateBottomInfo() {
        this.asyncExec(new Runnable(){

            @Override
            public void run() {
                String vlanInfo;
                if (VlanComposite.this.labelFrameHint.isDisposed()) {
                    return;
                }
                if (VlanComposite.this.activeStack == null) {
                    vlanInfo = "";
                } else {
                    VlanStackReader stackReader = ReaderFactory.create((VlanStack)VlanComposite.this.activeStack);
                    if (stackReader.isEmpty()) {
                        vlanInfo = "Add Vlans";
                    } else {
                        List vlanReaders = stackReader.getVlanReaders();
                        int nofVlans = vlanReaders.size();
                        boolean showInnerOuter = nofVlans > 1;
                        vlanInfo = "Resulting Frame: Destination Mac - Source Mac ";
                        for (VlanReader vlanReader : vlanReaders) {
                            vlanInfo = String.valueOf(vlanInfo) + "- Vlan " + vlanReader.getVlanId() + " ";
                            if (!showInnerOuter) continue;
                            if (vlanReader.isInner()) {
                                vlanInfo = String.valueOf(vlanInfo) + "(Inner) ";
                                continue;
                            }
                            if (!vlanReader.isOuter()) continue;
                            vlanInfo = String.valueOf(vlanInfo) + "(Outer) ";
                        }
                        vlanInfo = String.valueOf(vlanInfo) + "- Ethernet Payload";
                    }
                }
                VlanComposite.this.labelFrameHint.setText(vlanInfo);
            }
        });
    }

    protected CellEditor[] createCellEditors() {
        Table table = this.getTable();
        CellEditor[] editors = new CellEditor[columnNames.length];
        String[] options = new String[VlanReader.TPID_OPTIONS.length];
        options = VlanComposite.getProtocolIdStrings().toArray(options);
        ComboBoxCellEditor editor = new ComboBoxCellEditor((Composite)table, options, 8);
        editor.setActivationStyle(1);
        editors[0] = editor;
        editors[2] = new SpinnerCellEditor((Composite)table, 0, 7);
        editors[3] = new YesNoComboBoxCellEditor((Composite)table);
        editors[1] = new ShortCellEditor((Composite)table, Short.valueOf((short)0), Short.valueOf((short)4095));
        return editors;
    }

    protected ICellModifier getCellModifier() {
        return new VlanCellModifier(this);
    }

    protected int[] getColumnWeights() {
        return columnWeights;
    }

    protected Class<? extends EByteBlowerObject> getParentClass() {
        return VlanStack.class;
    }

    public int getChildFeatureId() {
        return 3;
    }

    public Class<? extends EByteBlowerObject> getViewedClass() {
        return Vlan.class;
    }

    public void parentSelectionChanged(SelectionChangedEvent event) {
        StructuredSelection stackSelection = this.getParentByteBlowerComposite().getStructuredSelection();
        this.activeStack = stackSelection.size() == 1 ? (VlanStack)stackSelection.getFirstElement() : null;
        Object currentInput = this.getInput();
        if (this.activeStack != currentInput) {
            VlanStack previousStack;
            if (currentInput instanceof VlanStack && (previousStack = (VlanStack)currentInput).eAdapters().contains((Object)this)) {
                previousStack.eAdapters().remove((Object)this);
                this.removeVlanAdapters(previousStack);
            }
            if (this.activeStack instanceof VlanStack && !this.activeStack.eAdapters().contains((Object)this)) {
                this.activeStack.eAdapters().add((Object)this);
                this.addVlanAdapters(this.activeStack);
            }
            this.setInput(this.activeStack);
            this.updateWidgets();
            this.updateBottomInfo();
        }
    }

    private void addVlanAdapters(VlanStack activeStack) {
        for (Vlan vlan : activeStack.getVlans()) {
            vlan.eAdapters().add((Object)this);
        }
    }

    private void removeVlanAdapters(VlanStack previousStack) {
        for (Vlan vlan : previousStack.getVlans()) {
            vlan.eAdapters().remove((Object)this);
        }
    }

    protected String getTableLabel() {
        return "Added VLANs:";
    }

    protected String[] getColumnNames() {
        return columnNames;
    }

    public boolean isCopyDownEnabled() {
        switch (this.getCurrentColumn()) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                return true;
            }
        }
        return false;
    }

    public boolean isCopyDownIncEnabled() {
        switch (this.getCurrentColumn()) {
            case 1: {
                return true;
            }
            case 0: 
            case 2: 
            case 3: {
                return false;
            }
        }
        return false;
    }

    public boolean isCopyDownDecEnabled() {
        return this.isCopyDownIncEnabled();
    }

    public boolean isJumpEnabled() {
        return false;
    }

    public void doJump() {
    }

    public Object getInitialInput() {
        return null;
    }

    protected void projectChanged(ByteBlowerProject project) {
        if (project == null) {
            this.resetInput();
        }
    }

    protected ByteBlowerNewAction<Vlan> createNewAction() {
        return new NewVlan(this);
    }

    protected ByteBlowerCutAction<Vlan> createCutAction() {
        return new CutVlan((ByteBlowerModelTableComposite<Vlan>)this);
    }

    protected ByteBlowerCopyAction<Vlan> createCopyAction() {
        return new CopyVlan(this);
    }

    protected ByteBlowerPasteAction<Vlan> createPasteAction() {
        return new PasteVlan(this);
    }

    protected ByteBlowerDeleteAction<Vlan> createDeleteAction() {
        return new DeleteVlan(this);
    }

    protected DropTargetListener getDropTargetListener() {
        return new VlanTableDropAdapter((StructuredViewer)this.getTableViewer(), this.getParentByteBlowerComposite());
    }

    protected void updateCustomWidgets(boolean enable) {
        this.labelFrameHint.setEnabled(enable);
        this.buttonOrder.setEnabled(enable);
        super.updateCustomWidgets(enable);
    }

    public void notifyChanged(Notification notification) {
        switch (notification.getFeatureID(VlanStack.class)) {
            case 3: {
                this.updateBottomInfo();
                this.addVlanAdapters(this.activeStack);
            }
        }
        switch (notification.getFeatureID(Vlan.class)) {
            case 6: {
                this.updateBottomInfo();
            }
        }
    }

    public Notifier getTarget() {
        return null;
    }

    public void setTarget(Notifier newTarget) {
    }

    public boolean isAdapterForType(Object type) {
        return false;
    }

    public void widgetSelected(SelectionEvent event) {
        if (event.widget == this.buttonOrder) {
            boolean order = ByteBlowerPreferences.getVlanSortingDirection();
            ByteBlowerPreferences.setVlanSortingDirection((!order ? 1 : 0) != 0);
            this.hardRefresh();
        }
        super.widgetSelected(event);
    }
}

