/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards;

import com.excentis.products.byteblower.gui.images.ImageCache;
import com.excentis.products.byteblower.gui.wizards.ByteBlowerWizardPortConfigComposite;
import com.excentis.products.byteblower.gui.wizards.WizardPage;
import com.excentis.products.byteblower.gui.wizards.backtoback.BackToBackTopology;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerGuiPortConfiguration;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.EthernetConfiguration;
import com.excentis.products.byteblower.model.Ipv4Address;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Ipv4Configuration;
import com.excentis.products.byteblower.model.Layer2Configuration;
import com.excentis.products.byteblower.model.MacAddress;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import com.excentis.products.byteblower.model.control.MacAddressController;
import com.excentis.products.byteblower.model.edit.tools.NamingTools;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.server.model.PhysicalDockable;
import java.nio.ByteBuffer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class BackToBackPortConfigPage
extends WizardPage {
    private BackToBackTopology topology;
    private ByteBlowerWizardPortConfigComposite portConfigComposite;
    private final ByteBlowerGuiPort port;
    private final boolean isSource;

    private BackToBackPortConfigPage(ByteBlowerGuiPort port, boolean isSource) {
        super("BackToBackPortConfigPage");
        if (isSource) {
            this.setTitle("Source Port configuration");
        } else {
            this.setTitle("Destination Port configuration");
        }
        this.setImageDescriptor(ImageCache.getImageDescriptor((String)"wizards/backtobackwizard.gif"));
        this.isSource = isSource;
        this.port = port;
    }

    @Override
    public void createControl(Composite parent) {
        SashForm container = new SashForm(parent, 0);
        FillLayout fillLayout = new FillLayout();
        fillLayout.type = 256;
        fillLayout.marginHeight = 5;
        fillLayout.marginWidth = 5;
        fillLayout.spacing = 5;
        container.setLayout((Layout)fillLayout);
        this.setControl((Control)container);
        this.topology = new BackToBackTopology((Composite)container, 2048);
        if (this.isSource) {
            this.topology.focusOnSource();
        } else {
            this.topology.focusOnDestination();
        }
        this.topology.applyChanges();
        this.portConfigComposite = new ByteBlowerWizardPortConfigComposite((Composite)container, 2048, this.port, this.isSource);
        this.portConfigComposite.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                BackToBackPortConfigPage.this.onChange();
            }
        });
        this.portConfigComposite.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BackToBackPortConfigPage.this.onChange();
            }
        });
        Rectangle bounds = parent.getClientArea();
        container.setBounds(5, 5, bounds.width - 10, bounds.height - 10);
        int[] weights = new int[]{30, 70};
        container.setWeights(weights);
        this.onChange(false);
    }

    private void onChange() {
        this.onChange(true);
    }

    private void onChange(boolean showErrorMessage) {
        if (this.portConfigComposite.isComplete()) {
            this.setPageComplete(true);
            this.setErrorMessage(null);
            this.setMessage(null);
        } else {
            if (showErrorMessage) {
                this.setErrorMessage(this.portConfigComposite.getErrorMessage());
            }
            this.setPageComplete(false);
        }
    }

    public PhysicalDockable getDockable() {
        return this.portConfigComposite.getDockable();
    }

    public ByteBlowerGuiPort getPort() {
        return this.port;
    }

    public static class BackToBackPortFactory {
        private final String GATEWAY = "10.0.0.1";
        private final String NETMASK = "255.255.255.0";
        private final String BASE_IP_ADDRESS = "10.0.0.";
        private int nextMacAddress = 1;
        private int nextIpAddress = 2;
        private ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;

        private String getMacAddress() {
            ByteBuffer data = ByteBuffer.allocate(6);
            data.position(2);
            data.putInt(this.nextMacAddress++);
            StringBuilder result = new StringBuilder();
            String sep = "";
            data.rewind();
            while (data.hasRemaining()) {
                result.append(sep);
                result.append(data.get() & 0xFF);
                sep = "-";
            }
            return result.toString();
        }

        private String getIpAddress() {
            return "10.0.0." + this.nextIpAddress++ % 255;
        }

        private Ipv4Configuration initIpv4(String address, String gateway, String netmask) {
            Ipv4Configuration iPv4Configuration = this.factory.createIpv4Configuration();
            this.factory.createIpv4Configuration();
            Ipv4Address ip = this.factory.createIpv4Address();
            Ipv4AddressController.setAddress((Ipv4Address)ip, (String)address);
            iPv4Configuration.setIpAddress(ip);
            ip = this.factory.createIpv4Address();
            Ipv4AddressController.setAddress((Ipv4Address)ip, (String)gateway);
            iPv4Configuration.setDefaultGateway(ip);
            ip = this.factory.createIpv4Address();
            Ipv4AddressController.setAddress((Ipv4Address)ip, (String)netmask);
            iPv4Configuration.setNetmask(ip);
            iPv4Configuration.setAddressConfiguration(Ipv4AddressConfigType.FIXED);
            iPv4Configuration.setIsActive(Boolean.TRUE);
            return iPv4Configuration;
        }

        private ByteBlowerGuiPort initBackToBackPort(ByteBlowerProject project, String name) {
            Ipv4Configuration iPv4Configuration = this.initIpv4(this.getIpAddress(), "10.0.0.1", "255.255.255.0");
            MacAddress mac = this.factory.createMacAddress();
            MacAddressController macAddressController = new MacAddressController(mac);
            macAddressController.setAddress(this.getMacAddress());
            EthernetConfiguration backToBackSourceEthernet = this.factory.createEthernetConfiguration();
            backToBackSourceEthernet.setMacAddress(mac);
            ByteBlowerGuiPort backToBackSource = this.factory.createByteBlowerGuiPort();
            ByteBlowerGuiPortConfiguration sourcePortConfig = this.factory.createByteBlowerGuiPortConfiguration();
            backToBackSource.setByteBlowerGuiPortConfiguration(sourcePortConfig);
            backToBackSource.setLayer2Configuration((Layer2Configuration)backToBackSourceEthernet);
            backToBackSource.setIpv4Configuration(iPv4Configuration);
            backToBackSource.setName(NamingTools.getUniqueName((ByteBlowerProject)project, (EObject)backToBackSource, (String)name));
            return backToBackSource;
        }

        public BackToBackPortConfigPage makeSource(ByteBlowerProject project, String name) {
            BackToBackPortConfigPage result = new BackToBackPortConfigPage(this.initBackToBackPort(project, name), true);
            return result;
        }

        public BackToBackPortConfigPage makeDestination(ByteBlowerProject project, String name) {
            BackToBackPortConfigPage result = new BackToBackPortConfigPage(this.initBackToBackPort(project, name), false);
            return result;
        }
    }
}

