/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.backtoback;

import com.excentis.products.byteblower.gui.history.operations.UndoableByteBlowerControllerOperation;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.refresher.PhysicalConfigurationManager;
import com.excentis.products.byteblower.gui.views.scenario.ScenarioView;
import com.excentis.products.byteblower.gui.wizards.BackToBackPortConfigPage;
import com.excentis.products.byteblower.gui.wizards.Wizard;
import com.excentis.products.byteblower.gui.wizards.backtoback.BackToBackFlowConfigPage;
import com.excentis.products.byteblower.gui.wizards.backtoback.Messages;
import com.excentis.products.byteblower.gui.wizards.pages.GenericIntroPage;
import com.excentis.products.byteblower.model.AddressableDestination;
import com.excentis.products.byteblower.model.AddressableSource;
import com.excentis.products.byteblower.model.AlternateModifier;
import com.excentis.products.byteblower.model.ByteBlowerGuiPort;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.ByteblowerguimodelFactory;
import com.excentis.products.byteblower.model.Dhcp;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.FlowTemplate;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.Ipv4AddressConfigType;
import com.excentis.products.byteblower.model.Scenario;
import com.excentis.products.byteblower.model.SequenceModifier;
import com.excentis.products.byteblower.model.control.ByteBlowerGuiPortController;
import com.excentis.products.byteblower.model.control.ByteBlowerProjectController;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.DhcpController;
import com.excentis.products.byteblower.model.control.FlowController;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.FrameBlastingFrameController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.model.control.Ipv4ConfigurationController;
import com.excentis.products.byteblower.model.control.ScenarioController;
import com.excentis.products.byteblower.model.control.ScenarioFlowEventController;
import com.excentis.products.byteblower.model.edit.tools.NamingTools;
import com.excentis.products.byteblower.model.impl.ByteblowerguimodelFactoryImpl;
import com.excentis.products.byteblower.model.reader.ByteBlowerProjectReader;
import com.excentis.products.byteblower.object.control.CompoundCommandController;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.UniqueEList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.wizard.IWizardPage;

public class BackToBackWizard
extends Wizard {
    private GenericIntroPage introPage = null;
    private BackToBackFlowConfigPage flowPage = null;
    private final BackToBackPortConfigPage sourcePage;
    private final BackToBackPortConfigPage destinationPage;
    private ByteblowerguimodelFactory factory = ByteblowerguimodelFactoryImpl.eINSTANCE;
    private FrameBlastingFlow backToBackFlowTemplate = this.factory.createFrameBlastingFlow();
    private AlternateModifier backToBackAlternateModifier = this.factory.createAlternateModifier();
    private Frame backToBackFrame = this.factory.createFrame();
    private Flow backToBackFlow = this.factory.createFlow();
    private Scenario backToBackScenario = this.factory.createScenario();
    private FlowMeasurementController backToBackFlowMeasurement;

    public BackToBackWizard() {
        ByteBlowerProject project = ByteBlowerGuiResourceController.getProject();
        BackToBackPortConfigPage.BackToBackPortFactory factory = new BackToBackPortConfigPage.BackToBackPortFactory();
        this.sourcePage = factory.makeSource(project, "Back-to-Back Source 1");
        this.destinationPage = factory.makeDestination(project, "Back-to-Back Destination 1");
        this.init(project);
    }

    private void initBackToBackFlowTemplate(ByteBlowerProject project) {
        this.backToBackFrame.setName(NamingTools.getUniqueName((ByteBlowerProject)project, (EObject)this.backToBackFrame, (String)"Back-to-Back Frame 1"));
        FrameController.initializeFrame_Ipv4_UDP((Frame)this.backToBackFrame);
        this.backToBackFlowTemplate.setName(NamingTools.getUniqueName((ByteBlowerProject)project, (EObject)this.backToBackFlowTemplate, (String)"Back-to-Back Template 1"));
        this.backToBackFlowTemplate.setSequenceModifier((SequenceModifier)this.backToBackAlternateModifier);
        FrameBlastingFlowController controller = ControllerFactory.create((FrameBlastingFlow)this.backToBackFlowTemplate);
        FrameBlastingFlowController.CommandWithFrameBlastingFrameListReference ref = controller.addFrameBlastingFrame();
        ref.getCommand().execute();
        FrameBlastingFrameController frameBlastingFrameController = (FrameBlastingFrameController)((List)ref.getCommandReference()).get(0);
        frameBlastingFrameController.setFrame(this.backToBackFrame).execute();
    }

    private void initBackToBackFlow(ByteBlowerProject project) {
        this.backToBackFlow.setName(NamingTools.getUniqueName((ByteBlowerProject)project, (EObject)this.backToBackFlow, (String)"Back-to-Back Flow 1"));
        this.backToBackFlow.setSource((AddressableSource)this.sourcePage.getPort());
        FlowController flowController = ControllerFactory.create((Flow)this.backToBackFlow);
        Command command = flowController.createSetDestinationCommand((AddressableDestination)this.destinationPage.getPort());
        if (command.canExecute()) {
            command.execute();
        }
        this.backToBackFlow.setFlowTemplate((FlowTemplate)this.backToBackFlowTemplate);
    }

    private void initBackToBackScenario(ByteBlowerProject project) {
        this.backToBackScenario.setName(NamingTools.getUniqueName((ByteBlowerProject)project, (EObject)this.backToBackScenario, (String)"Back-to-Back Scenario 1"));
        ScenarioController controller = ControllerFactory.create((Scenario)this.backToBackScenario);
        ScenarioFlowEventController.CommandWithFlowMeasurementListReference ref = controller.addFlowMeasurement();
        ref.getCommand().execute();
        this.backToBackFlowMeasurement = (FlowMeasurementController)((List)ref.getCommandReference()).get(0);
        this.backToBackFlowMeasurement.setFlow(this.backToBackFlow).execute();
        this.backToBackFlowMeasurement.setNumberOfFrames(Long.valueOf(1000L)).execute();
    }

    private void init(ByteBlowerProject project) {
        this.initBackToBackFlowTemplate(project);
        this.initBackToBackFlow(project);
        this.initBackToBackScenario(project);
    }

    @Override
    public boolean performCancel() {
        return super.performCancel();
    }

    @Override
    public boolean performFinish() {
        this.setNeedsProgressMonitor(false);
        CompoundCommandController compoundController = CompoundCommandController.createInstance();
        ByteBlowerProjectController projectController = ByteBlowerGuiResourceController.getProjectController();
        if (projectController == null) {
            return false;
        }
        UniqueEList backToBackPorts = new UniqueEList();
        backToBackPorts.add(this.sourcePage.getPort());
        backToBackPorts.add(this.destinationPage.getPort());
        compoundController.appendCommand(this.createDhcp((Collection<ByteBlowerGuiPort>)backToBackPorts));
        compoundController.appendCommand(projectController.createAddByteBlowerGuiPortCommand((Collection)backToBackPorts));
        compoundController.appendCommand(projectController.createAddFrameCommand(this.backToBackFrame));
        compoundController.appendCommand(projectController.createAddFlowTemplateCommand((FlowTemplate)this.backToBackFlowTemplate));
        compoundController.appendCommand(projectController.createAddFlowCommand(this.backToBackFlow));
        compoundController.appendCommand(projectController.createAddScenarioCommand(this.backToBackScenario));
        UndoableByteBlowerControllerOperation operation = new UndoableByteBlowerControllerOperation(ByteBlowerGuiResourceController.getProject(), "Back-to-Back Wizard", compoundController.unwrap());
        operation.run();
        PhysicalConfigurationManager manager = PhysicalConfigurationManager.getInstance();
        manager.autoDock((ByteBlowerProjectReader)projectController);
        ScenarioView.showAndSelect(this.backToBackScenario);
        return true;
    }

    private Command createDhcp(Collection<ByteBlowerGuiPort> backToBackPorts) {
        Dhcp dhcp = null;
        CompoundCommandController compound = CompoundCommandController.createInstance();
        for (ByteBlowerGuiPort port : backToBackPorts) {
            if (port.getIpv4Configuration().getAddressConfiguration() != Ipv4AddressConfigType.DHC_PV4) continue;
            if (dhcp == null) {
                ByteBlowerProjectController projectController = new ByteBlowerProjectController(ByteBlowerGuiResourceController.getProject());
                ByteBlowerProjectController.CommandWithDhcpListReference commandWithRef = projectController.addDhcp();
                compound.appendCommand(commandWithRef.getCommand());
                DhcpController dhcpController = (DhcpController)((List)commandWithRef.getCommandReference()).get(0);
                dhcp = (Dhcp)dhcpController.getObject();
            }
            ByteBlowerGuiPortController controller = new ByteBlowerGuiPortController(port);
            Ipv4ConfigurationController ipv4ConfigurationController = controller.getIpv4ConfigurationController();
            ipv4ConfigurationController.setDhcp(dhcp).getCommand().execute();
        }
        return compound.unwrap();
    }

    @Override
    public void addPages() {
        this.setWindowTitle("Back-to-Back Wizard");
        this.introPage = new GenericIntroPage(Messages.getString("IntroPage.Title"), "", Messages.getString("IntroPage.IntroductionText"), "wizards/backtobackwizard.gif", "images/backtobackwizard_left.gif");
        this.addPage((IWizardPage)this.introPage);
        this.flowPage = new BackToBackFlowConfigPage(this.backToBackFlow, this.backToBackFlowMeasurement);
        this.addPage((IWizardPage)this.flowPage);
        this.addPage((IWizardPage)this.sourcePage);
        this.addPage((IWizardPage)this.destinationPage);
    }
}

