/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.backtoback.composites;

import com.excentis.products.byteblower.gui.history.operations.copydown.TimeTextFactory;
import com.excentis.products.byteblower.gui.project.ByteBlowerGuiResourceController;
import com.excentis.products.byteblower.gui.swt.widgets.text.IntegerTextFactory;
import com.excentis.products.byteblower.gui.widgets.composites.RateComposite;
import com.excentis.products.byteblower.gui.wizards.backtoback.composites.Messages;
import com.excentis.products.byteblower.model.ByteBlowerProject;
import com.excentis.products.byteblower.model.Flow;
import com.excentis.products.byteblower.model.Frame;
import com.excentis.products.byteblower.model.FrameBlastingFlow;
import com.excentis.products.byteblower.model.FrameBlastingFrame;
import com.excentis.products.byteblower.model.control.ControllerFactory;
import com.excentis.products.byteblower.model.control.FlowMeasurementController;
import com.excentis.products.byteblower.model.control.FrameBlastingFlowController;
import com.excentis.products.byteblower.model.control.FrameController;
import com.excentis.products.byteblower.utils.HighResolutionCalendar;
import com.excentis.products.byteblower.utils.HighResolutionCalendarParser;
import java.math.BigInteger;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.command.Command;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class BackToBackFlowConfigComposite
extends Composite
implements ModifyListener {
    private Text txtFrameSize;
    private RateComposite rateComposite;
    private Text txtDuration;
    private Text txtNofFrames;
    private Flow flow;
    private FlowMeasurementController flowMeasurementController;
    private String errorMessage;

    public BackToBackFlowConfigComposite(Composite parent, Flow flow, FlowMeasurementController flowMeasurementController) {
        super(parent, 2048);
        this.flow = flow;
        this.flowMeasurementController = flowMeasurementController;
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
    }

    private void initialize() {
        GridLayout layout = new GridLayout();
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginRight = 0;
        layout.marginLeft = 0;
        this.setLayout((Layout)layout);
        Group group = new Group((Composite)this, 0);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblFrameSize = new Label((Composite)group, 0);
        lblFrameSize.setText("Frame Size (bytes):");
        this.txtFrameSize = IntegerTextFactory.instance().create((Composite)group, 9999L);
        this.txtFrameSize.setLayoutData((Object)new GridData(768));
        this.txtFrameSize.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int frameSize = 0;
                try {
                    frameSize = Integer.parseInt(BackToBackFlowConfigComposite.this.txtFrameSize.getText());
                    if (frameSize >= 60 && frameSize <= 8192) {
                        FrameBlastingFlow frameBlastingFlow = (FrameBlastingFlow)BackToBackFlowConfigComposite.this.flow.getFlowTemplate();
                        FrameBlastingFlowController controller = ControllerFactory.create((FrameBlastingFlow)frameBlastingFlow);
                        Command command = BackToBackFlowConfigComposite.this.getFrameController().setFrameSize(frameSize);
                        if (command != null) {
                            command.execute();
                        }
                        controller.setStatusUnknown();
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        });
        group = new Group((Composite)this, 0);
        group.setText("Speed");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new FillLayout());
        FrameBlastingFlow frameBlastingFlow = (FrameBlastingFlow)this.flow.getFlowTemplate();
        FrameBlastingFlowController controller = ControllerFactory.create((FrameBlastingFlow)frameBlastingFlow);
        this.rateComposite = new RateComposite((Composite)group, 0, ByteBlowerGuiResourceController.getProjectReader(), controller);
        this.rateComposite.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                BackToBackFlowConfigComposite.this.updateDuration();
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        group = new Group((Composite)this, 0);
        group.setText("Duration");
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label lblNofFrames = new Label((Composite)group, 0);
        lblNofFrames.setText("Number of Frames:");
        this.txtNofFrames = IntegerTextFactory.instance().createWithTextLimit((Composite)group, 20);
        this.txtNofFrames.setLayoutData((Object)new GridData(768));
        this.txtNofFrames.addModifyListener((ModifyListener)this);
        Label lblDuration = new Label((Composite)group, 0);
        lblDuration.setText("Flow duration:");
        this.txtDuration = TimeTextFactory.instance().create((Composite)group, 2048);
        this.txtDuration.setLayoutData((Object)new GridData(768));
        this.txtDuration.addModifyListener((ModifyListener)this);
        this.initializeValues();
    }

    private void initializeValues() {
        FrameController frameController = this.getFrameController();
        this.txtFrameSize.setText(Integer.toString(frameController.getByteSize(this.getProject().getThroughputType())));
        this.txtDuration.setText(HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)this.flowMeasurementController.getDuration()));
        this.txtNofFrames.setText(this.flowMeasurementController.getNumberOfFramesBigInteger().toString());
    }

    private ByteBlowerProject getProject() {
        return ByteBlowerGuiResourceController.getProject();
    }

    private FrameController getFrameController() {
        FrameBlastingFlow flowTemplate = (FrameBlastingFlow)this.flow.getFlowTemplate();
        FrameBlastingFrame frameBlastingFrame = (FrameBlastingFrame)flowTemplate.getFrameBlastingFrames().get(0);
        return ControllerFactory.create((Frame)frameBlastingFrame.getFrame());
    }

    public void addModifyListener(ModifyListener listener) {
        this.txtFrameSize.addModifyListener(listener);
        this.txtNofFrames.addModifyListener(listener);
    }

    private void updateNofFrames() {
        this.txtNofFrames.setText(this.flowMeasurementController.getNumberOfFramesBigInteger().toString());
    }

    private void updateDuration() {
        this.txtDuration.setText(HighResolutionCalendarParser.getRelativeTime((HighResolutionCalendar)this.flowMeasurementController.getDuration()));
    }

    public boolean isComplete() {
        int frameSize = 0;
        try {
            frameSize = Integer.parseInt(this.txtFrameSize.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        this.txtFrameSize.setForeground(null);
        if (frameSize < 60) {
            this.txtFrameSize.setForeground(ColorConstants.red);
            this.errorMessage = "The Frame size is too small. The minimum Frame size is 60 bytes.";
            return false;
        }
        if (frameSize > 8192) {
            this.txtFrameSize.setForeground(ColorConstants.red);
            this.errorMessage = "The Frame size is too big. The maximum Frame size is 8192 bytes.";
            return false;
        }
        String nofFrames = this.txtNofFrames.getText();
        this.txtNofFrames.setForeground(null);
        if (nofFrames == "") {
            this.errorMessage = Messages.getString("ScenarioActionSettingsDialog.error.minnofframes");
            return false;
        }
        try {
            long frames = Long.parseLong(nofFrames);
            if (frames == 0L) {
                this.txtNofFrames.setForeground(ColorConstants.red);
                this.errorMessage = Messages.getString("ScenarioActionSettingsDialog.error.minnofframes");
                return false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.txtNofFrames.setForeground(ColorConstants.red);
            this.errorMessage = Messages.getString("ScenarioActionSettingsDialog.error.maxnofframes");
            return false;
        }
        this.errorMessage = "";
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void modifyText(ModifyEvent e) {
        Control control = (Control)e.widget;
        if (control.isFocusControl()) {
            if (control == this.txtNofFrames) {
                String nofFrames = this.txtNofFrames.getText();
                if (nofFrames.length() == 0) {
                    nofFrames = "0";
                }
                this.flowMeasurementController.setNumberOfFrames(Long.valueOf(new BigInteger(nofFrames).longValue())).execute();
                this.updateDuration();
            } else if (control == this.txtDuration) {
                HighResolutionCalendar highResolutionCalendar = new HighResolutionCalendar();
                HighResolutionCalendarParser.setRelativeTime((String)this.txtDuration.getText(), (HighResolutionCalendar)highResolutionCalendar);
                this.flowMeasurementController.setDuration(highResolutionCalendar).execute();
                this.updateNofFrames();
            }
        }
    }
}

