/*
 * Decompiled with CFR 0.152.
 */
package com.excentis.products.byteblower.gui.wizards.composites;

import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv4AddressAndMaskTextFactory;
import com.excentis.products.byteblower.gui.swt.widgets.text.Ipv4AddressTextFactory_ForByteBlowerGuiPort;
import com.excentis.products.byteblower.gui.swt.widgets.text.NetmaskTextFactory;
import com.excentis.products.byteblower.gui.wizards.composites.Messages;
import com.excentis.products.byteblower.model.control.Ipv4AddressController;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class Layer3Composite
extends Composite {
    private Label l3Description = null;
    private Button bDhcp = null;
    private Label ipLabel = null;
    private Text ipText = null;
    private Label subnetLabel = null;
    private Text subnetText = null;
    private Label netmaskLabel = null;
    private Text netmaskText = null;
    private Label defaultGatewayLabel = null;
    private Text defaultGatewayText = null;
    private Group group = new Group((Composite)this, 0);
    private String errorMessage;

    Layer3Composite(Composite parent, int style) {
        super(parent, 0);
        this.setLayout((Layout)new FillLayout());
        this.initialize();
        this.setBackground(parent.getBackground());
        this.setForeground(parent.getForeground());
        this.setFont(parent.getFont());
        this.group.setText(Messages.getString("Layer3Composite.Title"));
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Layer3Composite.this.onResize();
            }
        });
        this.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                Layer3Composite.this.onDispose();
            }
        });
    }

    private void initialize() {
        GridLayout localGridlayout = new GridLayout();
        localGridlayout.numColumns = 2;
        localGridlayout.marginWidth = 5;
        localGridlayout.marginHeight = 5;
        localGridlayout.horizontalSpacing = 5;
        localGridlayout.verticalSpacing = 5;
        localGridlayout.makeColumnsEqualWidth = true;
        this.group.setLayout((Layout)localGridlayout);
        this.l3Description = new Label((Composite)this.group, 64);
        GridData descriptionData = new GridData(64, 128, false, false);
        descriptionData.horizontalSpan = 2;
        this.l3Description.setLayoutData((Object)descriptionData);
        this.l3Description.setText(Messages.getString("Layer3Composite.Introduction"));
        this.bDhcp = new Button((Composite)this.group, 32);
        this.bDhcp.setText(Messages.getString("Layer3Composite.Dhcp"));
        GridData dhcpData = new GridData(16384, 128, false, false);
        dhcpData.horizontalSpan = 2;
        this.bDhcp.setLayoutData((Object)dhcpData);
        this.bDhcp.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                Button b = (Button)event.widget;
                if (b.getSelection()) {
                    Layer3Composite.this.ipText.setEnabled(false);
                    Layer3Composite.this.subnetText.setEnabled(false);
                    Layer3Composite.this.netmaskText.setEnabled(false);
                    Layer3Composite.this.defaultGatewayText.setEnabled(false);
                } else {
                    Layer3Composite.this.ipText.setEnabled(true);
                    Layer3Composite.this.subnetText.setEnabled(true);
                    Layer3Composite.this.netmaskText.setEnabled(true);
                    Layer3Composite.this.defaultGatewayText.setEnabled(true);
                }
            }
        });
        this.ipText = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create((Composite)this.group, 2048);
        this.ipText.setLayoutData((Object)new GridData(4, 128, false, false));
        this.subnetLabel = new Label((Composite)this.group, 0);
        this.subnetLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.subnetLabel.setText(Messages.getString("Layer3Composite.Subnet"));
        this.subnetText = Ipv4AddressAndMaskTextFactory.instance().create((Composite)this.group, 2048);
        this.subnetText.setLayoutData((Object)new GridData(4, 128, false, false));
        this.subnetText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Layer3Composite.this.subnetText.isFocusControl() && Ipv4AddressAndMaskTextFactory.instance().hasMask((Text)e.widget)) {
                    Layer3Composite.this.netmaskText.setText(Ipv4AddressAndMaskTextFactory.instance().extractMask((Text)e.widget));
                }
            }
        });
        this.netmaskLabel = new Label((Composite)this.group, 0);
        this.netmaskLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.netmaskLabel.setText(Messages.getString("Layer3Composite.NetMask"));
        this.netmaskText = NetmaskTextFactory.instance().create((Composite)this.group, 2048);
        this.netmaskText.setLayoutData((Object)new GridData(4, 128, false, false));
        this.netmaskText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (Layer3Composite.this.netmaskText.isFocusControl()) {
                    Ipv4AddressAndMaskTextFactory.instance().setMask(Layer3Composite.this.subnetText, Layer3Composite.this.netmaskText.getText());
                }
            }
        });
        this.defaultGatewayLabel = new Label((Composite)this.group, 0);
        this.defaultGatewayLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
        this.defaultGatewayLabel.setText(Messages.getString("Layer3Composite.Gateway"));
        this.defaultGatewayText = Ipv4AddressTextFactory_ForByteBlowerGuiPort.instance().create((Composite)this.group, 2048);
        this.defaultGatewayText.setLayoutData((Object)new GridData(4, 128, false, false));
        this.layout();
    }

    private void onDispose() {
        if (this.l3Description != null) {
            this.l3Description.dispose();
        }
        if (this.bDhcp != null) {
            this.bDhcp.dispose();
        }
        if (this.ipLabel != null) {
            this.ipLabel.dispose();
        }
        if (this.ipText != null) {
            this.ipText.dispose();
        }
        if (this.subnetLabel != null) {
            this.subnetLabel.dispose();
        }
        if (this.subnetText != null) {
            this.subnetText.dispose();
        }
        if (this.netmaskLabel != null) {
            this.netmaskLabel.dispose();
        }
        if (this.netmaskText != null) {
            this.netmaskText.dispose();
        }
        if (this.defaultGatewayLabel != null) {
            this.defaultGatewayLabel.dispose();
        }
        if (this.defaultGatewayText != null) {
            this.defaultGatewayText.dispose();
        }
    }

    private void onResize() {
        this.group.setBounds(this.getBounds());
        ((GridData)this.l3Description.getLayoutData()).widthHint = this.getBounds().width - 10;
        this.layout();
    }

    void addModifyListener(ModifyListener listener) {
        this.ipText.addModifyListener(listener);
        this.subnetText.addModifyListener(listener);
        this.netmaskText.addModifyListener(listener);
        this.defaultGatewayText.addModifyListener(listener);
    }

    public boolean isComplete() {
        if (this.bDhcp.getSelection() || Ipv4AddressController.isValidNonZero((String)this.ipText.getText()) && Ipv4AddressAndMaskTextFactory.instance().checkComplete(this.subnetText) && Ipv4AddressController.isValidNetmask((String)this.netmaskText.getText()) && Ipv4AddressController.isValidNonZero((String)this.defaultGatewayText.getText())) {
            return true;
        }
        if (!Ipv4AddressController.isValidNonZero((String)this.ipText.getText())) {
            this.errorMessage = "The ipaddress is not valid";
        } else if (!Ipv4AddressAndMaskTextFactory.instance().checkComplete(this.subnetText)) {
            this.errorMessage = "The subnet you provided is not valid.";
        } else if (!Ipv4AddressController.isValidNetmask((String)this.netmaskText.getText())) {
            this.errorMessage = "The netmask you provided is not valid.";
        } else if (!Ipv4AddressController.isValidNonZero((String)this.defaultGatewayText.getText())) {
            this.errorMessage = " The default gateway you provided is not valid.";
        }
        return false;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

